package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpMethod;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.StreamUploader;
import com.github.davidmoten.odata.client.StreamUploaderChunked;
import com.github.davidmoten.odata.client.StreamUploaderSingleCall;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.UploadStrategy;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.ServiceUpdateMessageViewpoint;
import odata.msgraph.client.beta.entity.collection.request.ServiceAnnouncementAttachmentCollectionRequest;
import odata.msgraph.client.beta.enums.ServiceUpdateCategory;
import odata.msgraph.client.beta.enums.ServiceUpdateSeverity;

@JsonPropertyOrder({
    "@odata.type", 
    "actionRequiredByDateTime", 
    "attachmentsArchive", 
    "body", 
    "category", 
    "hasAttachments", 
    "isMajorChange", 
    "services", 
    "severity", 
    "tags", 
    "viewPoint", 
    "attachments"})
@JsonInclude(Include.NON_NULL)
public class ServiceUpdateMessage extends ServiceAnnouncementBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.serviceUpdateMessage";
    }

    @JsonProperty("actionRequiredByDateTime")
    protected OffsetDateTime actionRequiredByDateTime;

    @JsonProperty("attachmentsArchive")
    protected String attachmentsArchive;

    @JsonProperty("body")
    protected ItemBody body;

    @JsonProperty("category")
    protected ServiceUpdateCategory category;

    @JsonProperty("hasAttachments")
    protected Boolean hasAttachments;

    @JsonProperty("isMajorChange")
    protected Boolean isMajorChange;

    @JsonProperty("services")
    protected List<String> services;

    @JsonProperty("services@nextLink")
    protected String servicesNextLink;

    @JsonProperty("severity")
    protected ServiceUpdateSeverity severity;

    @JsonProperty("tags")
    protected List<String> tags;

    @JsonProperty("tags@nextLink")
    protected String tagsNextLink;

    @JsonProperty("viewPoint")
    protected ServiceUpdateMessageViewpoint viewPoint;

    @JsonProperty("attachments")
    protected List<ServiceAnnouncementAttachment> attachments;

    protected ServiceUpdateMessage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderServiceUpdateMessage() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<KeyValuePair> details;
        private String detailsNextLink;
        private OffsetDateTime endDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private OffsetDateTime startDateTime;
        private String title;
        private OffsetDateTime actionRequiredByDateTime;
        private String attachmentsArchive;
        private ItemBody body;
        private ServiceUpdateCategory category;
        private Boolean hasAttachments;
        private Boolean isMajorChange;
        private List<String> services;
        private String servicesNextLink;
        private ServiceUpdateSeverity severity;
        private List<String> tags;
        private String tagsNextLink;
        private ServiceUpdateMessageViewpoint viewPoint;
        private List<ServiceAnnouncementAttachment> attachments;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder details(List<KeyValuePair> details) {
            this.details = details;
            this.changedFields = changedFields.add("details");
            return this;
        }

        public Builder details(KeyValuePair... details) {
            return details(Arrays.asList(details));
        }

        public Builder detailsNextLink(String detailsNextLink) {
            this.detailsNextLink = detailsNextLink;
            this.changedFields = changedFields.add("details");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder actionRequiredByDateTime(OffsetDateTime actionRequiredByDateTime) {
            this.actionRequiredByDateTime = actionRequiredByDateTime;
            this.changedFields = changedFields.add("actionRequiredByDateTime");
            return this;
        }

        public Builder attachmentsArchive(String attachmentsArchive) {
            this.attachmentsArchive = attachmentsArchive;
            this.changedFields = changedFields.add("attachmentsArchive");
            return this;
        }

        public Builder body(ItemBody body) {
            this.body = body;
            this.changedFields = changedFields.add("body");
            return this;
        }

        public Builder category(ServiceUpdateCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder hasAttachments(Boolean hasAttachments) {
            this.hasAttachments = hasAttachments;
            this.changedFields = changedFields.add("hasAttachments");
            return this;
        }

        public Builder isMajorChange(Boolean isMajorChange) {
            this.isMajorChange = isMajorChange;
            this.changedFields = changedFields.add("isMajorChange");
            return this;
        }

        public Builder services(List<String> services) {
            this.services = services;
            this.changedFields = changedFields.add("services");
            return this;
        }

        public Builder services(String... services) {
            return services(Arrays.asList(services));
        }

        public Builder servicesNextLink(String servicesNextLink) {
            this.servicesNextLink = servicesNextLink;
            this.changedFields = changedFields.add("services");
            return this;
        }

        public Builder severity(ServiceUpdateSeverity severity) {
            this.severity = severity;
            this.changedFields = changedFields.add("severity");
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder tags(String... tags) {
            return tags(Arrays.asList(tags));
        }

        public Builder tagsNextLink(String tagsNextLink) {
            this.tagsNextLink = tagsNextLink;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder viewPoint(ServiceUpdateMessageViewpoint viewPoint) {
            this.viewPoint = viewPoint;
            this.changedFields = changedFields.add("viewPoint");
            return this;
        }

        public Builder attachments(List<ServiceAnnouncementAttachment> attachments) {
            this.attachments = attachments;
            this.changedFields = changedFields.add("attachments");
            return this;
        }

        public Builder attachments(ServiceAnnouncementAttachment... attachments) {
            return attachments(Arrays.asList(attachments));
        }

        public ServiceUpdateMessage build() {
            ServiceUpdateMessage _x = new ServiceUpdateMessage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.serviceUpdateMessage";
            _x.id = id;
            _x.details = details;
            _x.detailsNextLink = detailsNextLink;
            _x.endDateTime = endDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.startDateTime = startDateTime;
            _x.title = title;
            _x.actionRequiredByDateTime = actionRequiredByDateTime;
            _x.attachmentsArchive = attachmentsArchive;
            _x.body = body;
            _x.category = category;
            _x.hasAttachments = hasAttachments;
            _x.isMajorChange = isMajorChange;
            _x.services = services;
            _x.servicesNextLink = servicesNextLink;
            _x.severity = severity;
            _x.tags = tags;
            _x.tagsNextLink = tagsNextLink;
            _x.viewPoint = viewPoint;
            _x.attachments = attachments;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="actionRequiredByDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getActionRequiredByDateTime() {
        return Optional.ofNullable(actionRequiredByDateTime);
    }

    public ServiceUpdateMessage withActionRequiredByDateTime(OffsetDateTime actionRequiredByDateTime) {
        ServiceUpdateMessage _x = _copy();
        _x.changedFields = changedFields.add("actionRequiredByDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceUpdateMessage");
        _x.actionRequiredByDateTime = actionRequiredByDateTime;
        return _x;
    }

    @Property(name="attachmentsArchive")
    @JsonIgnore
    public Optional<StreamProvider> getAttachmentsArchive() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "attachmentsArchive", attachmentsArchive);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code attachmentsArchive} property, using HTTP POST.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="attachmentsArchive")
    public Optional<StreamUploaderSingleCall> postAttachmentsArchive() {
        return postAttachmentsArchive(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code attachmentsArchive} property, using HTTP POST.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="attachmentsArchive")
    public Optional<StreamUploaderChunked> postChunkedAttachmentsArchive() {
        return postAttachmentsArchive(UploadStrategy.chunked());
    }

    @Property(name="attachmentsArchive")
    public <T extends StreamUploader<T>> Optional<T> postAttachmentsArchive(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("attachmentsArchive"), this, "attachmentsArchive", HttpMethod.POST);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code attachmentsArchive} property, using HTTP PATCH.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="attachmentsArchive")
    public Optional<StreamUploaderSingleCall> patchAttachmentsArchive() {
        return patchAttachmentsArchive(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code attachmentsArchive} property, using HTTP PATCH.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="attachmentsArchive")
    public Optional<StreamUploaderChunked> patchChunkedAttachmentsArchive() {
        return patchAttachmentsArchive(UploadStrategy.chunked());
    }

    @Property(name="attachmentsArchive")
    public <T extends StreamUploader<T>> Optional<T> patchAttachmentsArchive(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("attachmentsArchive"), this, "attachmentsArchive", HttpMethod.PATCH);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code attachmentsArchive} property, using HTTP PUT.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="attachmentsArchive")
    public Optional<StreamUploaderSingleCall> putAttachmentsArchive() {
        return putAttachmentsArchive(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code attachmentsArchive} property, using HTTP PUT.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="attachmentsArchive")
    public Optional<StreamUploaderChunked> putChunkedAttachmentsArchive() {
        return putAttachmentsArchive(UploadStrategy.chunked());
    }

    @Property(name="attachmentsArchive")
    public <T extends StreamUploader<T>> Optional<T> putAttachmentsArchive(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("attachmentsArchive"), this, "attachmentsArchive", HttpMethod.PUT);
    }

    @Property(name="body")
    @JsonIgnore
    public Optional<ItemBody> getBody() {
        return Optional.ofNullable(body);
    }

    public ServiceUpdateMessage withBody(ItemBody body) {
        ServiceUpdateMessage _x = _copy();
        _x.changedFields = changedFields.add("body");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceUpdateMessage");
        _x.body = body;
        return _x;
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<ServiceUpdateCategory> getCategory() {
        return Optional.ofNullable(category);
    }

    public ServiceUpdateMessage withCategory(ServiceUpdateCategory category) {
        ServiceUpdateMessage _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceUpdateMessage");
        _x.category = category;
        return _x;
    }

    @Property(name="hasAttachments")
    @JsonIgnore
    public Optional<Boolean> getHasAttachments() {
        return Optional.ofNullable(hasAttachments);
    }

    public ServiceUpdateMessage withHasAttachments(Boolean hasAttachments) {
        ServiceUpdateMessage _x = _copy();
        _x.changedFields = changedFields.add("hasAttachments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceUpdateMessage");
        _x.hasAttachments = hasAttachments;
        return _x;
    }

    @Property(name="isMajorChange")
    @JsonIgnore
    public Optional<Boolean> getIsMajorChange() {
        return Optional.ofNullable(isMajorChange);
    }

    public ServiceUpdateMessage withIsMajorChange(Boolean isMajorChange) {
        ServiceUpdateMessage _x = _copy();
        _x.changedFields = changedFields.add("isMajorChange");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceUpdateMessage");
        _x.isMajorChange = isMajorChange;
        return _x;
    }

    @Property(name="services")
    @JsonIgnore
    public CollectionPage<String> getServices() {
        return new CollectionPage<String>(contextPath, String.class, this.services, Optional.ofNullable(servicesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ServiceUpdateMessage withServices(List<String> services) {
        ServiceUpdateMessage _x = _copy();
        _x.changedFields = changedFields.add("services");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceUpdateMessage");
        _x.services = services;
        return _x;
    }

    @Property(name="services")
    @JsonIgnore
    public CollectionPage<String> getServices(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.services, Optional.ofNullable(servicesNextLink), Collections.emptyList(), options);
    }

    @Property(name="severity")
    @JsonIgnore
    public Optional<ServiceUpdateSeverity> getSeverity() {
        return Optional.ofNullable(severity);
    }

    public ServiceUpdateMessage withSeverity(ServiceUpdateSeverity severity) {
        ServiceUpdateMessage _x = _copy();
        _x.changedFields = changedFields.add("severity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceUpdateMessage");
        _x.severity = severity;
        return _x;
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags() {
        return new CollectionPage<String>(contextPath, String.class, this.tags, Optional.ofNullable(tagsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ServiceUpdateMessage withTags(List<String> tags) {
        ServiceUpdateMessage _x = _copy();
        _x.changedFields = changedFields.add("tags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceUpdateMessage");
        _x.tags = tags;
        return _x;
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.tags, Optional.ofNullable(tagsNextLink), Collections.emptyList(), options);
    }

    @Property(name="viewPoint")
    @JsonIgnore
    public Optional<ServiceUpdateMessageViewpoint> getViewPoint() {
        return Optional.ofNullable(viewPoint);
    }

    public ServiceUpdateMessage withViewPoint(ServiceUpdateMessageViewpoint viewPoint) {
        ServiceUpdateMessage _x = _copy();
        _x.changedFields = changedFields.add("viewPoint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceUpdateMessage");
        _x.viewPoint = viewPoint;
        return _x;
    }

    public ServiceUpdateMessage withUnmappedField(String name, Object value) {
        ServiceUpdateMessage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="attachments")
    @JsonIgnore
    public ServiceAnnouncementAttachmentCollectionRequest getAttachments() {
        return new ServiceAnnouncementAttachmentCollectionRequest(
                        contextPath.addSegment("attachments"), Optional.ofNullable(attachments));
    }

    public ServiceUpdateMessage withAttachments(List<ServiceAnnouncementAttachment> attachments) {
        ServiceUpdateMessage _x = _copy();
        _x.changedFields = changedFields.add("attachments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceUpdateMessage");
        _x.attachments = attachments;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServiceUpdateMessage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ServiceUpdateMessage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServiceUpdateMessage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ServiceUpdateMessage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ServiceUpdateMessage _copy() {
        ServiceUpdateMessage _x = new ServiceUpdateMessage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.details = details;
        _x.endDateTime = endDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.startDateTime = startDateTime;
        _x.title = title;
        _x.actionRequiredByDateTime = actionRequiredByDateTime;
        _x.attachmentsArchive = attachmentsArchive;
        _x.body = body;
        _x.category = category;
        _x.hasAttachments = hasAttachments;
        _x.isMajorChange = isMajorChange;
        _x.services = services;
        _x.severity = severity;
        _x.tags = tags;
        _x.viewPoint = viewPoint;
        _x.attachments = attachments;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ServiceUpdateMessage[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("details=");
        b.append(this.details);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("actionRequiredByDateTime=");
        b.append(this.actionRequiredByDateTime);
        b.append(", ");
        b.append("attachmentsArchive=");
        b.append(this.attachmentsArchive);
        b.append(", ");
        b.append("body=");
        b.append(this.body);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("hasAttachments=");
        b.append(this.hasAttachments);
        b.append(", ");
        b.append("isMajorChange=");
        b.append(this.isMajorChange);
        b.append(", ");
        b.append("services=");
        b.append(this.services);
        b.append(", ");
        b.append("severity=");
        b.append(this.severity);
        b.append(", ");
        b.append("tags=");
        b.append(this.tags);
        b.append(", ");
        b.append("viewPoint=");
        b.append(this.viewPoint);
        b.append(", ");
        b.append("attachments=");
        b.append(this.attachments);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
