package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ServicePrincipalCreationConditionSetCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "isBuiltIn", 
    "excludes", 
    "includes"})
@JsonInclude(Include.NON_NULL)
public class ServicePrincipalCreationPolicy extends PolicyBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.servicePrincipalCreationPolicy";
    }

    @JsonProperty("isBuiltIn")
    protected Boolean isBuiltIn;

    @JsonProperty("excludes")
    protected List<ServicePrincipalCreationConditionSet> excludes;

    @JsonProperty("includes")
    protected List<ServicePrincipalCreationConditionSet> includes;

    protected ServicePrincipalCreationPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderServicePrincipalCreationPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private String description;
        private String displayName;
        private Boolean isBuiltIn;
        private List<ServicePrincipalCreationConditionSet> excludes;
        private List<ServicePrincipalCreationConditionSet> includes;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isBuiltIn(Boolean isBuiltIn) {
            this.isBuiltIn = isBuiltIn;
            this.changedFields = changedFields.add("isBuiltIn");
            return this;
        }

        public Builder excludes(List<ServicePrincipalCreationConditionSet> excludes) {
            this.excludes = excludes;
            this.changedFields = changedFields.add("excludes");
            return this;
        }

        public Builder excludes(ServicePrincipalCreationConditionSet... excludes) {
            return excludes(Arrays.asList(excludes));
        }

        public Builder includes(List<ServicePrincipalCreationConditionSet> includes) {
            this.includes = includes;
            this.changedFields = changedFields.add("includes");
            return this;
        }

        public Builder includes(ServicePrincipalCreationConditionSet... includes) {
            return includes(Arrays.asList(includes));
        }

        public ServicePrincipalCreationPolicy build() {
            ServicePrincipalCreationPolicy _x = new ServicePrincipalCreationPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.servicePrincipalCreationPolicy";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.isBuiltIn = isBuiltIn;
            _x.excludes = excludes;
            _x.includes = includes;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="isBuiltIn")
    @JsonIgnore
    public Optional<Boolean> getIsBuiltIn() {
        return Optional.ofNullable(isBuiltIn);
    }

    public ServicePrincipalCreationPolicy withIsBuiltIn(Boolean isBuiltIn) {
        ServicePrincipalCreationPolicy _x = _copy();
        _x.changedFields = changedFields.add("isBuiltIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipalCreationPolicy");
        _x.isBuiltIn = isBuiltIn;
        return _x;
    }

    public ServicePrincipalCreationPolicy withUnmappedField(String name, Object value) {
        ServicePrincipalCreationPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="excludes")
    @JsonIgnore
    public ServicePrincipalCreationConditionSetCollectionRequest getExcludes() {
        return new ServicePrincipalCreationConditionSetCollectionRequest(
                        contextPath.addSegment("excludes"), Optional.ofNullable(excludes));
    }

    @NavigationProperty(name="includes")
    @JsonIgnore
    public ServicePrincipalCreationConditionSetCollectionRequest getIncludes() {
        return new ServicePrincipalCreationConditionSetCollectionRequest(
                        contextPath.addSegment("includes"), Optional.ofNullable(includes));
    }

    public ServicePrincipalCreationPolicy withExcludes(List<ServicePrincipalCreationConditionSet> excludes) {
        ServicePrincipalCreationPolicy _x = _copy();
        _x.changedFields = changedFields.add("excludes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipalCreationPolicy");
        _x.excludes = excludes;
        return _x;
    }

    public ServicePrincipalCreationPolicy withIncludes(List<ServicePrincipalCreationConditionSet> includes) {
        ServicePrincipalCreationPolicy _x = _copy();
        _x.changedFields = changedFields.add("includes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipalCreationPolicy");
        _x.includes = includes;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServicePrincipalCreationPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ServicePrincipalCreationPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServicePrincipalCreationPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ServicePrincipalCreationPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ServicePrincipalCreationPolicy _copy() {
        ServicePrincipalCreationPolicy _x = new ServicePrincipalCreationPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.isBuiltIn = isBuiltIn;
        _x.excludes = excludes;
        _x.includes = includes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ServicePrincipalCreationPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isBuiltIn=");
        b.append(this.isBuiltIn);
        b.append(", ");
        b.append("excludes=");
        b.append(this.excludes);
        b.append(", ");
        b.append("includes=");
        b.append(this.includes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
