package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "applicationIds", 
    "applicationPublisherIds", 
    "applicationsFromVerifiedPublisherOnly", 
    "applicationTenantIds", 
    "certifiedApplicationsOnly"})
@JsonInclude(Include.NON_NULL)
public class ServicePrincipalCreationConditionSet extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.servicePrincipalCreationConditionSet";
    }

    @JsonProperty("applicationIds")
    protected List<String> applicationIds;

    @JsonProperty("applicationIds@nextLink")
    protected String applicationIdsNextLink;

    @JsonProperty("applicationPublisherIds")
    protected List<String> applicationPublisherIds;

    @JsonProperty("applicationPublisherIds@nextLink")
    protected String applicationPublisherIdsNextLink;

    @JsonProperty("applicationsFromVerifiedPublisherOnly")
    protected Boolean applicationsFromVerifiedPublisherOnly;

    @JsonProperty("applicationTenantIds")
    protected List<String> applicationTenantIds;

    @JsonProperty("applicationTenantIds@nextLink")
    protected String applicationTenantIdsNextLink;

    @JsonProperty("certifiedApplicationsOnly")
    protected Boolean certifiedApplicationsOnly;

    protected ServicePrincipalCreationConditionSet() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderServicePrincipalCreationConditionSet() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> applicationIds;
        private String applicationIdsNextLink;
        private List<String> applicationPublisherIds;
        private String applicationPublisherIdsNextLink;
        private Boolean applicationsFromVerifiedPublisherOnly;
        private List<String> applicationTenantIds;
        private String applicationTenantIdsNextLink;
        private Boolean certifiedApplicationsOnly;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder applicationIds(List<String> applicationIds) {
            this.applicationIds = applicationIds;
            this.changedFields = changedFields.add("applicationIds");
            return this;
        }

        public Builder applicationIds(String... applicationIds) {
            return applicationIds(Arrays.asList(applicationIds));
        }

        public Builder applicationIdsNextLink(String applicationIdsNextLink) {
            this.applicationIdsNextLink = applicationIdsNextLink;
            this.changedFields = changedFields.add("applicationIds");
            return this;
        }

        public Builder applicationPublisherIds(List<String> applicationPublisherIds) {
            this.applicationPublisherIds = applicationPublisherIds;
            this.changedFields = changedFields.add("applicationPublisherIds");
            return this;
        }

        public Builder applicationPublisherIds(String... applicationPublisherIds) {
            return applicationPublisherIds(Arrays.asList(applicationPublisherIds));
        }

        public Builder applicationPublisherIdsNextLink(String applicationPublisherIdsNextLink) {
            this.applicationPublisherIdsNextLink = applicationPublisherIdsNextLink;
            this.changedFields = changedFields.add("applicationPublisherIds");
            return this;
        }

        public Builder applicationsFromVerifiedPublisherOnly(Boolean applicationsFromVerifiedPublisherOnly) {
            this.applicationsFromVerifiedPublisherOnly = applicationsFromVerifiedPublisherOnly;
            this.changedFields = changedFields.add("applicationsFromVerifiedPublisherOnly");
            return this;
        }

        public Builder applicationTenantIds(List<String> applicationTenantIds) {
            this.applicationTenantIds = applicationTenantIds;
            this.changedFields = changedFields.add("applicationTenantIds");
            return this;
        }

        public Builder applicationTenantIds(String... applicationTenantIds) {
            return applicationTenantIds(Arrays.asList(applicationTenantIds));
        }

        public Builder applicationTenantIdsNextLink(String applicationTenantIdsNextLink) {
            this.applicationTenantIdsNextLink = applicationTenantIdsNextLink;
            this.changedFields = changedFields.add("applicationTenantIds");
            return this;
        }

        public Builder certifiedApplicationsOnly(Boolean certifiedApplicationsOnly) {
            this.certifiedApplicationsOnly = certifiedApplicationsOnly;
            this.changedFields = changedFields.add("certifiedApplicationsOnly");
            return this;
        }

        public ServicePrincipalCreationConditionSet build() {
            ServicePrincipalCreationConditionSet _x = new ServicePrincipalCreationConditionSet();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.servicePrincipalCreationConditionSet";
            _x.id = id;
            _x.applicationIds = applicationIds;
            _x.applicationIdsNextLink = applicationIdsNextLink;
            _x.applicationPublisherIds = applicationPublisherIds;
            _x.applicationPublisherIdsNextLink = applicationPublisherIdsNextLink;
            _x.applicationsFromVerifiedPublisherOnly = applicationsFromVerifiedPublisherOnly;
            _x.applicationTenantIds = applicationTenantIds;
            _x.applicationTenantIdsNextLink = applicationTenantIdsNextLink;
            _x.certifiedApplicationsOnly = certifiedApplicationsOnly;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="applicationIds")
    @JsonIgnore
    public CollectionPage<String> getApplicationIds() {
        return new CollectionPage<String>(contextPath, String.class, this.applicationIds, Optional.ofNullable(applicationIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ServicePrincipalCreationConditionSet withApplicationIds(List<String> applicationIds) {
        ServicePrincipalCreationConditionSet _x = _copy();
        _x.changedFields = changedFields.add("applicationIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipalCreationConditionSet");
        _x.applicationIds = applicationIds;
        return _x;
    }

    @Property(name="applicationIds")
    @JsonIgnore
    public CollectionPage<String> getApplicationIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.applicationIds, Optional.ofNullable(applicationIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="applicationPublisherIds")
    @JsonIgnore
    public CollectionPage<String> getApplicationPublisherIds() {
        return new CollectionPage<String>(contextPath, String.class, this.applicationPublisherIds, Optional.ofNullable(applicationPublisherIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ServicePrincipalCreationConditionSet withApplicationPublisherIds(List<String> applicationPublisherIds) {
        ServicePrincipalCreationConditionSet _x = _copy();
        _x.changedFields = changedFields.add("applicationPublisherIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipalCreationConditionSet");
        _x.applicationPublisherIds = applicationPublisherIds;
        return _x;
    }

    @Property(name="applicationPublisherIds")
    @JsonIgnore
    public CollectionPage<String> getApplicationPublisherIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.applicationPublisherIds, Optional.ofNullable(applicationPublisherIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="applicationsFromVerifiedPublisherOnly")
    @JsonIgnore
    public Optional<Boolean> getApplicationsFromVerifiedPublisherOnly() {
        return Optional.ofNullable(applicationsFromVerifiedPublisherOnly);
    }

    public ServicePrincipalCreationConditionSet withApplicationsFromVerifiedPublisherOnly(Boolean applicationsFromVerifiedPublisherOnly) {
        ServicePrincipalCreationConditionSet _x = _copy();
        _x.changedFields = changedFields.add("applicationsFromVerifiedPublisherOnly");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipalCreationConditionSet");
        _x.applicationsFromVerifiedPublisherOnly = applicationsFromVerifiedPublisherOnly;
        return _x;
    }

    @Property(name="applicationTenantIds")
    @JsonIgnore
    public CollectionPage<String> getApplicationTenantIds() {
        return new CollectionPage<String>(contextPath, String.class, this.applicationTenantIds, Optional.ofNullable(applicationTenantIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ServicePrincipalCreationConditionSet withApplicationTenantIds(List<String> applicationTenantIds) {
        ServicePrincipalCreationConditionSet _x = _copy();
        _x.changedFields = changedFields.add("applicationTenantIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipalCreationConditionSet");
        _x.applicationTenantIds = applicationTenantIds;
        return _x;
    }

    @Property(name="applicationTenantIds")
    @JsonIgnore
    public CollectionPage<String> getApplicationTenantIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.applicationTenantIds, Optional.ofNullable(applicationTenantIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="certifiedApplicationsOnly")
    @JsonIgnore
    public Optional<Boolean> getCertifiedApplicationsOnly() {
        return Optional.ofNullable(certifiedApplicationsOnly);
    }

    public ServicePrincipalCreationConditionSet withCertifiedApplicationsOnly(Boolean certifiedApplicationsOnly) {
        ServicePrincipalCreationConditionSet _x = _copy();
        _x.changedFields = changedFields.add("certifiedApplicationsOnly");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipalCreationConditionSet");
        _x.certifiedApplicationsOnly = certifiedApplicationsOnly;
        return _x;
    }

    public ServicePrincipalCreationConditionSet withUnmappedField(String name, Object value) {
        ServicePrincipalCreationConditionSet _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServicePrincipalCreationConditionSet patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ServicePrincipalCreationConditionSet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServicePrincipalCreationConditionSet put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ServicePrincipalCreationConditionSet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ServicePrincipalCreationConditionSet _copy() {
        ServicePrincipalCreationConditionSet _x = new ServicePrincipalCreationConditionSet();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.applicationIds = applicationIds;
        _x.applicationPublisherIds = applicationPublisherIds;
        _x.applicationsFromVerifiedPublisherOnly = applicationsFromVerifiedPublisherOnly;
        _x.applicationTenantIds = applicationTenantIds;
        _x.certifiedApplicationsOnly = certifiedApplicationsOnly;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ServicePrincipalCreationConditionSet[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("applicationIds=");
        b.append(this.applicationIds);
        b.append(", ");
        b.append("applicationPublisherIds=");
        b.append(this.applicationPublisherIds);
        b.append(", ");
        b.append("applicationsFromVerifiedPublisherOnly=");
        b.append(this.applicationsFromVerifiedPublisherOnly);
        b.append(", ");
        b.append("applicationTenantIds=");
        b.append(this.applicationTenantIds);
        b.append(", ");
        b.append("certifiedApplicationsOnly=");
        b.append(this.certifiedApplicationsOnly);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
