package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.FunctionRequestReturningStream;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.ServiceHealthIssuePost;
import odata.msgraph.client.beta.enums.ServiceHealthClassificationType;
import odata.msgraph.client.beta.enums.ServiceHealthOrigin;
import odata.msgraph.client.beta.enums.ServiceHealthStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "classification", 
    "feature", 
    "featureGroup", 
    "impactDescription", 
    "isResolved", 
    "origin", 
    "posts", 
    "service", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class ServiceHealthIssue extends ServiceAnnouncementBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.serviceHealthIssue";
    }

    @JsonProperty("classification")
    protected ServiceHealthClassificationType classification;

    @JsonProperty("feature")
    protected String feature;

    @JsonProperty("featureGroup")
    protected String featureGroup;

    @JsonProperty("impactDescription")
    protected String impactDescription;

    @JsonProperty("isResolved")
    protected Boolean isResolved;

    @JsonProperty("origin")
    protected ServiceHealthOrigin origin;

    @JsonProperty("posts")
    protected List<ServiceHealthIssuePost> posts;

    @JsonProperty("posts@nextLink")
    protected String postsNextLink;

    @JsonProperty("service")
    protected String service;

    @JsonProperty("status")
    protected ServiceHealthStatus status;

    protected ServiceHealthIssue() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderServiceHealthIssue() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<KeyValuePair> details;
        private String detailsNextLink;
        private OffsetDateTime endDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private OffsetDateTime startDateTime;
        private String title;
        private ServiceHealthClassificationType classification;
        private String feature;
        private String featureGroup;
        private String impactDescription;
        private Boolean isResolved;
        private ServiceHealthOrigin origin;
        private List<ServiceHealthIssuePost> posts;
        private String postsNextLink;
        private String service;
        private ServiceHealthStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder details(List<KeyValuePair> details) {
            this.details = details;
            this.changedFields = changedFields.add("details");
            return this;
        }

        public Builder details(KeyValuePair... details) {
            return details(Arrays.asList(details));
        }

        public Builder detailsNextLink(String detailsNextLink) {
            this.detailsNextLink = detailsNextLink;
            this.changedFields = changedFields.add("details");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder classification(ServiceHealthClassificationType classification) {
            this.classification = classification;
            this.changedFields = changedFields.add("classification");
            return this;
        }

        public Builder feature(String feature) {
            this.feature = feature;
            this.changedFields = changedFields.add("feature");
            return this;
        }

        public Builder featureGroup(String featureGroup) {
            this.featureGroup = featureGroup;
            this.changedFields = changedFields.add("featureGroup");
            return this;
        }

        public Builder impactDescription(String impactDescription) {
            this.impactDescription = impactDescription;
            this.changedFields = changedFields.add("impactDescription");
            return this;
        }

        public Builder isResolved(Boolean isResolved) {
            this.isResolved = isResolved;
            this.changedFields = changedFields.add("isResolved");
            return this;
        }

        public Builder origin(ServiceHealthOrigin origin) {
            this.origin = origin;
            this.changedFields = changedFields.add("origin");
            return this;
        }

        public Builder posts(List<ServiceHealthIssuePost> posts) {
            this.posts = posts;
            this.changedFields = changedFields.add("posts");
            return this;
        }

        public Builder posts(ServiceHealthIssuePost... posts) {
            return posts(Arrays.asList(posts));
        }

        public Builder postsNextLink(String postsNextLink) {
            this.postsNextLink = postsNextLink;
            this.changedFields = changedFields.add("posts");
            return this;
        }

        public Builder service(String service) {
            this.service = service;
            this.changedFields = changedFields.add("service");
            return this;
        }

        public Builder status(ServiceHealthStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public ServiceHealthIssue build() {
            ServiceHealthIssue _x = new ServiceHealthIssue();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.serviceHealthIssue";
            _x.id = id;
            _x.details = details;
            _x.detailsNextLink = detailsNextLink;
            _x.endDateTime = endDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.startDateTime = startDateTime;
            _x.title = title;
            _x.classification = classification;
            _x.feature = feature;
            _x.featureGroup = featureGroup;
            _x.impactDescription = impactDescription;
            _x.isResolved = isResolved;
            _x.origin = origin;
            _x.posts = posts;
            _x.postsNextLink = postsNextLink;
            _x.service = service;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="classification")
    @JsonIgnore
    public Optional<ServiceHealthClassificationType> getClassification() {
        return Optional.ofNullable(classification);
    }

    public ServiceHealthIssue withClassification(ServiceHealthClassificationType classification) {
        ServiceHealthIssue _x = _copy();
        _x.changedFields = changedFields.add("classification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceHealthIssue");
        _x.classification = classification;
        return _x;
    }

    @Property(name="feature")
    @JsonIgnore
    public Optional<String> getFeature() {
        return Optional.ofNullable(feature);
    }

    public ServiceHealthIssue withFeature(String feature) {
        ServiceHealthIssue _x = _copy();
        _x.changedFields = changedFields.add("feature");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceHealthIssue");
        _x.feature = feature;
        return _x;
    }

    @Property(name="featureGroup")
    @JsonIgnore
    public Optional<String> getFeatureGroup() {
        return Optional.ofNullable(featureGroup);
    }

    public ServiceHealthIssue withFeatureGroup(String featureGroup) {
        ServiceHealthIssue _x = _copy();
        _x.changedFields = changedFields.add("featureGroup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceHealthIssue");
        _x.featureGroup = featureGroup;
        return _x;
    }

    @Property(name="impactDescription")
    @JsonIgnore
    public Optional<String> getImpactDescription() {
        return Optional.ofNullable(impactDescription);
    }

    public ServiceHealthIssue withImpactDescription(String impactDescription) {
        ServiceHealthIssue _x = _copy();
        _x.changedFields = changedFields.add("impactDescription");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceHealthIssue");
        _x.impactDescription = impactDescription;
        return _x;
    }

    @Property(name="isResolved")
    @JsonIgnore
    public Optional<Boolean> getIsResolved() {
        return Optional.ofNullable(isResolved);
    }

    public ServiceHealthIssue withIsResolved(Boolean isResolved) {
        ServiceHealthIssue _x = _copy();
        _x.changedFields = changedFields.add("isResolved");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceHealthIssue");
        _x.isResolved = isResolved;
        return _x;
    }

    @Property(name="origin")
    @JsonIgnore
    public Optional<ServiceHealthOrigin> getOrigin() {
        return Optional.ofNullable(origin);
    }

    public ServiceHealthIssue withOrigin(ServiceHealthOrigin origin) {
        ServiceHealthIssue _x = _copy();
        _x.changedFields = changedFields.add("origin");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceHealthIssue");
        _x.origin = origin;
        return _x;
    }

    @Property(name="posts")
    @JsonIgnore
    public CollectionPage<ServiceHealthIssuePost> getPosts() {
        return new CollectionPage<ServiceHealthIssuePost>(contextPath, ServiceHealthIssuePost.class, this.posts, Optional.ofNullable(postsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ServiceHealthIssue withPosts(List<ServiceHealthIssuePost> posts) {
        ServiceHealthIssue _x = _copy();
        _x.changedFields = changedFields.add("posts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceHealthIssue");
        _x.posts = posts;
        return _x;
    }

    @Property(name="posts")
    @JsonIgnore
    public CollectionPage<ServiceHealthIssuePost> getPosts(HttpRequestOptions options) {
        return new CollectionPage<ServiceHealthIssuePost>(contextPath, ServiceHealthIssuePost.class, this.posts, Optional.ofNullable(postsNextLink), Collections.emptyList(), options);
    }

    @Property(name="service")
    @JsonIgnore
    public Optional<String> getService() {
        return Optional.ofNullable(service);
    }

    public ServiceHealthIssue withService(String service) {
        ServiceHealthIssue _x = _copy();
        _x.changedFields = changedFields.add("service");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceHealthIssue");
        _x.service = service;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<ServiceHealthStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public ServiceHealthIssue withStatus(ServiceHealthStatus status) {
        ServiceHealthIssue _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceHealthIssue");
        _x.status = status;
        return _x;
    }

    public ServiceHealthIssue withUnmappedField(String name, Object value) {
        ServiceHealthIssue _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServiceHealthIssue patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ServiceHealthIssue _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServiceHealthIssue put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ServiceHealthIssue _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ServiceHealthIssue _copy() {
        ServiceHealthIssue _x = new ServiceHealthIssue();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.details = details;
        _x.endDateTime = endDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.startDateTime = startDateTime;
        _x.title = title;
        _x.classification = classification;
        _x.feature = feature;
        _x.featureGroup = featureGroup;
        _x.impactDescription = impactDescription;
        _x.isResolved = isResolved;
        _x.origin = origin;
        _x.posts = posts;
        _x.service = service;
        _x.status = status;
        return _x;
    }

    @Function(name = "incidentReport")
    @JsonIgnore
    public FunctionRequestReturningStream incidentReport() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.incidentReport"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ServiceHealthIssue[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("details=");
        b.append(this.details);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("classification=");
        b.append(this.classification);
        b.append(", ");
        b.append("feature=");
        b.append(this.feature);
        b.append(", ");
        b.append("featureGroup=");
        b.append(this.featureGroup);
        b.append(", ");
        b.append("impactDescription=");
        b.append(this.impactDescription);
        b.append(", ");
        b.append("isResolved=");
        b.append(this.isResolved);
        b.append(", ");
        b.append("origin=");
        b.append(this.origin);
        b.append(", ");
        b.append("posts=");
        b.append(this.posts);
        b.append(", ");
        b.append("service=");
        b.append(this.service);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
