package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ServiceHealthIssueCollectionRequest;
import odata.msgraph.client.beta.enums.ServiceHealthStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "service", 
    "status", 
    "issues"})
@JsonInclude(Include.NON_NULL)
public class ServiceHealth extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.serviceHealth";
    }

    @JsonProperty("service")
    protected String service;

    @JsonProperty("status")
    protected ServiceHealthStatus status;

    @JsonProperty("issues")
    protected List<ServiceHealthIssue> issues;

    protected ServiceHealth() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderServiceHealth() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String service;
        private ServiceHealthStatus status;
        private List<ServiceHealthIssue> issues;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder service(String service) {
            this.service = service;
            this.changedFields = changedFields.add("service");
            return this;
        }

        public Builder status(ServiceHealthStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder issues(List<ServiceHealthIssue> issues) {
            this.issues = issues;
            this.changedFields = changedFields.add("issues");
            return this;
        }

        public Builder issues(ServiceHealthIssue... issues) {
            return issues(Arrays.asList(issues));
        }

        public ServiceHealth build() {
            ServiceHealth _x = new ServiceHealth();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.serviceHealth";
            _x.id = id;
            _x.service = service;
            _x.status = status;
            _x.issues = issues;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="service")
    @JsonIgnore
    public Optional<String> getService() {
        return Optional.ofNullable(service);
    }

    public ServiceHealth withService(String service) {
        ServiceHealth _x = _copy();
        _x.changedFields = changedFields.add("service");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceHealth");
        _x.service = service;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<ServiceHealthStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public ServiceHealth withStatus(ServiceHealthStatus status) {
        ServiceHealth _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceHealth");
        _x.status = status;
        return _x;
    }

    public ServiceHealth withUnmappedField(String name, Object value) {
        ServiceHealth _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="issues")
    @JsonIgnore
    public ServiceHealthIssueCollectionRequest getIssues() {
        return new ServiceHealthIssueCollectionRequest(
                        contextPath.addSegment("issues"), Optional.ofNullable(issues));
    }

    public ServiceHealth withIssues(List<ServiceHealthIssue> issues) {
        ServiceHealth _x = _copy();
        _x.changedFields = changedFields.add("issues");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceHealth");
        _x.issues = issues;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServiceHealth patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ServiceHealth _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServiceHealth put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ServiceHealth _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ServiceHealth _copy() {
        ServiceHealth _x = new ServiceHealth();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.service = service;
        _x.status = status;
        _x.issues = issues;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ServiceHealth[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("service=");
        b.append(this.service);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("issues=");
        b.append(this.issues);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
