package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValuePair;

@JsonPropertyOrder({
    "@odata.type", 
    "details", 
    "endDateTime", 
    "lastModifiedDateTime", 
    "startDateTime", 
    "title"})
@JsonInclude(Include.NON_NULL)
public class ServiceAnnouncementBase extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.serviceAnnouncementBase";
    }

    @JsonProperty("details")
    protected List<KeyValuePair> details;

    @JsonProperty("details@nextLink")
    protected String detailsNextLink;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("title")
    protected String title;

    protected ServiceAnnouncementBase() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="details")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getDetails() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.details, Optional.ofNullable(detailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ServiceAnnouncementBase withDetails(List<KeyValuePair> details) {
        ServiceAnnouncementBase _x = _copy();
        _x.changedFields = changedFields.add("details");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceAnnouncementBase");
        _x.details = details;
        return _x;
    }

    @Property(name="details")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getDetails(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.details, Optional.ofNullable(detailsNextLink), Collections.emptyList(), options);
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public ServiceAnnouncementBase withEndDateTime(OffsetDateTime endDateTime) {
        ServiceAnnouncementBase _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceAnnouncementBase");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public ServiceAnnouncementBase withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        ServiceAnnouncementBase _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceAnnouncementBase");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public ServiceAnnouncementBase withStartDateTime(OffsetDateTime startDateTime) {
        ServiceAnnouncementBase _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceAnnouncementBase");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public ServiceAnnouncementBase withTitle(String title) {
        ServiceAnnouncementBase _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceAnnouncementBase");
        _x.title = title;
        return _x;
    }

    public ServiceAnnouncementBase withUnmappedField(String name, Object value) {
        ServiceAnnouncementBase _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServiceAnnouncementBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ServiceAnnouncementBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServiceAnnouncementBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ServiceAnnouncementBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ServiceAnnouncementBase _copy() {
        ServiceAnnouncementBase _x = new ServiceAnnouncementBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.details = details;
        _x.endDateTime = endDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.startDateTime = startDateTime;
        _x.title = title;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ServiceAnnouncementBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("details=");
        b.append(this.details);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
