package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.entity.collection.request.VulnerableManagedDeviceCollectionRequest;
import odata.msgraph.client.beta.enums.DeviceAppManagementTaskCategory;
import odata.msgraph.client.beta.enums.DeviceAppManagementTaskPriority;
import odata.msgraph.client.beta.enums.DeviceAppManagementTaskStatus;
import odata.msgraph.client.beta.enums.EndpointSecurityConfigurationApplicablePlatform;
import odata.msgraph.client.beta.enums.EndpointSecurityConfigurationProfileType;
import odata.msgraph.client.beta.enums.EndpointSecurityConfigurationType;


/**
 * <i>“A security configuration task.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "applicablePlatform", 
    "endpointSecurityPolicy", 
    "endpointSecurityPolicyProfile", 
    "insights", 
    "intendedSettings", 
    "managedDeviceCount"})
@JsonInclude(Include.NON_NULL)
public class SecurityConfigurationTask extends DeviceAppManagementTask implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.securityConfigurationTask";
    }

    @JsonProperty("applicablePlatform")
    protected EndpointSecurityConfigurationApplicablePlatform applicablePlatform;

    @JsonProperty("endpointSecurityPolicy")
    protected EndpointSecurityConfigurationType endpointSecurityPolicy;

    @JsonProperty("endpointSecurityPolicyProfile")
    protected EndpointSecurityConfigurationProfileType endpointSecurityPolicyProfile;

    @JsonProperty("insights")
    protected String insights;

    @JsonProperty("intendedSettings")
    protected List<KeyValuePair> intendedSettings;

    @JsonProperty("intendedSettings@nextLink")
    protected String intendedSettingsNextLink;

    @JsonProperty("managedDeviceCount")
    protected Integer managedDeviceCount;

    protected SecurityConfigurationTask() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSecurityConfigurationTask() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String assignedTo;
        private DeviceAppManagementTaskCategory category;
        private OffsetDateTime createdDateTime;
        private String creator;
        private String creatorNotes;
        private String description;
        private String displayName;
        private OffsetDateTime dueDateTime;
        private DeviceAppManagementTaskPriority priority;
        private DeviceAppManagementTaskStatus status;
        private EndpointSecurityConfigurationApplicablePlatform applicablePlatform;
        private EndpointSecurityConfigurationType endpointSecurityPolicy;
        private EndpointSecurityConfigurationProfileType endpointSecurityPolicyProfile;
        private String insights;
        private List<KeyValuePair> intendedSettings;
        private String intendedSettingsNextLink;
        private Integer managedDeviceCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder assignedTo(String assignedTo) {
            this.assignedTo = assignedTo;
            this.changedFields = changedFields.add("assignedTo");
            return this;
        }

        public Builder category(DeviceAppManagementTaskCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder creator(String creator) {
            this.creator = creator;
            this.changedFields = changedFields.add("creator");
            return this;
        }

        public Builder creatorNotes(String creatorNotes) {
            this.creatorNotes = creatorNotes;
            this.changedFields = changedFields.add("creatorNotes");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder dueDateTime(OffsetDateTime dueDateTime) {
            this.dueDateTime = dueDateTime;
            this.changedFields = changedFields.add("dueDateTime");
            return this;
        }

        public Builder priority(DeviceAppManagementTaskPriority priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder status(DeviceAppManagementTaskStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        /**
         * <i>“The applicable platform.”</i>
         * 
         * @param applicablePlatform
         *            value of {@code applicablePlatform} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicablePlatform(EndpointSecurityConfigurationApplicablePlatform applicablePlatform) {
            this.applicablePlatform = applicablePlatform;
            this.changedFields = changedFields.add("applicablePlatform");
            return this;
        }

        /**
         * <i>“The endpoint security policy type.”</i>
         * 
         * @param endpointSecurityPolicy
         *            value of {@code endpointSecurityPolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder endpointSecurityPolicy(EndpointSecurityConfigurationType endpointSecurityPolicy) {
            this.endpointSecurityPolicy = endpointSecurityPolicy;
            this.changedFields = changedFields.add("endpointSecurityPolicy");
            return this;
        }

        /**
         * <i>“The endpoint security policy profile.”</i>
         * 
         * @param endpointSecurityPolicyProfile
         *            value of {@code endpointSecurityPolicyProfile} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder endpointSecurityPolicyProfile(EndpointSecurityConfigurationProfileType endpointSecurityPolicyProfile) {
            this.endpointSecurityPolicyProfile = endpointSecurityPolicyProfile;
            this.changedFields = changedFields.add("endpointSecurityPolicyProfile");
            return this;
        }

        /**
         * <i>“Information about the mitigation.”</i>
         * 
         * @param insights
         *            value of {@code insights} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder insights(String insights) {
            this.insights = insights;
            this.changedFields = changedFields.add("insights");
            return this;
        }

        /**
         * <i>“The intended settings and their values.”</i>
         * 
         * @param intendedSettings
         *            value of {@code intendedSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intendedSettings(List<KeyValuePair> intendedSettings) {
            this.intendedSettings = intendedSettings;
            this.changedFields = changedFields.add("intendedSettings");
            return this;
        }

        /**
         * <i>“The intended settings and their values.”</i>
         * 
         * @param intendedSettings
         *            value of {@code intendedSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intendedSettings(KeyValuePair... intendedSettings) {
            return intendedSettings(Arrays.asList(intendedSettings));
        }

        /**
         * <i>“The intended settings and their values.”</i>
         * 
         * @param intendedSettingsNextLink
         *            value of {@code intendedSettings@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intendedSettingsNextLink(String intendedSettingsNextLink) {
            this.intendedSettingsNextLink = intendedSettingsNextLink;
            this.changedFields = changedFields.add("intendedSettings");
            return this;
        }

        /**
         * <i>“The number of vulnerable devices.”</i>
         * 
         * @param managedDeviceCount
         *            value of {@code managedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceCount(Integer managedDeviceCount) {
            this.managedDeviceCount = managedDeviceCount;
            this.changedFields = changedFields.add("managedDeviceCount");
            return this;
        }

        public SecurityConfigurationTask build() {
            SecurityConfigurationTask _x = new SecurityConfigurationTask();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.securityConfigurationTask";
            _x.id = id;
            _x.assignedTo = assignedTo;
            _x.category = category;
            _x.createdDateTime = createdDateTime;
            _x.creator = creator;
            _x.creatorNotes = creatorNotes;
            _x.description = description;
            _x.displayName = displayName;
            _x.dueDateTime = dueDateTime;
            _x.priority = priority;
            _x.status = status;
            _x.applicablePlatform = applicablePlatform;
            _x.endpointSecurityPolicy = endpointSecurityPolicy;
            _x.endpointSecurityPolicyProfile = endpointSecurityPolicyProfile;
            _x.insights = insights;
            _x.intendedSettings = intendedSettings;
            _x.intendedSettingsNextLink = intendedSettingsNextLink;
            _x.managedDeviceCount = managedDeviceCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The applicable platform.”</i>
     * 
     * @return property applicablePlatform
     */
    @Property(name="applicablePlatform")
    @JsonIgnore
    public Optional<EndpointSecurityConfigurationApplicablePlatform> getApplicablePlatform() {
        return Optional.ofNullable(applicablePlatform);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicablePlatform} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The applicable platform.”</i>
     * 
     * @param applicablePlatform
     *            new value of {@code applicablePlatform} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicablePlatform} field changed
     */
    public SecurityConfigurationTask withApplicablePlatform(EndpointSecurityConfigurationApplicablePlatform applicablePlatform) {
        SecurityConfigurationTask _x = _copy();
        _x.changedFields = changedFields.add("applicablePlatform");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityConfigurationTask");
        _x.applicablePlatform = applicablePlatform;
        return _x;
    }

    /**
     * <i>“The endpoint security policy type.”</i>
     * 
     * @return property endpointSecurityPolicy
     */
    @Property(name="endpointSecurityPolicy")
    @JsonIgnore
    public Optional<EndpointSecurityConfigurationType> getEndpointSecurityPolicy() {
        return Optional.ofNullable(endpointSecurityPolicy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * endpointSecurityPolicy} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The endpoint security policy type.”</i>
     * 
     * @param endpointSecurityPolicy
     *            new value of {@code endpointSecurityPolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code endpointSecurityPolicy} field changed
     */
    public SecurityConfigurationTask withEndpointSecurityPolicy(EndpointSecurityConfigurationType endpointSecurityPolicy) {
        SecurityConfigurationTask _x = _copy();
        _x.changedFields = changedFields.add("endpointSecurityPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityConfigurationTask");
        _x.endpointSecurityPolicy = endpointSecurityPolicy;
        return _x;
    }

    /**
     * <i>“The endpoint security policy profile.”</i>
     * 
     * @return property endpointSecurityPolicyProfile
     */
    @Property(name="endpointSecurityPolicyProfile")
    @JsonIgnore
    public Optional<EndpointSecurityConfigurationProfileType> getEndpointSecurityPolicyProfile() {
        return Optional.ofNullable(endpointSecurityPolicyProfile);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * endpointSecurityPolicyProfile} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The endpoint security policy profile.”</i>
     * 
     * @param endpointSecurityPolicyProfile
     *            new value of {@code endpointSecurityPolicyProfile} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code endpointSecurityPolicyProfile} field changed
     */
    public SecurityConfigurationTask withEndpointSecurityPolicyProfile(EndpointSecurityConfigurationProfileType endpointSecurityPolicyProfile) {
        SecurityConfigurationTask _x = _copy();
        _x.changedFields = changedFields.add("endpointSecurityPolicyProfile");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityConfigurationTask");
        _x.endpointSecurityPolicyProfile = endpointSecurityPolicyProfile;
        return _x;
    }

    /**
     * <i>“Information about the mitigation.”</i>
     * 
     * @return property insights
     */
    @Property(name="insights")
    @JsonIgnore
    public Optional<String> getInsights() {
        return Optional.ofNullable(insights);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code insights} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Information about the mitigation.”</i>
     * 
     * @param insights
     *            new value of {@code insights} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code insights} field changed
     */
    public SecurityConfigurationTask withInsights(String insights) {
        SecurityConfigurationTask _x = _copy();
        _x.changedFields = changedFields.add("insights");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityConfigurationTask");
        _x.insights = insights;
        return _x;
    }

    /**
     * <i>“The intended settings and their values.”</i>
     * 
     * @return property intendedSettings
     */
    @Property(name="intendedSettings")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getIntendedSettings() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.intendedSettings, Optional.ofNullable(intendedSettingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code intendedSettings}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The intended settings and their values.”</i>
     * 
     * @param intendedSettings
     *            new value of {@code intendedSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code intendedSettings} field changed
     */
    public SecurityConfigurationTask withIntendedSettings(List<KeyValuePair> intendedSettings) {
        SecurityConfigurationTask _x = _copy();
        _x.changedFields = changedFields.add("intendedSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityConfigurationTask");
        _x.intendedSettings = intendedSettings;
        return _x;
    }

    /**
     * <i>“The intended settings and their values.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property intendedSettings
     */
    @Property(name="intendedSettings")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getIntendedSettings(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.intendedSettings, Optional.ofNullable(intendedSettingsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The number of vulnerable devices.”</i>
     * 
     * @return property managedDeviceCount
     */
    @Property(name="managedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getManagedDeviceCount() {
        return Optional.ofNullable(managedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The number of vulnerable devices.”</i>
     * 
     * @param managedDeviceCount
     *            new value of {@code managedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceCount} field changed
     */
    public SecurityConfigurationTask withManagedDeviceCount(Integer managedDeviceCount) {
        SecurityConfigurationTask _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityConfigurationTask");
        _x.managedDeviceCount = managedDeviceCount;
        return _x;
    }

    public SecurityConfigurationTask withUnmappedField(String name, Object value) {
        SecurityConfigurationTask _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The vulnerable managed devices.”</i>
     * 
     * @return navigational property managedDevices
     */
    @NavigationProperty(name="managedDevices")
    @JsonIgnore
    public VulnerableManagedDeviceCollectionRequest getManagedDevices() {
        return new VulnerableManagedDeviceCollectionRequest(
                        contextPath.addSegment("managedDevices"), RequestHelper.getValue(unmappedFields, "managedDevices"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityConfigurationTask patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SecurityConfigurationTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityConfigurationTask put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SecurityConfigurationTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SecurityConfigurationTask _copy() {
        SecurityConfigurationTask _x = new SecurityConfigurationTask();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.assignedTo = assignedTo;
        _x.category = category;
        _x.createdDateTime = createdDateTime;
        _x.creator = creator;
        _x.creatorNotes = creatorNotes;
        _x.description = description;
        _x.displayName = displayName;
        _x.dueDateTime = dueDateTime;
        _x.priority = priority;
        _x.status = status;
        _x.applicablePlatform = applicablePlatform;
        _x.endpointSecurityPolicy = endpointSecurityPolicy;
        _x.endpointSecurityPolicyProfile = endpointSecurityPolicyProfile;
        _x.insights = insights;
        _x.intendedSettings = intendedSettings;
        _x.managedDeviceCount = managedDeviceCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SecurityConfigurationTask[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("assignedTo=");
        b.append(this.assignedTo);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("creator=");
        b.append(this.creator);
        b.append(", ");
        b.append("creatorNotes=");
        b.append(this.creatorNotes);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("dueDateTime=");
        b.append(this.dueDateTime);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("applicablePlatform=");
        b.append(this.applicablePlatform);
        b.append(", ");
        b.append("endpointSecurityPolicy=");
        b.append(this.endpointSecurityPolicy);
        b.append(", ");
        b.append("endpointSecurityPolicyProfile=");
        b.append(this.endpointSecurityPolicyProfile);
        b.append(", ");
        b.append("insights=");
        b.append(this.insights);
        b.append(", ");
        b.append("intendedSettings=");
        b.append(this.intendedSettings);
        b.append(", ");
        b.append("managedDeviceCount=");
        b.append(this.managedDeviceCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
