package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.SecurityBaselineCategoryStateSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecurityBaselineDeviceStateCollectionRequest;
import odata.msgraph.client.beta.entity.request.SecurityBaselineStateSummaryRequest;
import odata.msgraph.client.beta.enums.DeviceManagementTemplateSubtype;
import odata.msgraph.client.beta.enums.DeviceManagementTemplateType;
import odata.msgraph.client.beta.enums.PolicyPlatformType;


/**
 * <i>“The security baseline template of the account”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "categoryDeviceStateSummaries", 
    "deviceStates", 
    "deviceStateSummary"})
@JsonInclude(Include.NON_NULL)
public class SecurityBaselineTemplate extends DeviceManagementTemplate implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.securityBaselineTemplate";
    }

    @JsonProperty("categoryDeviceStateSummaries")
    protected List<SecurityBaselineCategoryStateSummary> categoryDeviceStateSummaries;

    @JsonProperty("deviceStates")
    protected List<SecurityBaselineDeviceState> deviceStates;

    @JsonProperty("deviceStateSummary")
    protected SecurityBaselineStateSummary deviceStateSummary;

    protected SecurityBaselineTemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSecurityBaselineTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String displayName;
        private Integer intentCount;
        private Boolean isDeprecated;
        private PolicyPlatformType platformType;
        private OffsetDateTime publishedDateTime;
        private DeviceManagementTemplateSubtype templateSubtype;
        private DeviceManagementTemplateType templateType;
        private String versionInfo;
        private List<DeviceManagementTemplateSettingCategory> categories;
        private List<DeviceManagementTemplate> migratableTo;
        private List<DeviceManagementSettingInstance> settings;
        private List<SecurityBaselineCategoryStateSummary> categoryDeviceStateSummaries;
        private List<SecurityBaselineDeviceState> deviceStates;
        private SecurityBaselineStateSummary deviceStateSummary;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder intentCount(Integer intentCount) {
            this.intentCount = intentCount;
            this.changedFields = changedFields.add("intentCount");
            return this;
        }

        public Builder isDeprecated(Boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
            this.changedFields = changedFields.add("isDeprecated");
            return this;
        }

        public Builder platformType(PolicyPlatformType platformType) {
            this.platformType = platformType;
            this.changedFields = changedFields.add("platformType");
            return this;
        }

        public Builder publishedDateTime(OffsetDateTime publishedDateTime) {
            this.publishedDateTime = publishedDateTime;
            this.changedFields = changedFields.add("publishedDateTime");
            return this;
        }

        public Builder templateSubtype(DeviceManagementTemplateSubtype templateSubtype) {
            this.templateSubtype = templateSubtype;
            this.changedFields = changedFields.add("templateSubtype");
            return this;
        }

        public Builder templateType(DeviceManagementTemplateType templateType) {
            this.templateType = templateType;
            this.changedFields = changedFields.add("templateType");
            return this;
        }

        public Builder versionInfo(String versionInfo) {
            this.versionInfo = versionInfo;
            this.changedFields = changedFields.add("versionInfo");
            return this;
        }

        public Builder categories(List<DeviceManagementTemplateSettingCategory> categories) {
            this.categories = categories;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder categories(DeviceManagementTemplateSettingCategory... categories) {
            return categories(Arrays.asList(categories));
        }

        public Builder migratableTo(List<DeviceManagementTemplate> migratableTo) {
            this.migratableTo = migratableTo;
            this.changedFields = changedFields.add("migratableTo");
            return this;
        }

        public Builder migratableTo(DeviceManagementTemplate... migratableTo) {
            return migratableTo(Arrays.asList(migratableTo));
        }

        public Builder settings(List<DeviceManagementSettingInstance> settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public Builder settings(DeviceManagementSettingInstance... settings) {
            return settings(Arrays.asList(settings));
        }

        /**
         * <i>“The security baseline per category device state summary”</i>
         * 
         * @param categoryDeviceStateSummaries
         *            value of {@code categoryDeviceStateSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder categoryDeviceStateSummaries(List<SecurityBaselineCategoryStateSummary> categoryDeviceStateSummaries) {
            this.categoryDeviceStateSummaries = categoryDeviceStateSummaries;
            this.changedFields = changedFields.add("categoryDeviceStateSummaries");
            return this;
        }

        /**
         * <i>“The security baseline per category device state summary”</i>
         * 
         * @param categoryDeviceStateSummaries
         *            value of {@code categoryDeviceStateSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder categoryDeviceStateSummaries(SecurityBaselineCategoryStateSummary... categoryDeviceStateSummaries) {
            return categoryDeviceStateSummaries(Arrays.asList(categoryDeviceStateSummaries));
        }

        /**
         * <i>“The security baseline device states”</i>
         * 
         * @param deviceStates
         *            value of {@code deviceStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceStates(List<SecurityBaselineDeviceState> deviceStates) {
            this.deviceStates = deviceStates;
            this.changedFields = changedFields.add("deviceStates");
            return this;
        }

        /**
         * <i>“The security baseline device states”</i>
         * 
         * @param deviceStates
         *            value of {@code deviceStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceStates(SecurityBaselineDeviceState... deviceStates) {
            return deviceStates(Arrays.asList(deviceStates));
        }

        /**
         * <i>“The security baseline device state summary”</i>
         * 
         * @param deviceStateSummary
         *            value of {@code deviceStateSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceStateSummary(SecurityBaselineStateSummary deviceStateSummary) {
            this.deviceStateSummary = deviceStateSummary;
            this.changedFields = changedFields.add("deviceStateSummary");
            return this;
        }

        public SecurityBaselineTemplate build() {
            SecurityBaselineTemplate _x = new SecurityBaselineTemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.securityBaselineTemplate";
            _x.id = id;
            _x.description = description;
            _x.displayName = displayName;
            _x.intentCount = intentCount;
            _x.isDeprecated = isDeprecated;
            _x.platformType = platformType;
            _x.publishedDateTime = publishedDateTime;
            _x.templateSubtype = templateSubtype;
            _x.templateType = templateType;
            _x.versionInfo = versionInfo;
            _x.categories = categories;
            _x.migratableTo = migratableTo;
            _x.settings = settings;
            _x.categoryDeviceStateSummaries = categoryDeviceStateSummaries;
            _x.deviceStates = deviceStates;
            _x.deviceStateSummary = deviceStateSummary;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public SecurityBaselineTemplate withUnmappedField(String name, Object value) {
        SecurityBaselineTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The security baseline per category device state summary”</i>
     * 
     * @return navigational property categoryDeviceStateSummaries
     */
    @NavigationProperty(name="categoryDeviceStateSummaries")
    @JsonIgnore
    public SecurityBaselineCategoryStateSummaryCollectionRequest getCategoryDeviceStateSummaries() {
        return new SecurityBaselineCategoryStateSummaryCollectionRequest(
                        contextPath.addSegment("categoryDeviceStateSummaries"), Optional.ofNullable(categoryDeviceStateSummaries));
    }

    /**
     * <i>“The security baseline device states”</i>
     * 
     * @return navigational property deviceStates
     */
    @NavigationProperty(name="deviceStates")
    @JsonIgnore
    public SecurityBaselineDeviceStateCollectionRequest getDeviceStates() {
        return new SecurityBaselineDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceStates"), Optional.ofNullable(deviceStates));
    }

    /**
     * <i>“The security baseline device state summary”</i>
     * 
     * @return navigational property deviceStateSummary
     */
    @NavigationProperty(name="deviceStateSummary")
    @JsonIgnore
    public SecurityBaselineStateSummaryRequest getDeviceStateSummary() {
        return new SecurityBaselineStateSummaryRequest(contextPath.addSegment("deviceStateSummary"), Optional.ofNullable(deviceStateSummary));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * categoryDeviceStateSummaries} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The security baseline per category device state summary”</i>
     * 
     * @param categoryDeviceStateSummaries
     *            new value of {@code categoryDeviceStateSummaries} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code categoryDeviceStateSummaries} field changed
     */
    public SecurityBaselineTemplate withCategoryDeviceStateSummaries(List<SecurityBaselineCategoryStateSummary> categoryDeviceStateSummaries) {
        SecurityBaselineTemplate _x = _copy();
        _x.changedFields = changedFields.add("categoryDeviceStateSummaries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineTemplate");
        _x.categoryDeviceStateSummaries = categoryDeviceStateSummaries;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceStates}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The security baseline device states”</i>
     * 
     * @param deviceStates
     *            new value of {@code deviceStates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceStates} field changed
     */
    public SecurityBaselineTemplate withDeviceStates(List<SecurityBaselineDeviceState> deviceStates) {
        SecurityBaselineTemplate _x = _copy();
        _x.changedFields = changedFields.add("deviceStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineTemplate");
        _x.deviceStates = deviceStates;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceStateSummary} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The security baseline device state summary”</i>
     * 
     * @param deviceStateSummary
     *            new value of {@code deviceStateSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceStateSummary} field changed
     */
    public SecurityBaselineTemplate withDeviceStateSummary(SecurityBaselineStateSummary deviceStateSummary) {
        SecurityBaselineTemplate _x = _copy();
        _x.changedFields = changedFields.add("deviceStateSummary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineTemplate");
        _x.deviceStateSummary = deviceStateSummary;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityBaselineTemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SecurityBaselineTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityBaselineTemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SecurityBaselineTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SecurityBaselineTemplate _copy() {
        SecurityBaselineTemplate _x = new SecurityBaselineTemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.intentCount = intentCount;
        _x.isDeprecated = isDeprecated;
        _x.platformType = platformType;
        _x.publishedDateTime = publishedDateTime;
        _x.templateSubtype = templateSubtype;
        _x.templateType = templateType;
        _x.versionInfo = versionInfo;
        _x.categories = categories;
        _x.migratableTo = migratableTo;
        _x.settings = settings;
        _x.categoryDeviceStateSummaries = categoryDeviceStateSummaries;
        _x.deviceStates = deviceStates;
        _x.deviceStateSummary = deviceStateSummary;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SecurityBaselineTemplate[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("intentCount=");
        b.append(this.intentCount);
        b.append(", ");
        b.append("isDeprecated=");
        b.append(this.isDeprecated);
        b.append(", ");
        b.append("platformType=");
        b.append(this.platformType);
        b.append(", ");
        b.append("publishedDateTime=");
        b.append(this.publishedDateTime);
        b.append(", ");
        b.append("templateSubtype=");
        b.append(this.templateSubtype);
        b.append(", ");
        b.append("templateType=");
        b.append(this.templateType);
        b.append(", ");
        b.append("versionInfo=");
        b.append(this.versionInfo);
        b.append(", ");
        b.append("categories=");
        b.append(this.categories);
        b.append(", ");
        b.append("migratableTo=");
        b.append(this.migratableTo);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append(", ");
        b.append("categoryDeviceStateSummaries=");
        b.append(this.categoryDeviceStateSummaries);
        b.append(", ");
        b.append("deviceStates=");
        b.append(this.deviceStates);
        b.append(", ");
        b.append("deviceStateSummary=");
        b.append(this.deviceStateSummary);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
