package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.entity.collection.request.OnenoteSectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SectionGroupCollectionRequest;
import odata.msgraph.client.beta.entity.request.NotebookRequest;
import odata.msgraph.client.beta.entity.request.SectionGroupRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "sectionGroupsUrl", 
    "sectionsUrl", 
    "parentNotebook", 
    "parentSectionGroup", 
    "sectionGroups", 
    "sections"})
@JsonInclude(Include.NON_NULL)
public class SectionGroup extends OnenoteEntityHierarchyModel implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sectionGroup";
    }

    @JsonProperty("sectionGroupsUrl")
    protected String sectionGroupsUrl;

    @JsonProperty("sectionsUrl")
    protected String sectionsUrl;

    @JsonProperty("parentNotebook")
    protected Notebook parentNotebook;

    @JsonProperty("parentSectionGroup")
    protected SectionGroup parentSectionGroup;

    @JsonProperty("sectionGroups")
    protected List<SectionGroup> sectionGroups;

    @JsonProperty("sections")
    protected List<OnenoteSection> sections;

    protected SectionGroup() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSectionGroup() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String self;
        private OffsetDateTime createdDateTime;
        private IdentitySet createdBy;
        private String displayName;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private String sectionGroupsUrl;
        private String sectionsUrl;
        private Notebook parentNotebook;
        private SectionGroup parentSectionGroup;
        private List<SectionGroup> sectionGroups;
        private List<OnenoteSection> sections;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder self(String self) {
            this.self = self;
            this.changedFields = changedFields.add("self");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder sectionGroupsUrl(String sectionGroupsUrl) {
            this.sectionGroupsUrl = sectionGroupsUrl;
            this.changedFields = changedFields.add("sectionGroupsUrl");
            return this;
        }

        public Builder sectionsUrl(String sectionsUrl) {
            this.sectionsUrl = sectionsUrl;
            this.changedFields = changedFields.add("sectionsUrl");
            return this;
        }

        public Builder parentNotebook(Notebook parentNotebook) {
            this.parentNotebook = parentNotebook;
            this.changedFields = changedFields.add("parentNotebook");
            return this;
        }

        public Builder parentSectionGroup(SectionGroup parentSectionGroup) {
            this.parentSectionGroup = parentSectionGroup;
            this.changedFields = changedFields.add("parentSectionGroup");
            return this;
        }

        public Builder sectionGroups(List<SectionGroup> sectionGroups) {
            this.sectionGroups = sectionGroups;
            this.changedFields = changedFields.add("sectionGroups");
            return this;
        }

        public Builder sectionGroups(SectionGroup... sectionGroups) {
            return sectionGroups(Arrays.asList(sectionGroups));
        }

        public Builder sections(List<OnenoteSection> sections) {
            this.sections = sections;
            this.changedFields = changedFields.add("sections");
            return this;
        }

        public Builder sections(OnenoteSection... sections) {
            return sections(Arrays.asList(sections));
        }

        public SectionGroup build() {
            SectionGroup _x = new SectionGroup();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.sectionGroup";
            _x.id = id;
            _x.self = self;
            _x.createdDateTime = createdDateTime;
            _x.createdBy = createdBy;
            _x.displayName = displayName;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.sectionGroupsUrl = sectionGroupsUrl;
            _x.sectionsUrl = sectionsUrl;
            _x.parentNotebook = parentNotebook;
            _x.parentSectionGroup = parentSectionGroup;
            _x.sectionGroups = sectionGroups;
            _x.sections = sections;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="sectionGroupsUrl")
    @JsonIgnore
    public Optional<String> getSectionGroupsUrl() {
        return Optional.ofNullable(sectionGroupsUrl);
    }

    public SectionGroup withSectionGroupsUrl(String sectionGroupsUrl) {
        SectionGroup _x = _copy();
        _x.changedFields = changedFields.add("sectionGroupsUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sectionGroup");
        _x.sectionGroupsUrl = sectionGroupsUrl;
        return _x;
    }

    @Property(name="sectionsUrl")
    @JsonIgnore
    public Optional<String> getSectionsUrl() {
        return Optional.ofNullable(sectionsUrl);
    }

    public SectionGroup withSectionsUrl(String sectionsUrl) {
        SectionGroup _x = _copy();
        _x.changedFields = changedFields.add("sectionsUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sectionGroup");
        _x.sectionsUrl = sectionsUrl;
        return _x;
    }

    public SectionGroup withUnmappedField(String name, Object value) {
        SectionGroup _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="parentNotebook")
    @JsonIgnore
    public NotebookRequest getParentNotebook() {
        return new NotebookRequest(contextPath.addSegment("parentNotebook"), Optional.ofNullable(parentNotebook));
    }

    @NavigationProperty(name="parentSectionGroup")
    @JsonIgnore
    public SectionGroupRequest getParentSectionGroup() {
        return new SectionGroupRequest(contextPath.addSegment("parentSectionGroup"), Optional.ofNullable(parentSectionGroup));
    }

    @NavigationProperty(name="sectionGroups")
    @JsonIgnore
    public SectionGroupCollectionRequest getSectionGroups() {
        return new SectionGroupCollectionRequest(
                        contextPath.addSegment("sectionGroups"), Optional.ofNullable(sectionGroups));
    }

    @NavigationProperty(name="sections")
    @JsonIgnore
    public OnenoteSectionCollectionRequest getSections() {
        return new OnenoteSectionCollectionRequest(
                        contextPath.addSegment("sections"), Optional.ofNullable(sections));
    }

    public SectionGroup withParentNotebook(Notebook parentNotebook) {
        SectionGroup _x = _copy();
        _x.changedFields = changedFields.add("parentNotebook");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sectionGroup");
        _x.parentNotebook = parentNotebook;
        return _x;
    }

    public SectionGroup withParentSectionGroup(SectionGroup parentSectionGroup) {
        SectionGroup _x = _copy();
        _x.changedFields = changedFields.add("parentSectionGroup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sectionGroup");
        _x.parentSectionGroup = parentSectionGroup;
        return _x;
    }

    public SectionGroup withSectionGroups(List<SectionGroup> sectionGroups) {
        SectionGroup _x = _copy();
        _x.changedFields = changedFields.add("sectionGroups");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sectionGroup");
        _x.sectionGroups = sectionGroups;
        return _x;
    }

    public SectionGroup withSections(List<OnenoteSection> sections) {
        SectionGroup _x = _copy();
        _x.changedFields = changedFields.add("sections");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sectionGroup");
        _x.sections = sections;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SectionGroup patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SectionGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SectionGroup put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SectionGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SectionGroup _copy() {
        SectionGroup _x = new SectionGroup();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.self = self;
        _x.createdDateTime = createdDateTime;
        _x.createdBy = createdBy;
        _x.displayName = displayName;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.sectionGroupsUrl = sectionGroupsUrl;
        _x.sectionsUrl = sectionsUrl;
        _x.parentNotebook = parentNotebook;
        _x.parentSectionGroup = parentSectionGroup;
        _x.sectionGroups = sectionGroups;
        _x.sections = sections;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SectionGroup[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("self=");
        b.append(this.self);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("sectionGroupsUrl=");
        b.append(this.sectionGroupsUrl);
        b.append(", ");
        b.append("sectionsUrl=");
        b.append(this.sectionsUrl);
        b.append(", ");
        b.append("parentNotebook=");
        b.append(this.parentNotebook);
        b.append(", ");
        b.append("parentSectionGroup=");
        b.append(this.parentSectionGroup);
        b.append(", ");
        b.append("sectionGroups=");
        b.append(this.sectionGroups);
        b.append(", ");
        b.append("sections=");
        b.append(this.sections);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
