package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import microsoft.graph.search.collection.request.AcronymCollectionRequest;
import microsoft.graph.search.collection.request.BookmarkCollectionRequest;
import microsoft.graph.search.collection.request.QnaCollectionRequest;
import microsoft.graph.search.entity.Acronym;
import microsoft.graph.search.entity.Bookmark;
import microsoft.graph.search.entity.Qna;

import odata.msgraph.client.beta.complex.SearchRequest;
import odata.msgraph.client.beta.complex.SearchResponse;

@JsonPropertyOrder({
    "@odata.type", 
    "acronyms", 
    "bookmarks", 
    "qnas"})
@JsonInclude(Include.NON_NULL)
public class SearchEntity extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.searchEntity";
    }

    @JsonProperty("acronyms")
    protected List<Acronym> acronyms;

    @JsonProperty("bookmarks")
    protected List<Bookmark> bookmarks;

    @JsonProperty("qnas")
    protected List<Qna> qnas;

    protected SearchEntity() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSearchEntity() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<Acronym> acronyms;
        private List<Bookmark> bookmarks;
        private List<Qna> qnas;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder acronyms(List<Acronym> acronyms) {
            this.acronyms = acronyms;
            this.changedFields = changedFields.add("acronyms");
            return this;
        }

        public Builder acronyms(Acronym... acronyms) {
            return acronyms(Arrays.asList(acronyms));
        }

        public Builder bookmarks(List<Bookmark> bookmarks) {
            this.bookmarks = bookmarks;
            this.changedFields = changedFields.add("bookmarks");
            return this;
        }

        public Builder bookmarks(Bookmark... bookmarks) {
            return bookmarks(Arrays.asList(bookmarks));
        }

        public Builder qnas(List<Qna> qnas) {
            this.qnas = qnas;
            this.changedFields = changedFields.add("qnas");
            return this;
        }

        public Builder qnas(Qna... qnas) {
            return qnas(Arrays.asList(qnas));
        }

        public SearchEntity build() {
            SearchEntity _x = new SearchEntity();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.searchEntity";
            _x.id = id;
            _x.acronyms = acronyms;
            _x.bookmarks = bookmarks;
            _x.qnas = qnas;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public SearchEntity withUnmappedField(String name, Object value) {
        SearchEntity _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="acronyms")
    @JsonIgnore
    public AcronymCollectionRequest getAcronyms() {
        return new AcronymCollectionRequest(
                        contextPath.addSegment("acronyms"), Optional.ofNullable(acronyms));
    }

    @NavigationProperty(name="bookmarks")
    @JsonIgnore
    public BookmarkCollectionRequest getBookmarks() {
        return new BookmarkCollectionRequest(
                        contextPath.addSegment("bookmarks"), Optional.ofNullable(bookmarks));
    }

    @NavigationProperty(name="qnas")
    @JsonIgnore
    public QnaCollectionRequest getQnas() {
        return new QnaCollectionRequest(
                        contextPath.addSegment("qnas"), Optional.ofNullable(qnas));
    }

    public SearchEntity withAcronyms(List<Acronym> acronyms) {
        SearchEntity _x = _copy();
        _x.changedFields = changedFields.add("acronyms");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchEntity");
        _x.acronyms = acronyms;
        return _x;
    }

    public SearchEntity withBookmarks(List<Bookmark> bookmarks) {
        SearchEntity _x = _copy();
        _x.changedFields = changedFields.add("bookmarks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchEntity");
        _x.bookmarks = bookmarks;
        return _x;
    }

    public SearchEntity withQnas(List<Qna> qnas) {
        SearchEntity _x = _copy();
        _x.changedFields = changedFields.add("qnas");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchEntity");
        _x.qnas = qnas;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SearchEntity patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SearchEntity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SearchEntity put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SearchEntity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SearchEntity _copy() {
        SearchEntity _x = new SearchEntity();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.acronyms = acronyms;
        _x.bookmarks = bookmarks;
        _x.qnas = qnas;
        return _x;
    }

    @Action(name = "query")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SearchResponse> query(List<SearchRequest> requests) {
        Preconditions.checkNotNull(requests, "requests cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("requests", "Collection(microsoft.graph.searchRequest)", requests)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.query"), SearchResponse.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SearchEntity[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("acronyms=");
        b.append(this.acronyms);
        b.append(", ");
        b.append("bookmarks=");
        b.append(this.bookmarks);
        b.append(", ");
        b.append("qnas=");
        b.append(this.qnas);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
