package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Identity;

@JsonPropertyOrder({
    "@odata.type", 
    "administrativeUnitId", 
    "roleId", 
    "roleMemberInfo"})
@JsonInclude(Include.NON_NULL)
public class ScopedRoleMembership extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.scopedRoleMembership";
    }

    @JsonProperty("administrativeUnitId")
    protected String administrativeUnitId;

    @JsonProperty("roleId")
    protected String roleId;

    @JsonProperty("roleMemberInfo")
    protected Identity roleMemberInfo;

    protected ScopedRoleMembership() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderScopedRoleMembership() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String administrativeUnitId;
        private String roleId;
        private Identity roleMemberInfo;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder administrativeUnitId(String administrativeUnitId) {
            this.administrativeUnitId = administrativeUnitId;
            this.changedFields = changedFields.add("administrativeUnitId");
            return this;
        }

        public Builder roleId(String roleId) {
            this.roleId = roleId;
            this.changedFields = changedFields.add("roleId");
            return this;
        }

        public Builder roleMemberInfo(Identity roleMemberInfo) {
            this.roleMemberInfo = roleMemberInfo;
            this.changedFields = changedFields.add("roleMemberInfo");
            return this;
        }

        public ScopedRoleMembership build() {
            ScopedRoleMembership _x = new ScopedRoleMembership();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.scopedRoleMembership";
            _x.id = id;
            _x.administrativeUnitId = administrativeUnitId;
            _x.roleId = roleId;
            _x.roleMemberInfo = roleMemberInfo;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="administrativeUnitId")
    @JsonIgnore
    public Optional<String> getAdministrativeUnitId() {
        return Optional.ofNullable(administrativeUnitId);
    }

    public ScopedRoleMembership withAdministrativeUnitId(String administrativeUnitId) {
        ScopedRoleMembership _x = _copy();
        _x.changedFields = changedFields.add("administrativeUnitId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scopedRoleMembership");
        _x.administrativeUnitId = administrativeUnitId;
        return _x;
    }

    @Property(name="roleId")
    @JsonIgnore
    public Optional<String> getRoleId() {
        return Optional.ofNullable(roleId);
    }

    public ScopedRoleMembership withRoleId(String roleId) {
        ScopedRoleMembership _x = _copy();
        _x.changedFields = changedFields.add("roleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scopedRoleMembership");
        _x.roleId = roleId;
        return _x;
    }

    @Property(name="roleMemberInfo")
    @JsonIgnore
    public Optional<Identity> getRoleMemberInfo() {
        return Optional.ofNullable(roleMemberInfo);
    }

    public ScopedRoleMembership withRoleMemberInfo(Identity roleMemberInfo) {
        ScopedRoleMembership _x = _copy();
        _x.changedFields = changedFields.add("roleMemberInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scopedRoleMembership");
        _x.roleMemberInfo = roleMemberInfo;
        return _x;
    }

    public ScopedRoleMembership withUnmappedField(String name, Object value) {
        ScopedRoleMembership _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ScopedRoleMembership patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ScopedRoleMembership _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ScopedRoleMembership put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ScopedRoleMembership _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ScopedRoleMembership _copy() {
        ScopedRoleMembership _x = new ScopedRoleMembership();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.administrativeUnitId = administrativeUnitId;
        _x.roleId = roleId;
        _x.roleMemberInfo = roleMemberInfo;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ScopedRoleMembership[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("administrativeUnitId=");
        b.append(this.administrativeUnitId);
        b.append(", ");
        b.append("roleId=");
        b.append(this.roleId);
        b.append(", ");
        b.append("roleMemberInfo=");
        b.append(this.roleMemberInfo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
