package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AuthenticationProtocol;

@JsonPropertyOrder({
    "@odata.type", 
    "issuerUri", 
    "metadataExchangeUri", 
    "passiveSignInUri", 
    "preferredAuthenticationProtocol", 
    "signingCertificate"})
@JsonInclude(Include.NON_NULL)
public class SamlOrWsFedProvider extends IdentityProviderBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.samlOrWsFedProvider";
    }

    @JsonProperty("issuerUri")
    protected String issuerUri;

    @JsonProperty("metadataExchangeUri")
    protected String metadataExchangeUri;

    @JsonProperty("passiveSignInUri")
    protected String passiveSignInUri;

    @JsonProperty("preferredAuthenticationProtocol")
    protected AuthenticationProtocol preferredAuthenticationProtocol;

    @JsonProperty("signingCertificate")
    protected String signingCertificate;

    protected SamlOrWsFedProvider() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="issuerUri")
    @JsonIgnore
    public Optional<String> getIssuerUri() {
        return Optional.ofNullable(issuerUri);
    }

    public SamlOrWsFedProvider withIssuerUri(String issuerUri) {
        SamlOrWsFedProvider _x = _copy();
        _x.changedFields = changedFields.add("issuerUri");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.samlOrWsFedProvider");
        _x.issuerUri = issuerUri;
        return _x;
    }

    @Property(name="metadataExchangeUri")
    @JsonIgnore
    public Optional<String> getMetadataExchangeUri() {
        return Optional.ofNullable(metadataExchangeUri);
    }

    public SamlOrWsFedProvider withMetadataExchangeUri(String metadataExchangeUri) {
        SamlOrWsFedProvider _x = _copy();
        _x.changedFields = changedFields.add("metadataExchangeUri");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.samlOrWsFedProvider");
        _x.metadataExchangeUri = metadataExchangeUri;
        return _x;
    }

    @Property(name="passiveSignInUri")
    @JsonIgnore
    public Optional<String> getPassiveSignInUri() {
        return Optional.ofNullable(passiveSignInUri);
    }

    public SamlOrWsFedProvider withPassiveSignInUri(String passiveSignInUri) {
        SamlOrWsFedProvider _x = _copy();
        _x.changedFields = changedFields.add("passiveSignInUri");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.samlOrWsFedProvider");
        _x.passiveSignInUri = passiveSignInUri;
        return _x;
    }

    @Property(name="preferredAuthenticationProtocol")
    @JsonIgnore
    public Optional<AuthenticationProtocol> getPreferredAuthenticationProtocol() {
        return Optional.ofNullable(preferredAuthenticationProtocol);
    }

    public SamlOrWsFedProvider withPreferredAuthenticationProtocol(AuthenticationProtocol preferredAuthenticationProtocol) {
        SamlOrWsFedProvider _x = _copy();
        _x.changedFields = changedFields.add("preferredAuthenticationProtocol");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.samlOrWsFedProvider");
        _x.preferredAuthenticationProtocol = preferredAuthenticationProtocol;
        return _x;
    }

    @Property(name="signingCertificate")
    @JsonIgnore
    public Optional<String> getSigningCertificate() {
        return Optional.ofNullable(signingCertificate);
    }

    public SamlOrWsFedProvider withSigningCertificate(String signingCertificate) {
        SamlOrWsFedProvider _x = _copy();
        _x.changedFields = changedFields.add("signingCertificate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.samlOrWsFedProvider");
        _x.signingCertificate = signingCertificate;
        return _x;
    }

    public SamlOrWsFedProvider withUnmappedField(String name, Object value) {
        SamlOrWsFedProvider _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SamlOrWsFedProvider patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SamlOrWsFedProvider _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SamlOrWsFedProvider put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SamlOrWsFedProvider _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SamlOrWsFedProvider _copy() {
        SamlOrWsFedProvider _x = new SamlOrWsFedProvider();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.issuerUri = issuerUri;
        _x.metadataExchangeUri = metadataExchangeUri;
        _x.passiveSignInUri = passiveSignInUri;
        _x.preferredAuthenticationProtocol = preferredAuthenticationProtocol;
        _x.signingCertificate = signingCertificate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SamlOrWsFedProvider[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("issuerUri=");
        b.append(this.issuerUri);
        b.append(", ");
        b.append("metadataExchangeUri=");
        b.append(this.metadataExchangeUri);
        b.append(", ");
        b.append("passiveSignInUri=");
        b.append(this.passiveSignInUri);
        b.append(", ");
        b.append("preferredAuthenticationProtocol=");
        b.append(this.preferredAuthenticationProtocol);
        b.append(", ");
        b.append("signingCertificate=");
        b.append(this.signingCertificate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
