package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.complex.PostalAddressType;
import odata.msgraph.client.beta.entity.collection.request.SalesInvoiceLineCollectionRequest;
import odata.msgraph.client.beta.entity.request.CurrencyRequest;
import odata.msgraph.client.beta.entity.request.CustomerRequest;
import odata.msgraph.client.beta.entity.request.PaymentTermRequest;
import odata.msgraph.client.beta.entity.request.ShipmentMethodRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "billingPostalAddress", 
    "billToCustomerId", 
    "billToCustomerNumber", 
    "billToName", 
    "currencyCode", 
    "currencyId", 
    "customerId", 
    "customerName", 
    "customerNumber", 
    "customerPurchaseOrderReference", 
    "discountAmount", 
    "discountAppliedBeforeTax", 
    "dueDate", 
    "email", 
    "externalDocumentNumber", 
    "invoiceDate", 
    "lastModifiedDateTime", 
    "number", 
    "orderId", 
    "orderNumber", 
    "paymentTermsId", 
    "phoneNumber", 
    "pricesIncludeTax", 
    "salesperson", 
    "sellingPostalAddress", 
    "shipmentMethodId", 
    "shippingPostalAddress", 
    "shipToContact", 
    "shipToName", 
    "status", 
    "totalAmountExcludingTax", 
    "totalAmountIncludingTax", 
    "totalTaxAmount", 
    "currency", 
    "customer", 
    "paymentTerm", 
    "salesInvoiceLines", 
    "shipmentMethod"})
@JsonInclude(Include.NON_NULL)
public class SalesInvoice extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.salesInvoice";
    }

    @JsonProperty("billingPostalAddress")
    protected PostalAddressType billingPostalAddress;

    @JsonProperty("billToCustomerId")
    protected UUID billToCustomerId;

    @JsonProperty("billToCustomerNumber")
    protected String billToCustomerNumber;

    @JsonProperty("billToName")
    protected String billToName;

    @JsonProperty("currencyCode")
    protected String currencyCode;

    @JsonProperty("currencyId")
    protected UUID currencyId;

    @JsonProperty("customerId")
    protected UUID customerId;

    @JsonProperty("customerName")
    protected String customerName;

    @JsonProperty("customerNumber")
    protected String customerNumber;

    @JsonProperty("customerPurchaseOrderReference")
    protected String customerPurchaseOrderReference;

    @JsonProperty("discountAmount")
    protected BigDecimal discountAmount;

    @JsonProperty("discountAppliedBeforeTax")
    protected Boolean discountAppliedBeforeTax;

    @JsonProperty("dueDate")
    protected LocalDate dueDate;

    @JsonProperty("email")
    protected String email;

    @JsonProperty("externalDocumentNumber")
    protected String externalDocumentNumber;

    @JsonProperty("invoiceDate")
    protected LocalDate invoiceDate;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("number")
    protected String number;

    @JsonProperty("orderId")
    protected UUID orderId;

    @JsonProperty("orderNumber")
    protected String orderNumber;

    @JsonProperty("paymentTermsId")
    protected UUID paymentTermsId;

    @JsonProperty("phoneNumber")
    protected String phoneNumber;

    @JsonProperty("pricesIncludeTax")
    protected Boolean pricesIncludeTax;

    @JsonProperty("salesperson")
    protected String salesperson;

    @JsonProperty("sellingPostalAddress")
    protected PostalAddressType sellingPostalAddress;

    @JsonProperty("shipmentMethodId")
    protected UUID shipmentMethodId;

    @JsonProperty("shippingPostalAddress")
    protected PostalAddressType shippingPostalAddress;

    @JsonProperty("shipToContact")
    protected String shipToContact;

    @JsonProperty("shipToName")
    protected String shipToName;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("totalAmountExcludingTax")
    protected BigDecimal totalAmountExcludingTax;

    @JsonProperty("totalAmountIncludingTax")
    protected BigDecimal totalAmountIncludingTax;

    @JsonProperty("totalTaxAmount")
    protected BigDecimal totalTaxAmount;

    @JsonProperty("currency")
    protected Currency currency;

    @JsonProperty("customer")
    protected Customer customer;

    @JsonProperty("paymentTerm")
    protected PaymentTerm paymentTerm;

    @JsonProperty("salesInvoiceLines")
    protected List<SalesInvoiceLine> salesInvoiceLines;

    @JsonProperty("shipmentMethod")
    protected ShipmentMethod shipmentMethod;

    protected SalesInvoice() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSalesInvoice() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PostalAddressType billingPostalAddress;
        private UUID billToCustomerId;
        private String billToCustomerNumber;
        private String billToName;
        private String currencyCode;
        private UUID currencyId;
        private UUID customerId;
        private String customerName;
        private String customerNumber;
        private String customerPurchaseOrderReference;
        private BigDecimal discountAmount;
        private Boolean discountAppliedBeforeTax;
        private LocalDate dueDate;
        private String email;
        private String externalDocumentNumber;
        private LocalDate invoiceDate;
        private OffsetDateTime lastModifiedDateTime;
        private String number;
        private UUID orderId;
        private String orderNumber;
        private UUID paymentTermsId;
        private String phoneNumber;
        private Boolean pricesIncludeTax;
        private String salesperson;
        private PostalAddressType sellingPostalAddress;
        private UUID shipmentMethodId;
        private PostalAddressType shippingPostalAddress;
        private String shipToContact;
        private String shipToName;
        private String status;
        private BigDecimal totalAmountExcludingTax;
        private BigDecimal totalAmountIncludingTax;
        private BigDecimal totalTaxAmount;
        private Currency currency;
        private Customer customer;
        private PaymentTerm paymentTerm;
        private List<SalesInvoiceLine> salesInvoiceLines;
        private ShipmentMethod shipmentMethod;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder billingPostalAddress(PostalAddressType billingPostalAddress) {
            this.billingPostalAddress = billingPostalAddress;
            this.changedFields = changedFields.add("billingPostalAddress");
            return this;
        }

        public Builder billToCustomerId(UUID billToCustomerId) {
            this.billToCustomerId = billToCustomerId;
            this.changedFields = changedFields.add("billToCustomerId");
            return this;
        }

        public Builder billToCustomerNumber(String billToCustomerNumber) {
            this.billToCustomerNumber = billToCustomerNumber;
            this.changedFields = changedFields.add("billToCustomerNumber");
            return this;
        }

        public Builder billToName(String billToName) {
            this.billToName = billToName;
            this.changedFields = changedFields.add("billToName");
            return this;
        }

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            this.changedFields = changedFields.add("currencyCode");
            return this;
        }

        public Builder currencyId(UUID currencyId) {
            this.currencyId = currencyId;
            this.changedFields = changedFields.add("currencyId");
            return this;
        }

        public Builder customerId(UUID customerId) {
            this.customerId = customerId;
            this.changedFields = changedFields.add("customerId");
            return this;
        }

        public Builder customerName(String customerName) {
            this.customerName = customerName;
            this.changedFields = changedFields.add("customerName");
            return this;
        }

        public Builder customerNumber(String customerNumber) {
            this.customerNumber = customerNumber;
            this.changedFields = changedFields.add("customerNumber");
            return this;
        }

        public Builder customerPurchaseOrderReference(String customerPurchaseOrderReference) {
            this.customerPurchaseOrderReference = customerPurchaseOrderReference;
            this.changedFields = changedFields.add("customerPurchaseOrderReference");
            return this;
        }

        public Builder discountAmount(BigDecimal discountAmount) {
            this.discountAmount = discountAmount;
            this.changedFields = changedFields.add("discountAmount");
            return this;
        }

        public Builder discountAppliedBeforeTax(Boolean discountAppliedBeforeTax) {
            this.discountAppliedBeforeTax = discountAppliedBeforeTax;
            this.changedFields = changedFields.add("discountAppliedBeforeTax");
            return this;
        }

        public Builder dueDate(LocalDate dueDate) {
            this.dueDate = dueDate;
            this.changedFields = changedFields.add("dueDate");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public Builder externalDocumentNumber(String externalDocumentNumber) {
            this.externalDocumentNumber = externalDocumentNumber;
            this.changedFields = changedFields.add("externalDocumentNumber");
            return this;
        }

        public Builder invoiceDate(LocalDate invoiceDate) {
            this.invoiceDate = invoiceDate;
            this.changedFields = changedFields.add("invoiceDate");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder number(String number) {
            this.number = number;
            this.changedFields = changedFields.add("number");
            return this;
        }

        public Builder orderId(UUID orderId) {
            this.orderId = orderId;
            this.changedFields = changedFields.add("orderId");
            return this;
        }

        public Builder orderNumber(String orderNumber) {
            this.orderNumber = orderNumber;
            this.changedFields = changedFields.add("orderNumber");
            return this;
        }

        public Builder paymentTermsId(UUID paymentTermsId) {
            this.paymentTermsId = paymentTermsId;
            this.changedFields = changedFields.add("paymentTermsId");
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            this.changedFields = changedFields.add("phoneNumber");
            return this;
        }

        public Builder pricesIncludeTax(Boolean pricesIncludeTax) {
            this.pricesIncludeTax = pricesIncludeTax;
            this.changedFields = changedFields.add("pricesIncludeTax");
            return this;
        }

        public Builder salesperson(String salesperson) {
            this.salesperson = salesperson;
            this.changedFields = changedFields.add("salesperson");
            return this;
        }

        public Builder sellingPostalAddress(PostalAddressType sellingPostalAddress) {
            this.sellingPostalAddress = sellingPostalAddress;
            this.changedFields = changedFields.add("sellingPostalAddress");
            return this;
        }

        public Builder shipmentMethodId(UUID shipmentMethodId) {
            this.shipmentMethodId = shipmentMethodId;
            this.changedFields = changedFields.add("shipmentMethodId");
            return this;
        }

        public Builder shippingPostalAddress(PostalAddressType shippingPostalAddress) {
            this.shippingPostalAddress = shippingPostalAddress;
            this.changedFields = changedFields.add("shippingPostalAddress");
            return this;
        }

        public Builder shipToContact(String shipToContact) {
            this.shipToContact = shipToContact;
            this.changedFields = changedFields.add("shipToContact");
            return this;
        }

        public Builder shipToName(String shipToName) {
            this.shipToName = shipToName;
            this.changedFields = changedFields.add("shipToName");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder totalAmountExcludingTax(BigDecimal totalAmountExcludingTax) {
            this.totalAmountExcludingTax = totalAmountExcludingTax;
            this.changedFields = changedFields.add("totalAmountExcludingTax");
            return this;
        }

        public Builder totalAmountIncludingTax(BigDecimal totalAmountIncludingTax) {
            this.totalAmountIncludingTax = totalAmountIncludingTax;
            this.changedFields = changedFields.add("totalAmountIncludingTax");
            return this;
        }

        public Builder totalTaxAmount(BigDecimal totalTaxAmount) {
            this.totalTaxAmount = totalTaxAmount;
            this.changedFields = changedFields.add("totalTaxAmount");
            return this;
        }

        public Builder currency(Currency currency) {
            this.currency = currency;
            this.changedFields = changedFields.add("currency");
            return this;
        }

        public Builder customer(Customer customer) {
            this.customer = customer;
            this.changedFields = changedFields.add("customer");
            return this;
        }

        public Builder paymentTerm(PaymentTerm paymentTerm) {
            this.paymentTerm = paymentTerm;
            this.changedFields = changedFields.add("paymentTerm");
            return this;
        }

        public Builder salesInvoiceLines(List<SalesInvoiceLine> salesInvoiceLines) {
            this.salesInvoiceLines = salesInvoiceLines;
            this.changedFields = changedFields.add("salesInvoiceLines");
            return this;
        }

        public Builder salesInvoiceLines(SalesInvoiceLine... salesInvoiceLines) {
            return salesInvoiceLines(Arrays.asList(salesInvoiceLines));
        }

        public Builder shipmentMethod(ShipmentMethod shipmentMethod) {
            this.shipmentMethod = shipmentMethod;
            this.changedFields = changedFields.add("shipmentMethod");
            return this;
        }

        public SalesInvoice build() {
            SalesInvoice _x = new SalesInvoice();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.salesInvoice";
            _x.id = id;
            _x.billingPostalAddress = billingPostalAddress;
            _x.billToCustomerId = billToCustomerId;
            _x.billToCustomerNumber = billToCustomerNumber;
            _x.billToName = billToName;
            _x.currencyCode = currencyCode;
            _x.currencyId = currencyId;
            _x.customerId = customerId;
            _x.customerName = customerName;
            _x.customerNumber = customerNumber;
            _x.customerPurchaseOrderReference = customerPurchaseOrderReference;
            _x.discountAmount = discountAmount;
            _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
            _x.dueDate = dueDate;
            _x.email = email;
            _x.externalDocumentNumber = externalDocumentNumber;
            _x.invoiceDate = invoiceDate;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.number = number;
            _x.orderId = orderId;
            _x.orderNumber = orderNumber;
            _x.paymentTermsId = paymentTermsId;
            _x.phoneNumber = phoneNumber;
            _x.pricesIncludeTax = pricesIncludeTax;
            _x.salesperson = salesperson;
            _x.sellingPostalAddress = sellingPostalAddress;
            _x.shipmentMethodId = shipmentMethodId;
            _x.shippingPostalAddress = shippingPostalAddress;
            _x.shipToContact = shipToContact;
            _x.shipToName = shipToName;
            _x.status = status;
            _x.totalAmountExcludingTax = totalAmountExcludingTax;
            _x.totalAmountIncludingTax = totalAmountIncludingTax;
            _x.totalTaxAmount = totalTaxAmount;
            _x.currency = currency;
            _x.customer = customer;
            _x.paymentTerm = paymentTerm;
            _x.salesInvoiceLines = salesInvoiceLines;
            _x.shipmentMethod = shipmentMethod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="billingPostalAddress")
    @JsonIgnore
    public Optional<PostalAddressType> getBillingPostalAddress() {
        return Optional.ofNullable(billingPostalAddress);
    }

    public SalesInvoice withBillingPostalAddress(PostalAddressType billingPostalAddress) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("billingPostalAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.billingPostalAddress = billingPostalAddress;
        return _x;
    }

    @Property(name="billToCustomerId")
    @JsonIgnore
    public Optional<UUID> getBillToCustomerId() {
        return Optional.ofNullable(billToCustomerId);
    }

    public SalesInvoice withBillToCustomerId(UUID billToCustomerId) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("billToCustomerId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.billToCustomerId = billToCustomerId;
        return _x;
    }

    @Property(name="billToCustomerNumber")
    @JsonIgnore
    public Optional<String> getBillToCustomerNumber() {
        return Optional.ofNullable(billToCustomerNumber);
    }

    public SalesInvoice withBillToCustomerNumber(String billToCustomerNumber) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("billToCustomerNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.billToCustomerNumber = billToCustomerNumber;
        return _x;
    }

    @Property(name="billToName")
    @JsonIgnore
    public Optional<String> getBillToName() {
        return Optional.ofNullable(billToName);
    }

    public SalesInvoice withBillToName(String billToName) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("billToName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.billToName = billToName;
        return _x;
    }

    @Property(name="currencyCode")
    @JsonIgnore
    public Optional<String> getCurrencyCode() {
        return Optional.ofNullable(currencyCode);
    }

    public SalesInvoice withCurrencyCode(String currencyCode) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("currencyCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.currencyCode = currencyCode;
        return _x;
    }

    @Property(name="currencyId")
    @JsonIgnore
    public Optional<UUID> getCurrencyId() {
        return Optional.ofNullable(currencyId);
    }

    public SalesInvoice withCurrencyId(UUID currencyId) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("currencyId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.currencyId = currencyId;
        return _x;
    }

    @Property(name="customerId")
    @JsonIgnore
    public Optional<UUID> getCustomerId() {
        return Optional.ofNullable(customerId);
    }

    public SalesInvoice withCustomerId(UUID customerId) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("customerId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.customerId = customerId;
        return _x;
    }

    @Property(name="customerName")
    @JsonIgnore
    public Optional<String> getCustomerName() {
        return Optional.ofNullable(customerName);
    }

    public SalesInvoice withCustomerName(String customerName) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("customerName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.customerName = customerName;
        return _x;
    }

    @Property(name="customerNumber")
    @JsonIgnore
    public Optional<String> getCustomerNumber() {
        return Optional.ofNullable(customerNumber);
    }

    public SalesInvoice withCustomerNumber(String customerNumber) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("customerNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.customerNumber = customerNumber;
        return _x;
    }

    @Property(name="customerPurchaseOrderReference")
    @JsonIgnore
    public Optional<String> getCustomerPurchaseOrderReference() {
        return Optional.ofNullable(customerPurchaseOrderReference);
    }

    public SalesInvoice withCustomerPurchaseOrderReference(String customerPurchaseOrderReference) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("customerPurchaseOrderReference");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.customerPurchaseOrderReference = customerPurchaseOrderReference;
        return _x;
    }

    @Property(name="discountAmount")
    @JsonIgnore
    public Optional<BigDecimal> getDiscountAmount() {
        return Optional.ofNullable(discountAmount);
    }

    public SalesInvoice withDiscountAmount(BigDecimal discountAmount) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("discountAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.discountAmount = discountAmount;
        return _x;
    }

    @Property(name="discountAppliedBeforeTax")
    @JsonIgnore
    public Optional<Boolean> getDiscountAppliedBeforeTax() {
        return Optional.ofNullable(discountAppliedBeforeTax);
    }

    public SalesInvoice withDiscountAppliedBeforeTax(Boolean discountAppliedBeforeTax) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("discountAppliedBeforeTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
        return _x;
    }

    @Property(name="dueDate")
    @JsonIgnore
    public Optional<LocalDate> getDueDate() {
        return Optional.ofNullable(dueDate);
    }

    public SalesInvoice withDueDate(LocalDate dueDate) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("dueDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.dueDate = dueDate;
        return _x;
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public SalesInvoice withEmail(String email) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("email");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.email = email;
        return _x;
    }

    @Property(name="externalDocumentNumber")
    @JsonIgnore
    public Optional<String> getExternalDocumentNumber() {
        return Optional.ofNullable(externalDocumentNumber);
    }

    public SalesInvoice withExternalDocumentNumber(String externalDocumentNumber) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("externalDocumentNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.externalDocumentNumber = externalDocumentNumber;
        return _x;
    }

    @Property(name="invoiceDate")
    @JsonIgnore
    public Optional<LocalDate> getInvoiceDate() {
        return Optional.ofNullable(invoiceDate);
    }

    public SalesInvoice withInvoiceDate(LocalDate invoiceDate) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("invoiceDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.invoiceDate = invoiceDate;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public SalesInvoice withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="number")
    @JsonIgnore
    public Optional<String> getNumber() {
        return Optional.ofNullable(number);
    }

    public SalesInvoice withNumber(String number) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("number");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.number = number;
        return _x;
    }

    @Property(name="orderId")
    @JsonIgnore
    public Optional<UUID> getOrderId() {
        return Optional.ofNullable(orderId);
    }

    public SalesInvoice withOrderId(UUID orderId) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("orderId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.orderId = orderId;
        return _x;
    }

    @Property(name="orderNumber")
    @JsonIgnore
    public Optional<String> getOrderNumber() {
        return Optional.ofNullable(orderNumber);
    }

    public SalesInvoice withOrderNumber(String orderNumber) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("orderNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.orderNumber = orderNumber;
        return _x;
    }

    @Property(name="paymentTermsId")
    @JsonIgnore
    public Optional<UUID> getPaymentTermsId() {
        return Optional.ofNullable(paymentTermsId);
    }

    public SalesInvoice withPaymentTermsId(UUID paymentTermsId) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("paymentTermsId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.paymentTermsId = paymentTermsId;
        return _x;
    }

    @Property(name="phoneNumber")
    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        return Optional.ofNullable(phoneNumber);
    }

    public SalesInvoice withPhoneNumber(String phoneNumber) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("phoneNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.phoneNumber = phoneNumber;
        return _x;
    }

    @Property(name="pricesIncludeTax")
    @JsonIgnore
    public Optional<Boolean> getPricesIncludeTax() {
        return Optional.ofNullable(pricesIncludeTax);
    }

    public SalesInvoice withPricesIncludeTax(Boolean pricesIncludeTax) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("pricesIncludeTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.pricesIncludeTax = pricesIncludeTax;
        return _x;
    }

    @Property(name="salesperson")
    @JsonIgnore
    public Optional<String> getSalesperson() {
        return Optional.ofNullable(salesperson);
    }

    public SalesInvoice withSalesperson(String salesperson) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("salesperson");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.salesperson = salesperson;
        return _x;
    }

    @Property(name="sellingPostalAddress")
    @JsonIgnore
    public Optional<PostalAddressType> getSellingPostalAddress() {
        return Optional.ofNullable(sellingPostalAddress);
    }

    public SalesInvoice withSellingPostalAddress(PostalAddressType sellingPostalAddress) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("sellingPostalAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.sellingPostalAddress = sellingPostalAddress;
        return _x;
    }

    @Property(name="shipmentMethodId")
    @JsonIgnore
    public Optional<UUID> getShipmentMethodId() {
        return Optional.ofNullable(shipmentMethodId);
    }

    public SalesInvoice withShipmentMethodId(UUID shipmentMethodId) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("shipmentMethodId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.shipmentMethodId = shipmentMethodId;
        return _x;
    }

    @Property(name="shippingPostalAddress")
    @JsonIgnore
    public Optional<PostalAddressType> getShippingPostalAddress() {
        return Optional.ofNullable(shippingPostalAddress);
    }

    public SalesInvoice withShippingPostalAddress(PostalAddressType shippingPostalAddress) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("shippingPostalAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.shippingPostalAddress = shippingPostalAddress;
        return _x;
    }

    @Property(name="shipToContact")
    @JsonIgnore
    public Optional<String> getShipToContact() {
        return Optional.ofNullable(shipToContact);
    }

    public SalesInvoice withShipToContact(String shipToContact) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("shipToContact");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.shipToContact = shipToContact;
        return _x;
    }

    @Property(name="shipToName")
    @JsonIgnore
    public Optional<String> getShipToName() {
        return Optional.ofNullable(shipToName);
    }

    public SalesInvoice withShipToName(String shipToName) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("shipToName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.shipToName = shipToName;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public SalesInvoice withStatus(String status) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.status = status;
        return _x;
    }

    @Property(name="totalAmountExcludingTax")
    @JsonIgnore
    public Optional<BigDecimal> getTotalAmountExcludingTax() {
        return Optional.ofNullable(totalAmountExcludingTax);
    }

    public SalesInvoice withTotalAmountExcludingTax(BigDecimal totalAmountExcludingTax) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("totalAmountExcludingTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.totalAmountExcludingTax = totalAmountExcludingTax;
        return _x;
    }

    @Property(name="totalAmountIncludingTax")
    @JsonIgnore
    public Optional<BigDecimal> getTotalAmountIncludingTax() {
        return Optional.ofNullable(totalAmountIncludingTax);
    }

    public SalesInvoice withTotalAmountIncludingTax(BigDecimal totalAmountIncludingTax) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("totalAmountIncludingTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.totalAmountIncludingTax = totalAmountIncludingTax;
        return _x;
    }

    @Property(name="totalTaxAmount")
    @JsonIgnore
    public Optional<BigDecimal> getTotalTaxAmount() {
        return Optional.ofNullable(totalTaxAmount);
    }

    public SalesInvoice withTotalTaxAmount(BigDecimal totalTaxAmount) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("totalTaxAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.totalTaxAmount = totalTaxAmount;
        return _x;
    }

    public SalesInvoice withUnmappedField(String name, Object value) {
        SalesInvoice _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="currency")
    @JsonIgnore
    public CurrencyRequest getCurrency() {
        return new CurrencyRequest(contextPath.addSegment("currency"), Optional.ofNullable(currency));
    }

    @NavigationProperty(name="customer")
    @JsonIgnore
    public CustomerRequest getCustomer() {
        return new CustomerRequest(contextPath.addSegment("customer"), Optional.ofNullable(customer));
    }

    @NavigationProperty(name="paymentTerm")
    @JsonIgnore
    public PaymentTermRequest getPaymentTerm() {
        return new PaymentTermRequest(contextPath.addSegment("paymentTerm"), Optional.ofNullable(paymentTerm));
    }

    @NavigationProperty(name="salesInvoiceLines")
    @JsonIgnore
    public SalesInvoiceLineCollectionRequest getSalesInvoiceLines() {
        return new SalesInvoiceLineCollectionRequest(
                        contextPath.addSegment("salesInvoiceLines"), Optional.ofNullable(salesInvoiceLines));
    }

    @NavigationProperty(name="shipmentMethod")
    @JsonIgnore
    public ShipmentMethodRequest getShipmentMethod() {
        return new ShipmentMethodRequest(contextPath.addSegment("shipmentMethod"), Optional.ofNullable(shipmentMethod));
    }

    public SalesInvoice withCurrency(Currency currency) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("currency");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.currency = currency;
        return _x;
    }

    public SalesInvoice withCustomer(Customer customer) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("customer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.customer = customer;
        return _x;
    }

    public SalesInvoice withPaymentTerm(PaymentTerm paymentTerm) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("paymentTerm");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.paymentTerm = paymentTerm;
        return _x;
    }

    public SalesInvoice withSalesInvoiceLines(List<SalesInvoiceLine> salesInvoiceLines) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("salesInvoiceLines");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.salesInvoiceLines = salesInvoiceLines;
        return _x;
    }

    public SalesInvoice withShipmentMethod(ShipmentMethod shipmentMethod) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("shipmentMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.shipmentMethod = shipmentMethod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SalesInvoice patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SalesInvoice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SalesInvoice put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SalesInvoice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SalesInvoice _copy() {
        SalesInvoice _x = new SalesInvoice();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.billingPostalAddress = billingPostalAddress;
        _x.billToCustomerId = billToCustomerId;
        _x.billToCustomerNumber = billToCustomerNumber;
        _x.billToName = billToName;
        _x.currencyCode = currencyCode;
        _x.currencyId = currencyId;
        _x.customerId = customerId;
        _x.customerName = customerName;
        _x.customerNumber = customerNumber;
        _x.customerPurchaseOrderReference = customerPurchaseOrderReference;
        _x.discountAmount = discountAmount;
        _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
        _x.dueDate = dueDate;
        _x.email = email;
        _x.externalDocumentNumber = externalDocumentNumber;
        _x.invoiceDate = invoiceDate;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.number = number;
        _x.orderId = orderId;
        _x.orderNumber = orderNumber;
        _x.paymentTermsId = paymentTermsId;
        _x.phoneNumber = phoneNumber;
        _x.pricesIncludeTax = pricesIncludeTax;
        _x.salesperson = salesperson;
        _x.sellingPostalAddress = sellingPostalAddress;
        _x.shipmentMethodId = shipmentMethodId;
        _x.shippingPostalAddress = shippingPostalAddress;
        _x.shipToContact = shipToContact;
        _x.shipToName = shipToName;
        _x.status = status;
        _x.totalAmountExcludingTax = totalAmountExcludingTax;
        _x.totalAmountIncludingTax = totalAmountIncludingTax;
        _x.totalTaxAmount = totalTaxAmount;
        _x.currency = currency;
        _x.customer = customer;
        _x.paymentTerm = paymentTerm;
        _x.salesInvoiceLines = salesInvoiceLines;
        _x.shipmentMethod = shipmentMethod;
        return _x;
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

    @Action(name = "send")
    @JsonIgnore
    public ActionRequestNoReturn send() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.send"), _parameters);
    }

    @Action(name = "cancelAndSend")
    @JsonIgnore
    public ActionRequestNoReturn cancelAndSend() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancelAndSend"), _parameters);
    }

    @Action(name = "post")
    @JsonIgnore
    public ActionRequestNoReturn post() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.post"), _parameters);
    }

    @Action(name = "postAndSend")
    @JsonIgnore
    public ActionRequestNoReturn postAndSend() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.postAndSend"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SalesInvoice[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("billingPostalAddress=");
        b.append(this.billingPostalAddress);
        b.append(", ");
        b.append("billToCustomerId=");
        b.append(this.billToCustomerId);
        b.append(", ");
        b.append("billToCustomerNumber=");
        b.append(this.billToCustomerNumber);
        b.append(", ");
        b.append("billToName=");
        b.append(this.billToName);
        b.append(", ");
        b.append("currencyCode=");
        b.append(this.currencyCode);
        b.append(", ");
        b.append("currencyId=");
        b.append(this.currencyId);
        b.append(", ");
        b.append("customerId=");
        b.append(this.customerId);
        b.append(", ");
        b.append("customerName=");
        b.append(this.customerName);
        b.append(", ");
        b.append("customerNumber=");
        b.append(this.customerNumber);
        b.append(", ");
        b.append("customerPurchaseOrderReference=");
        b.append(this.customerPurchaseOrderReference);
        b.append(", ");
        b.append("discountAmount=");
        b.append(this.discountAmount);
        b.append(", ");
        b.append("discountAppliedBeforeTax=");
        b.append(this.discountAppliedBeforeTax);
        b.append(", ");
        b.append("dueDate=");
        b.append(this.dueDate);
        b.append(", ");
        b.append("email=");
        b.append(this.email);
        b.append(", ");
        b.append("externalDocumentNumber=");
        b.append(this.externalDocumentNumber);
        b.append(", ");
        b.append("invoiceDate=");
        b.append(this.invoiceDate);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("number=");
        b.append(this.number);
        b.append(", ");
        b.append("orderId=");
        b.append(this.orderId);
        b.append(", ");
        b.append("orderNumber=");
        b.append(this.orderNumber);
        b.append(", ");
        b.append("paymentTermsId=");
        b.append(this.paymentTermsId);
        b.append(", ");
        b.append("phoneNumber=");
        b.append(this.phoneNumber);
        b.append(", ");
        b.append("pricesIncludeTax=");
        b.append(this.pricesIncludeTax);
        b.append(", ");
        b.append("salesperson=");
        b.append(this.salesperson);
        b.append(", ");
        b.append("sellingPostalAddress=");
        b.append(this.sellingPostalAddress);
        b.append(", ");
        b.append("shipmentMethodId=");
        b.append(this.shipmentMethodId);
        b.append(", ");
        b.append("shippingPostalAddress=");
        b.append(this.shippingPostalAddress);
        b.append(", ");
        b.append("shipToContact=");
        b.append(this.shipToContact);
        b.append(", ");
        b.append("shipToName=");
        b.append(this.shipToName);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("totalAmountExcludingTax=");
        b.append(this.totalAmountExcludingTax);
        b.append(", ");
        b.append("totalAmountIncludingTax=");
        b.append(this.totalAmountIncludingTax);
        b.append(", ");
        b.append("totalTaxAmount=");
        b.append(this.totalTaxAmount);
        b.append(", ");
        b.append("currency=");
        b.append(this.currency);
        b.append(", ");
        b.append("customer=");
        b.append(this.customer);
        b.append(", ");
        b.append("paymentTerm=");
        b.append(this.paymentTerm);
        b.append(", ");
        b.append("salesInvoiceLines=");
        b.append(this.salesInvoiceLines);
        b.append(", ");
        b.append("shipmentMethod=");
        b.append(this.shipmentMethod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
