package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.RbacApplicationMultipleRequest;
import odata.msgraph.client.beta.entity.request.RbacApplicationRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "directory", 
    "cloudPC", 
    "entitlementManagement", 
    "deviceManagement"})
@JsonInclude(Include.NON_NULL)
public class RoleManagement implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "microsoft.graph.roleManagement";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("directory")
    protected RbacApplication directory;

    @JsonProperty("cloudPC")
    protected RbacApplicationMultiple cloudPC;

    @JsonProperty("entitlementManagement")
    protected RbacApplication entitlementManagement;

    @JsonProperty("deviceManagement")
    protected RbacApplicationMultiple deviceManagement;

    protected RoleManagement() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private RbacApplication directory;
        private RbacApplicationMultiple cloudPC;
        private RbacApplication entitlementManagement;
        private RbacApplicationMultiple deviceManagement;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder directory(RbacApplication directory) {
            this.directory = directory;
            this.changedFields = changedFields.add("directory");
            return this;
        }

        public Builder cloudPC(RbacApplicationMultiple cloudPC) {
            this.cloudPC = cloudPC;
            this.changedFields = changedFields.add("cloudPC");
            return this;
        }

        /**
         * <i>“The RbacApplication for Entitlement Management”</i>
         * 
         * @param entitlementManagement
         *            value of {@code entitlementManagement} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder entitlementManagement(RbacApplication entitlementManagement) {
            this.entitlementManagement = entitlementManagement;
            this.changedFields = changedFields.add("entitlementManagement");
            return this;
        }

        /**
         * <i>“The RbacApplication for Device Management”</i>
         * 
         * @param deviceManagement
         *            value of {@code deviceManagement} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceManagement(RbacApplicationMultiple deviceManagement) {
            this.deviceManagement = deviceManagement;
            this.changedFields = changedFields.add("deviceManagement");
            return this;
        }

        public RoleManagement build() {
            RoleManagement _x = new RoleManagement();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.roleManagement";
            _x.directory = directory;
            _x.cloudPC = cloudPC;
            _x.entitlementManagement = entitlementManagement;
            _x.deviceManagement = deviceManagement;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath) {
            contextPath = contextPath.clearQueries();
        }
    }

    public RoleManagement withUnmappedField(String name, Object value) {
        RoleManagement _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="directory")
    @JsonIgnore
    public RbacApplicationRequest getDirectory() {
        return new RbacApplicationRequest(contextPath.addSegment("directory"), Optional.ofNullable(directory));
    }

    @NavigationProperty(name="cloudPC")
    @JsonIgnore
    public RbacApplicationMultipleRequest getCloudPC() {
        return new RbacApplicationMultipleRequest(contextPath.addSegment("cloudPC"), Optional.ofNullable(cloudPC));
    }

    /**
     * <i>“The RbacApplication for Entitlement Management”</i>
     * 
     * @return navigational property entitlementManagement
     */
    @NavigationProperty(name="entitlementManagement")
    @JsonIgnore
    public RbacApplicationRequest getEntitlementManagement() {
        return new RbacApplicationRequest(contextPath.addSegment("entitlementManagement"), Optional.ofNullable(entitlementManagement));
    }

    /**
     * <i>“The RbacApplication for Device Management”</i>
     * 
     * @return navigational property deviceManagement
     */
    @NavigationProperty(name="deviceManagement")
    @JsonIgnore
    public RbacApplicationMultipleRequest getDeviceManagement() {
        return new RbacApplicationMultipleRequest(contextPath.addSegment("deviceManagement"), Optional.ofNullable(deviceManagement));
    }

    public RoleManagement withDirectory(RbacApplication directory) {
        RoleManagement _x = _copy();
        _x.changedFields = changedFields.add("directory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleManagement");
        _x.directory = directory;
        return _x;
    }

    public RoleManagement withCloudPC(RbacApplicationMultiple cloudPC) {
        RoleManagement _x = _copy();
        _x.changedFields = changedFields.add("cloudPC");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleManagement");
        _x.cloudPC = cloudPC;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * entitlementManagement} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The RbacApplication for Entitlement Management”</i>
     * 
     * @param entitlementManagement
     *            new value of {@code entitlementManagement} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code entitlementManagement} field changed
     */
    public RoleManagement withEntitlementManagement(RbacApplication entitlementManagement) {
        RoleManagement _x = _copy();
        _x.changedFields = changedFields.add("entitlementManagement");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleManagement");
        _x.entitlementManagement = entitlementManagement;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceManagement}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The RbacApplication for Device Management”</i>
     * 
     * @param deviceManagement
     *            new value of {@code deviceManagement} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceManagement} field changed
     */
    public RoleManagement withDeviceManagement(RbacApplicationMultiple deviceManagement) {
        RoleManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceManagement");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleManagement");
        _x.deviceManagement = deviceManagement;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RoleManagement patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RoleManagement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RoleManagement put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RoleManagement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RoleManagement _copy() {
        RoleManagement _x = new RoleManagement();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.directory = directory;
        _x.cloudPC = cloudPC;
        _x.entitlementManagement = entitlementManagement;
        _x.deviceManagement = deviceManagement;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RoleManagement[");
        b.append("directory=");
        b.append(this.directory);
        b.append(", ");
        b.append("cloudPC=");
        b.append(this.cloudPC);
        b.append(", ");
        b.append("entitlementManagement=");
        b.append(this.entitlementManagement);
        b.append(", ");
        b.append("deviceManagement=");
        b.append(this.deviceManagement);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
