package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.RolePermission;
import odata.msgraph.client.beta.entity.collection.request.RoleAssignmentCollectionRequest;


/**
 * <i>“The Role Definition resource. The role definition is the foundation of role
 * based access in Intune. The role combines an Intune resource such as a Mobile
 * App and associated role permissions such as Create or Read for the resource.
 * There are two types of roles, built-in and custom. Built-in roles cannot be
 * modified. Both built-in roles and custom roles must have assignments to be
 * enforced. Create custom roles if you want to define a role that allows any of
 * the available resources and role permissions to be combined into a single role.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "isBuiltIn", 
    "isBuiltInRoleDefinition", 
    "permissions", 
    "rolePermissions", 
    "roleScopeTagIds", 
    "roleAssignments"})
@JsonInclude(Include.NON_NULL)
public class RoleDefinition extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.roleDefinition";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isBuiltIn")
    protected Boolean isBuiltIn;

    @JsonProperty("isBuiltInRoleDefinition")
    protected Boolean isBuiltInRoleDefinition;

    @JsonProperty("permissions")
    protected List<RolePermission> permissions;

    @JsonProperty("permissions@nextLink")
    protected String permissionsNextLink;

    @JsonProperty("rolePermissions")
    protected List<RolePermission> rolePermissions;

    @JsonProperty("rolePermissions@nextLink")
    protected String rolePermissionsNextLink;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("roleAssignments")
    protected List<RoleAssignment> roleAssignments;

    protected RoleDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRoleDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String displayName;
        private Boolean isBuiltIn;
        private Boolean isBuiltInRoleDefinition;
        private List<RolePermission> permissions;
        private String permissionsNextLink;
        private List<RolePermission> rolePermissions;
        private String rolePermissionsNextLink;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private List<RoleAssignment> roleAssignments;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Description of the Role definition.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Display Name of the Role definition.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Type of Role. Set to True if it is built-in, or set to False if it is a custom
         * role definition.”</i>
         * 
         * @param isBuiltIn
         *            value of {@code isBuiltIn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isBuiltIn(Boolean isBuiltIn) {
            this.isBuiltIn = isBuiltIn;
            this.changedFields = changedFields.add("isBuiltIn");
            return this;
        }

        /**
         * <i>“Type of Role. Set to True if it is built-in, or set to False if it is a custom
         * role definition.”</i>
         * 
         * @param isBuiltInRoleDefinition
         *            value of {@code isBuiltInRoleDefinition} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isBuiltInRoleDefinition(Boolean isBuiltInRoleDefinition) {
            this.isBuiltInRoleDefinition = isBuiltInRoleDefinition;
            this.changedFields = changedFields.add("isBuiltInRoleDefinition");
            return this;
        }

        /**
         * <i>“List of Role Permissions this role is allowed to perform. These must match the
         * actionName that is defined as part of the rolePermission.”</i>
         * 
         * @param permissions
         *            value of {@code permissions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder permissions(List<RolePermission> permissions) {
            this.permissions = permissions;
            this.changedFields = changedFields.add("permissions");
            return this;
        }

        /**
         * <i>“List of Role Permissions this role is allowed to perform. These must match the
         * actionName that is defined as part of the rolePermission.”</i>
         * 
         * @param permissions
         *            value of {@code permissions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder permissions(RolePermission... permissions) {
            return permissions(Arrays.asList(permissions));
        }

        /**
         * <i>“List of Role Permissions this role is allowed to perform. These must match the
         * actionName that is defined as part of the rolePermission.”</i>
         * 
         * @param permissionsNextLink
         *            value of {@code permissions@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder permissionsNextLink(String permissionsNextLink) {
            this.permissionsNextLink = permissionsNextLink;
            this.changedFields = changedFields.add("permissions");
            return this;
        }

        /**
         * <i>“List of Role Permissions this role is allowed to perform. These must match the
         * actionName that is defined as part of the rolePermission.”</i>
         * 
         * @param rolePermissions
         *            value of {@code rolePermissions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rolePermissions(List<RolePermission> rolePermissions) {
            this.rolePermissions = rolePermissions;
            this.changedFields = changedFields.add("rolePermissions");
            return this;
        }

        /**
         * <i>“List of Role Permissions this role is allowed to perform. These must match the
         * actionName that is defined as part of the rolePermission.”</i>
         * 
         * @param rolePermissions
         *            value of {@code rolePermissions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rolePermissions(RolePermission... rolePermissions) {
            return rolePermissions(Arrays.asList(rolePermissions));
        }

        /**
         * <i>“List of Role Permissions this role is allowed to perform. These must match the
         * actionName that is defined as part of the rolePermission.”</i>
         * 
         * @param rolePermissionsNextLink
         *            value of {@code rolePermissions@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rolePermissionsNextLink(String rolePermissionsNextLink) {
            this.rolePermissionsNextLink = rolePermissionsNextLink;
            this.changedFields = changedFields.add("rolePermissions");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Role assignments for this role definition.”</i>
         * 
         * @param roleAssignments
         *            value of {@code roleAssignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleAssignments(List<RoleAssignment> roleAssignments) {
            this.roleAssignments = roleAssignments;
            this.changedFields = changedFields.add("roleAssignments");
            return this;
        }

        /**
         * <i>“List of Role assignments for this role definition.”</i>
         * 
         * @param roleAssignments
         *            value of {@code roleAssignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleAssignments(RoleAssignment... roleAssignments) {
            return roleAssignments(Arrays.asList(roleAssignments));
        }

        public RoleDefinition build() {
            RoleDefinition _x = new RoleDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.roleDefinition";
            _x.id = id;
            _x.description = description;
            _x.displayName = displayName;
            _x.isBuiltIn = isBuiltIn;
            _x.isBuiltInRoleDefinition = isBuiltInRoleDefinition;
            _x.permissions = permissions;
            _x.permissionsNextLink = permissionsNextLink;
            _x.rolePermissions = rolePermissions;
            _x.rolePermissionsNextLink = rolePermissionsNextLink;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.roleAssignments = roleAssignments;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Description of the Role definition.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description of the Role definition.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public RoleDefinition withDescription(String description) {
        RoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleDefinition");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Display Name of the Role definition.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Display Name of the Role definition.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public RoleDefinition withDisplayName(String displayName) {
        RoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleDefinition");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Type of Role. Set to True if it is built-in, or set to False if it is a custom
     * role definition.”</i>
     * 
     * @return property isBuiltIn
     */
    @Property(name="isBuiltIn")
    @JsonIgnore
    public Optional<Boolean> getIsBuiltIn() {
        return Optional.ofNullable(isBuiltIn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isBuiltIn} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Type of Role. Set to True if it is built-in, or set to False if it is a custom
     * role definition.”</i>
     * 
     * @param isBuiltIn
     *            new value of {@code isBuiltIn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isBuiltIn} field changed
     */
    public RoleDefinition withIsBuiltIn(Boolean isBuiltIn) {
        RoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("isBuiltIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleDefinition");
        _x.isBuiltIn = isBuiltIn;
        return _x;
    }

    /**
     * <i>“Type of Role. Set to True if it is built-in, or set to False if it is a custom
     * role definition.”</i>
     * 
     * @return property isBuiltInRoleDefinition
     */
    @Property(name="isBuiltInRoleDefinition")
    @JsonIgnore
    public Optional<Boolean> getIsBuiltInRoleDefinition() {
        return Optional.ofNullable(isBuiltInRoleDefinition);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * isBuiltInRoleDefinition} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Type of Role. Set to True if it is built-in, or set to False if it is a custom
     * role definition.”</i>
     * 
     * @param isBuiltInRoleDefinition
     *            new value of {@code isBuiltInRoleDefinition} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isBuiltInRoleDefinition} field changed
     */
    public RoleDefinition withIsBuiltInRoleDefinition(Boolean isBuiltInRoleDefinition) {
        RoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("isBuiltInRoleDefinition");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleDefinition");
        _x.isBuiltInRoleDefinition = isBuiltInRoleDefinition;
        return _x;
    }

    /**
     * <i>“List of Role Permissions this role is allowed to perform. These must match the
     * actionName that is defined as part of the rolePermission.”</i>
     * 
     * @return property permissions
     */
    @Property(name="permissions")
    @JsonIgnore
    public CollectionPage<RolePermission> getPermissions() {
        return new CollectionPage<RolePermission>(contextPath, RolePermission.class, this.permissions, Optional.ofNullable(permissionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code permissions}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Role Permissions this role is allowed to perform. These must match the
     * actionName that is defined as part of the rolePermission.”</i>
     * 
     * @param permissions
     *            new value of {@code permissions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code permissions} field changed
     */
    public RoleDefinition withPermissions(List<RolePermission> permissions) {
        RoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("permissions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleDefinition");
        _x.permissions = permissions;
        return _x;
    }

    /**
     * <i>“List of Role Permissions this role is allowed to perform. These must match the
     * actionName that is defined as part of the rolePermission.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property permissions
     */
    @Property(name="permissions")
    @JsonIgnore
    public CollectionPage<RolePermission> getPermissions(HttpRequestOptions options) {
        return new CollectionPage<RolePermission>(contextPath, RolePermission.class, this.permissions, Optional.ofNullable(permissionsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of Role Permissions this role is allowed to perform. These must match the
     * actionName that is defined as part of the rolePermission.”</i>
     * 
     * @return property rolePermissions
     */
    @Property(name="rolePermissions")
    @JsonIgnore
    public CollectionPage<RolePermission> getRolePermissions() {
        return new CollectionPage<RolePermission>(contextPath, RolePermission.class, this.rolePermissions, Optional.ofNullable(rolePermissionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code rolePermissions}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Role Permissions this role is allowed to perform. These must match the
     * actionName that is defined as part of the rolePermission.”</i>
     * 
     * @param rolePermissions
     *            new value of {@code rolePermissions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code rolePermissions} field changed
     */
    public RoleDefinition withRolePermissions(List<RolePermission> rolePermissions) {
        RoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("rolePermissions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleDefinition");
        _x.rolePermissions = rolePermissions;
        return _x;
    }

    /**
     * <i>“List of Role Permissions this role is allowed to perform. These must match the
     * actionName that is defined as part of the rolePermission.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property rolePermissions
     */
    @Property(name="rolePermissions")
    @JsonIgnore
    public CollectionPage<RolePermission> getRolePermissions(HttpRequestOptions options) {
        return new CollectionPage<RolePermission>(contextPath, RolePermission.class, this.rolePermissions, Optional.ofNullable(rolePermissionsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public RoleDefinition withRoleScopeTagIds(List<String> roleScopeTagIds) {
        RoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleDefinition");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    public RoleDefinition withUnmappedField(String name, Object value) {
        RoleDefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“List of Role assignments for this role definition.”</i>
     * 
     * @return navigational property roleAssignments
     */
    @NavigationProperty(name="roleAssignments")
    @JsonIgnore
    public RoleAssignmentCollectionRequest getRoleAssignments() {
        return new RoleAssignmentCollectionRequest(
                        contextPath.addSegment("roleAssignments"), Optional.ofNullable(roleAssignments));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleAssignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Role assignments for this role definition.”</i>
     * 
     * @param roleAssignments
     *            new value of {@code roleAssignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleAssignments} field changed
     */
    public RoleDefinition withRoleAssignments(List<RoleAssignment> roleAssignments) {
        RoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("roleAssignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleDefinition");
        _x.roleAssignments = roleAssignments;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RoleDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RoleDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RoleDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RoleDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RoleDefinition _copy() {
        RoleDefinition _x = new RoleDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.isBuiltIn = isBuiltIn;
        _x.isBuiltInRoleDefinition = isBuiltInRoleDefinition;
        _x.permissions = permissions;
        _x.rolePermissions = rolePermissions;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.roleAssignments = roleAssignments;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RoleDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isBuiltIn=");
        b.append(this.isBuiltIn);
        b.append(", ");
        b.append("isBuiltInRoleDefinition=");
        b.append(this.isBuiltInRoleDefinition);
        b.append(", ");
        b.append("permissions=");
        b.append(this.permissions);
        b.append(", ");
        b.append("rolePermissions=");
        b.append(this.rolePermissions);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("roleAssignments=");
        b.append(this.roleAssignments);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
