package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.RiskServicePrincipalActivity;
import odata.msgraph.client.beta.enums.RiskDetail;
import odata.msgraph.client.beta.enums.RiskLevel;
import odata.msgraph.client.beta.enums.RiskState;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "activity", 
    "initiatedBy", 
    "servicePrincipalId"})
@JsonInclude(Include.NON_NULL)
public class RiskyServicePrincipalHistoryItem extends RiskyServicePrincipal implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.riskyServicePrincipalHistoryItem";
    }

    @JsonProperty("activity")
    protected RiskServicePrincipalActivity activity;

    @JsonProperty("initiatedBy")
    protected String initiatedBy;

    @JsonProperty("servicePrincipalId")
    protected String servicePrincipalId;

    protected RiskyServicePrincipalHistoryItem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRiskyServicePrincipalHistoryItem() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean accountEnabled;
        private String appId;
        private String displayName;
        private Boolean isProcessing;
        private RiskDetail riskDetail;
        private OffsetDateTime riskLastUpdatedDateTime;
        private RiskLevel riskLevel;
        private RiskState riskState;
        private String servicePrincipalType;
        private List<RiskyServicePrincipalHistoryItem> history;
        private RiskServicePrincipalActivity activity;
        private String initiatedBy;
        private String servicePrincipalId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder accountEnabled(Boolean accountEnabled) {
            this.accountEnabled = accountEnabled;
            this.changedFields = changedFields.add("accountEnabled");
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isProcessing(Boolean isProcessing) {
            this.isProcessing = isProcessing;
            this.changedFields = changedFields.add("isProcessing");
            return this;
        }

        public Builder riskDetail(RiskDetail riskDetail) {
            this.riskDetail = riskDetail;
            this.changedFields = changedFields.add("riskDetail");
            return this;
        }

        public Builder riskLastUpdatedDateTime(OffsetDateTime riskLastUpdatedDateTime) {
            this.riskLastUpdatedDateTime = riskLastUpdatedDateTime;
            this.changedFields = changedFields.add("riskLastUpdatedDateTime");
            return this;
        }

        public Builder riskLevel(RiskLevel riskLevel) {
            this.riskLevel = riskLevel;
            this.changedFields = changedFields.add("riskLevel");
            return this;
        }

        public Builder riskState(RiskState riskState) {
            this.riskState = riskState;
            this.changedFields = changedFields.add("riskState");
            return this;
        }

        public Builder servicePrincipalType(String servicePrincipalType) {
            this.servicePrincipalType = servicePrincipalType;
            this.changedFields = changedFields.add("servicePrincipalType");
            return this;
        }

        public Builder history(List<RiskyServicePrincipalHistoryItem> history) {
            this.history = history;
            this.changedFields = changedFields.add("history");
            return this;
        }

        public Builder history(RiskyServicePrincipalHistoryItem... history) {
            return history(Arrays.asList(history));
        }

        public Builder activity(RiskServicePrincipalActivity activity) {
            this.activity = activity;
            this.changedFields = changedFields.add("activity");
            return this;
        }

        public Builder initiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
            this.changedFields = changedFields.add("initiatedBy");
            return this;
        }

        public Builder servicePrincipalId(String servicePrincipalId) {
            this.servicePrincipalId = servicePrincipalId;
            this.changedFields = changedFields.add("servicePrincipalId");
            return this;
        }

        public RiskyServicePrincipalHistoryItem build() {
            RiskyServicePrincipalHistoryItem _x = new RiskyServicePrincipalHistoryItem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.riskyServicePrincipalHistoryItem";
            _x.id = id;
            _x.accountEnabled = accountEnabled;
            _x.appId = appId;
            _x.displayName = displayName;
            _x.isProcessing = isProcessing;
            _x.riskDetail = riskDetail;
            _x.riskLastUpdatedDateTime = riskLastUpdatedDateTime;
            _x.riskLevel = riskLevel;
            _x.riskState = riskState;
            _x.servicePrincipalType = servicePrincipalType;
            _x.history = history;
            _x.activity = activity;
            _x.initiatedBy = initiatedBy;
            _x.servicePrincipalId = servicePrincipalId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="activity")
    @JsonIgnore
    public Optional<RiskServicePrincipalActivity> getActivity() {
        return Optional.ofNullable(activity);
    }

    public RiskyServicePrincipalHistoryItem withActivity(RiskServicePrincipalActivity activity) {
        RiskyServicePrincipalHistoryItem _x = _copy();
        _x.changedFields = changedFields.add("activity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyServicePrincipalHistoryItem");
        _x.activity = activity;
        return _x;
    }

    @Property(name="initiatedBy")
    @JsonIgnore
    public Optional<String> getInitiatedBy() {
        return Optional.ofNullable(initiatedBy);
    }

    public RiskyServicePrincipalHistoryItem withInitiatedBy(String initiatedBy) {
        RiskyServicePrincipalHistoryItem _x = _copy();
        _x.changedFields = changedFields.add("initiatedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyServicePrincipalHistoryItem");
        _x.initiatedBy = initiatedBy;
        return _x;
    }

    @Property(name="servicePrincipalId")
    @JsonIgnore
    public Optional<String> getServicePrincipalId() {
        return Optional.ofNullable(servicePrincipalId);
    }

    public RiskyServicePrincipalHistoryItem withServicePrincipalId(String servicePrincipalId) {
        RiskyServicePrincipalHistoryItem _x = _copy();
        _x.changedFields = changedFields.add("servicePrincipalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyServicePrincipalHistoryItem");
        _x.servicePrincipalId = servicePrincipalId;
        return _x;
    }

    public RiskyServicePrincipalHistoryItem withUnmappedField(String name, Object value) {
        RiskyServicePrincipalHistoryItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RiskyServicePrincipalHistoryItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RiskyServicePrincipalHistoryItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RiskyServicePrincipalHistoryItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RiskyServicePrincipalHistoryItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RiskyServicePrincipalHistoryItem _copy() {
        RiskyServicePrincipalHistoryItem _x = new RiskyServicePrincipalHistoryItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.accountEnabled = accountEnabled;
        _x.appId = appId;
        _x.displayName = displayName;
        _x.isProcessing = isProcessing;
        _x.riskDetail = riskDetail;
        _x.riskLastUpdatedDateTime = riskLastUpdatedDateTime;
        _x.riskLevel = riskLevel;
        _x.riskState = riskState;
        _x.servicePrincipalType = servicePrincipalType;
        _x.history = history;
        _x.activity = activity;
        _x.initiatedBy = initiatedBy;
        _x.servicePrincipalId = servicePrincipalId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RiskyServicePrincipalHistoryItem[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accountEnabled=");
        b.append(this.accountEnabled);
        b.append(", ");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isProcessing=");
        b.append(this.isProcessing);
        b.append(", ");
        b.append("riskDetail=");
        b.append(this.riskDetail);
        b.append(", ");
        b.append("riskLastUpdatedDateTime=");
        b.append(this.riskLastUpdatedDateTime);
        b.append(", ");
        b.append("riskLevel=");
        b.append(this.riskLevel);
        b.append(", ");
        b.append("riskState=");
        b.append(this.riskState);
        b.append(", ");
        b.append("servicePrincipalType=");
        b.append(this.servicePrincipalType);
        b.append(", ");
        b.append("history=");
        b.append(this.history);
        b.append(", ");
        b.append("activity=");
        b.append(this.activity);
        b.append(", ");
        b.append("initiatedBy=");
        b.append(this.initiatedBy);
        b.append(", ");
        b.append("servicePrincipalId=");
        b.append(this.servicePrincipalId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
