package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PublicError;
import odata.msgraph.client.beta.enums.LongRunningOperationStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "error", 
    "percentageComplete", 
    "resourceId", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class RichLongRunningOperation extends LongRunningOperation implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.richLongRunningOperation";
    }

    @JsonProperty("error")
    protected PublicError error;

    @JsonProperty("percentageComplete")
    protected Integer percentageComplete;

    @JsonProperty("resourceId")
    protected String resourceId;

    @JsonProperty("type")
    protected String type;

    protected RichLongRunningOperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRichLongRunningOperation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastActionDateTime;
        private String resourceLocation;
        private LongRunningOperationStatus status;
        private String statusDetail;
        private PublicError error;
        private Integer percentageComplete;
        private String resourceId;
        private String type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastActionDateTime(OffsetDateTime lastActionDateTime) {
            this.lastActionDateTime = lastActionDateTime;
            this.changedFields = changedFields.add("lastActionDateTime");
            return this;
        }

        public Builder resourceLocation(String resourceLocation) {
            this.resourceLocation = resourceLocation;
            this.changedFields = changedFields.add("resourceLocation");
            return this;
        }

        public Builder status(LongRunningOperationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            this.changedFields = changedFields.add("statusDetail");
            return this;
        }

        public Builder error(PublicError error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder percentageComplete(Integer percentageComplete) {
            this.percentageComplete = percentageComplete;
            this.changedFields = changedFields.add("percentageComplete");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = changedFields.add("resourceId");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public RichLongRunningOperation build() {
            RichLongRunningOperation _x = new RichLongRunningOperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.richLongRunningOperation";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.lastActionDateTime = lastActionDateTime;
            _x.resourceLocation = resourceLocation;
            _x.status = status;
            _x.statusDetail = statusDetail;
            _x.error = error;
            _x.percentageComplete = percentageComplete;
            _x.resourceId = resourceId;
            _x.type = type;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<PublicError> getError() {
        return Optional.ofNullable(error);
    }

    public RichLongRunningOperation withError(PublicError error) {
        RichLongRunningOperation _x = _copy();
        _x.changedFields = changedFields.add("error");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.richLongRunningOperation");
        _x.error = error;
        return _x;
    }

    @Property(name="percentageComplete")
    @JsonIgnore
    public Optional<Integer> getPercentageComplete() {
        return Optional.ofNullable(percentageComplete);
    }

    public RichLongRunningOperation withPercentageComplete(Integer percentageComplete) {
        RichLongRunningOperation _x = _copy();
        _x.changedFields = changedFields.add("percentageComplete");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.richLongRunningOperation");
        _x.percentageComplete = percentageComplete;
        return _x;
    }

    @Property(name="resourceId")
    @JsonIgnore
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    public RichLongRunningOperation withResourceId(String resourceId) {
        RichLongRunningOperation _x = _copy();
        _x.changedFields = changedFields.add("resourceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.richLongRunningOperation");
        _x.resourceId = resourceId;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public RichLongRunningOperation withType(String type) {
        RichLongRunningOperation _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.richLongRunningOperation");
        _x.type = type;
        return _x;
    }

    public RichLongRunningOperation withUnmappedField(String name, Object value) {
        RichLongRunningOperation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RichLongRunningOperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RichLongRunningOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RichLongRunningOperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RichLongRunningOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RichLongRunningOperation _copy() {
        RichLongRunningOperation _x = new RichLongRunningOperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.lastActionDateTime = lastActionDateTime;
        _x.resourceLocation = resourceLocation;
        _x.status = status;
        _x.statusDetail = statusDetail;
        _x.error = error;
        _x.percentageComplete = percentageComplete;
        _x.resourceId = resourceId;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RichLongRunningOperation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastActionDateTime=");
        b.append(this.lastActionDateTime);
        b.append(", ");
        b.append("resourceLocation=");
        b.append(this.resourceLocation);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("statusDetail=");
        b.append(this.statusDetail);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("percentageComplete=");
        b.append(this.percentageComplete);
        b.append(", ");
        b.append("resourceId=");
        b.append(this.resourceId);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
