package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ManagedDeviceReportedApp;
import odata.msgraph.client.beta.enums.PolicyPlatformType;
import odata.msgraph.client.beta.enums.RestrictedAppsState;


/**
 * <i>“Violation of restricted apps configuration profile per device per user”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceConfigurationId", 
    "deviceConfigurationName", 
    "deviceName", 
    "managedDeviceId", 
    "platformType", 
    "restrictedApps", 
    "restrictedAppsState", 
    "userId", 
    "userName"})
@JsonInclude(Include.NON_NULL)
public class RestrictedAppsViolation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.restrictedAppsViolation";
    }

    @JsonProperty("deviceConfigurationId")
    protected String deviceConfigurationId;

    @JsonProperty("deviceConfigurationName")
    protected String deviceConfigurationName;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("managedDeviceId")
    protected String managedDeviceId;

    @JsonProperty("platformType")
    protected PolicyPlatformType platformType;

    @JsonProperty("restrictedApps")
    protected List<ManagedDeviceReportedApp> restrictedApps;

    @JsonProperty("restrictedApps@nextLink")
    protected String restrictedAppsNextLink;

    @JsonProperty("restrictedAppsState")
    protected RestrictedAppsState restrictedAppsState;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userName")
    protected String userName;

    protected RestrictedAppsViolation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRestrictedAppsViolation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String deviceConfigurationId;
        private String deviceConfigurationName;
        private String deviceName;
        private String managedDeviceId;
        private PolicyPlatformType platformType;
        private List<ManagedDeviceReportedApp> restrictedApps;
        private String restrictedAppsNextLink;
        private RestrictedAppsState restrictedAppsState;
        private String userId;
        private String userName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Device configuration profile unique identifier, must be Guid”</i>
         * 
         * @param deviceConfigurationId
         *            value of {@code deviceConfigurationId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceConfigurationId(String deviceConfigurationId) {
            this.deviceConfigurationId = deviceConfigurationId;
            this.changedFields = changedFields.add("deviceConfigurationId");
            return this;
        }

        /**
         * <i>“Device configuration profile name”</i>
         * 
         * @param deviceConfigurationName
         *            value of {@code deviceConfigurationName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceConfigurationName(String deviceConfigurationName) {
            this.deviceConfigurationName = deviceConfigurationName;
            this.changedFields = changedFields.add("deviceConfigurationName");
            return this;
        }

        /**
         * <i>“Device name”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“Managed device unique identifier, must be Guid”</i>
         * 
         * @param managedDeviceId
         *            value of {@code managedDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            this.changedFields = changedFields.add("managedDeviceId");
            return this;
        }

        /**
         * <i>“Platform type”</i>
         * 
         * @param platformType
         *            value of {@code platformType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platformType(PolicyPlatformType platformType) {
            this.platformType = platformType;
            this.changedFields = changedFields.add("platformType");
            return this;
        }

        /**
         * <i>“List of violated restricted apps”</i>
         * 
         * @param restrictedApps
         *            value of {@code restrictedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restrictedApps(List<ManagedDeviceReportedApp> restrictedApps) {
            this.restrictedApps = restrictedApps;
            this.changedFields = changedFields.add("restrictedApps");
            return this;
        }

        /**
         * <i>“List of violated restricted apps”</i>
         * 
         * @param restrictedApps
         *            value of {@code restrictedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restrictedApps(ManagedDeviceReportedApp... restrictedApps) {
            return restrictedApps(Arrays.asList(restrictedApps));
        }

        /**
         * <i>“List of violated restricted apps”</i>
         * 
         * @param restrictedAppsNextLink
         *            value of {@code restrictedApps@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restrictedAppsNextLink(String restrictedAppsNextLink) {
            this.restrictedAppsNextLink = restrictedAppsNextLink;
            this.changedFields = changedFields.add("restrictedApps");
            return this;
        }

        /**
         * <i>“Restricted apps state”</i>
         * 
         * @param restrictedAppsState
         *            value of {@code restrictedAppsState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restrictedAppsState(RestrictedAppsState restrictedAppsState) {
            this.restrictedAppsState = restrictedAppsState;
            this.changedFields = changedFields.add("restrictedAppsState");
            return this;
        }

        /**
         * <i>“User unique identifier, must be Guid”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“User name”</i>
         * 
         * @param userName
         *            value of {@code userName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userName(String userName) {
            this.userName = userName;
            this.changedFields = changedFields.add("userName");
            return this;
        }

        public RestrictedAppsViolation build() {
            RestrictedAppsViolation _x = new RestrictedAppsViolation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.restrictedAppsViolation";
            _x.id = id;
            _x.deviceConfigurationId = deviceConfigurationId;
            _x.deviceConfigurationName = deviceConfigurationName;
            _x.deviceName = deviceName;
            _x.managedDeviceId = managedDeviceId;
            _x.platformType = platformType;
            _x.restrictedApps = restrictedApps;
            _x.restrictedAppsNextLink = restrictedAppsNextLink;
            _x.restrictedAppsState = restrictedAppsState;
            _x.userId = userId;
            _x.userName = userName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Device configuration profile unique identifier, must be Guid”</i>
     * 
     * @return property deviceConfigurationId
     */
    @Property(name="deviceConfigurationId")
    @JsonIgnore
    public Optional<String> getDeviceConfigurationId() {
        return Optional.ofNullable(deviceConfigurationId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceConfigurationId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Device configuration profile unique identifier, must be Guid”</i>
     * 
     * @param deviceConfigurationId
     *            new value of {@code deviceConfigurationId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceConfigurationId} field changed
     */
    public RestrictedAppsViolation withDeviceConfigurationId(String deviceConfigurationId) {
        RestrictedAppsViolation _x = _copy();
        _x.changedFields = changedFields.add("deviceConfigurationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.restrictedAppsViolation");
        _x.deviceConfigurationId = deviceConfigurationId;
        return _x;
    }

    /**
     * <i>“Device configuration profile name”</i>
     * 
     * @return property deviceConfigurationName
     */
    @Property(name="deviceConfigurationName")
    @JsonIgnore
    public Optional<String> getDeviceConfigurationName() {
        return Optional.ofNullable(deviceConfigurationName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceConfigurationName} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device configuration profile name”</i>
     * 
     * @param deviceConfigurationName
     *            new value of {@code deviceConfigurationName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceConfigurationName} field changed
     */
    public RestrictedAppsViolation withDeviceConfigurationName(String deviceConfigurationName) {
        RestrictedAppsViolation _x = _copy();
        _x.changedFields = changedFields.add("deviceConfigurationName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.restrictedAppsViolation");
        _x.deviceConfigurationName = deviceConfigurationName;
        return _x;
    }

    /**
     * <i>“Device name”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device name”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public RestrictedAppsViolation withDeviceName(String deviceName) {
        RestrictedAppsViolation _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.restrictedAppsViolation");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“Managed device unique identifier, must be Guid”</i>
     * 
     * @return property managedDeviceId
     */
    @Property(name="managedDeviceId")
    @JsonIgnore
    public Optional<String> getManagedDeviceId() {
        return Optional.ofNullable(managedDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedDeviceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Managed device unique identifier, must be Guid”</i>
     * 
     * @param managedDeviceId
     *            new value of {@code managedDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceId} field changed
     */
    public RestrictedAppsViolation withManagedDeviceId(String managedDeviceId) {
        RestrictedAppsViolation _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.restrictedAppsViolation");
        _x.managedDeviceId = managedDeviceId;
        return _x;
    }

    /**
     * <i>“Platform type”</i>
     * 
     * @return property platformType
     */
    @Property(name="platformType")
    @JsonIgnore
    public Optional<PolicyPlatformType> getPlatformType() {
        return Optional.ofNullable(platformType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platformType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Platform type”</i>
     * 
     * @param platformType
     *            new value of {@code platformType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platformType} field changed
     */
    public RestrictedAppsViolation withPlatformType(PolicyPlatformType platformType) {
        RestrictedAppsViolation _x = _copy();
        _x.changedFields = changedFields.add("platformType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.restrictedAppsViolation");
        _x.platformType = platformType;
        return _x;
    }

    /**
     * <i>“List of violated restricted apps”</i>
     * 
     * @return property restrictedApps
     */
    @Property(name="restrictedApps")
    @JsonIgnore
    public CollectionPage<ManagedDeviceReportedApp> getRestrictedApps() {
        return new CollectionPage<ManagedDeviceReportedApp>(contextPath, ManagedDeviceReportedApp.class, this.restrictedApps, Optional.ofNullable(restrictedAppsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code restrictedApps}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of violated restricted apps”</i>
     * 
     * @param restrictedApps
     *            new value of {@code restrictedApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code restrictedApps} field changed
     */
    public RestrictedAppsViolation withRestrictedApps(List<ManagedDeviceReportedApp> restrictedApps) {
        RestrictedAppsViolation _x = _copy();
        _x.changedFields = changedFields.add("restrictedApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.restrictedAppsViolation");
        _x.restrictedApps = restrictedApps;
        return _x;
    }

    /**
     * <i>“List of violated restricted apps”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property restrictedApps
     */
    @Property(name="restrictedApps")
    @JsonIgnore
    public CollectionPage<ManagedDeviceReportedApp> getRestrictedApps(HttpRequestOptions options) {
        return new CollectionPage<ManagedDeviceReportedApp>(contextPath, ManagedDeviceReportedApp.class, this.restrictedApps, Optional.ofNullable(restrictedAppsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Restricted apps state”</i>
     * 
     * @return property restrictedAppsState
     */
    @Property(name="restrictedAppsState")
    @JsonIgnore
    public Optional<RestrictedAppsState> getRestrictedAppsState() {
        return Optional.ofNullable(restrictedAppsState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * restrictedAppsState} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Restricted apps state”</i>
     * 
     * @param restrictedAppsState
     *            new value of {@code restrictedAppsState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code restrictedAppsState} field changed
     */
    public RestrictedAppsViolation withRestrictedAppsState(RestrictedAppsState restrictedAppsState) {
        RestrictedAppsViolation _x = _copy();
        _x.changedFields = changedFields.add("restrictedAppsState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.restrictedAppsViolation");
        _x.restrictedAppsState = restrictedAppsState;
        return _x;
    }

    /**
     * <i>“User unique identifier, must be Guid”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“User unique identifier, must be Guid”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public RestrictedAppsViolation withUserId(String userId) {
        RestrictedAppsViolation _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.restrictedAppsViolation");
        _x.userId = userId;
        return _x;
    }

    /**
     * <i>“User name”</i>
     * 
     * @return property userName
     */
    @Property(name="userName")
    @JsonIgnore
    public Optional<String> getUserName() {
        return Optional.ofNullable(userName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“User name”</i>
     * 
     * @param userName
     *            new value of {@code userName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userName} field changed
     */
    public RestrictedAppsViolation withUserName(String userName) {
        RestrictedAppsViolation _x = _copy();
        _x.changedFields = changedFields.add("userName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.restrictedAppsViolation");
        _x.userName = userName;
        return _x;
    }

    public RestrictedAppsViolation withUnmappedField(String name, Object value) {
        RestrictedAppsViolation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RestrictedAppsViolation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RestrictedAppsViolation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RestrictedAppsViolation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RestrictedAppsViolation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RestrictedAppsViolation _copy() {
        RestrictedAppsViolation _x = new RestrictedAppsViolation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deviceConfigurationId = deviceConfigurationId;
        _x.deviceConfigurationName = deviceConfigurationName;
        _x.deviceName = deviceName;
        _x.managedDeviceId = managedDeviceId;
        _x.platformType = platformType;
        _x.restrictedApps = restrictedApps;
        _x.restrictedAppsState = restrictedAppsState;
        _x.userId = userId;
        _x.userName = userName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RestrictedAppsViolation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deviceConfigurationId=");
        b.append(this.deviceConfigurationId);
        b.append(", ");
        b.append("deviceConfigurationName=");
        b.append(this.deviceConfigurationName);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("managedDeviceId=");
        b.append(this.managedDeviceId);
        b.append(", ");
        b.append("platformType=");
        b.append(this.platformType);
        b.append(", ");
        b.append("restrictedApps=");
        b.append(this.restrictedApps);
        b.append(", ");
        b.append("restrictedAppsState=");
        b.append(this.restrictedAppsState);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userName=");
        b.append(this.userName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
