package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;

@JsonPropertyOrder({
    "@odata.type", 
    "approvalId", 
    "completedDateTime", 
    "createdBy", 
    "createdDateTime", 
    "customData", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class Request extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.request";
    }

    @JsonProperty("approvalId")
    protected String approvalId;

    @JsonProperty("completedDateTime")
    protected OffsetDateTime completedDateTime;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("customData")
    protected String customData;

    @JsonProperty("status")
    protected String status;

    protected Request() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String approvalId;
        private OffsetDateTime completedDateTime;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private String customData;
        private String status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder approvalId(String approvalId) {
            this.approvalId = approvalId;
            this.changedFields = changedFields.add("approvalId");
            return this;
        }

        public Builder completedDateTime(OffsetDateTime completedDateTime) {
            this.completedDateTime = completedDateTime;
            this.changedFields = changedFields.add("completedDateTime");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder customData(String customData) {
            this.customData = customData;
            this.changedFields = changedFields.add("customData");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Request build() {
            Request _x = new Request();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.request";
            _x.id = id;
            _x.approvalId = approvalId;
            _x.completedDateTime = completedDateTime;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.customData = customData;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="approvalId")
    @JsonIgnore
    public Optional<String> getApprovalId() {
        return Optional.ofNullable(approvalId);
    }

    public Request withApprovalId(String approvalId) {
        Request _x = _copy();
        _x.changedFields = changedFields.add("approvalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.request");
        _x.approvalId = approvalId;
        return _x;
    }

    @Property(name="completedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedDateTime() {
        return Optional.ofNullable(completedDateTime);
    }

    public Request withCompletedDateTime(OffsetDateTime completedDateTime) {
        Request _x = _copy();
        _x.changedFields = changedFields.add("completedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.request");
        _x.completedDateTime = completedDateTime;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public Request withCreatedBy(IdentitySet createdBy) {
        Request _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.request");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Request withCreatedDateTime(OffsetDateTime createdDateTime) {
        Request _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.request");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="customData")
    @JsonIgnore
    public Optional<String> getCustomData() {
        return Optional.ofNullable(customData);
    }

    public Request withCustomData(String customData) {
        Request _x = _copy();
        _x.changedFields = changedFields.add("customData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.request");
        _x.customData = customData;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public Request withStatus(String status) {
        Request _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.request");
        _x.status = status;
        return _x;
    }

    public Request withUnmappedField(String name, Object value) {
        Request _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Request patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Request _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Request put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Request _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Request _copy() {
        Request _x = new Request();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.approvalId = approvalId;
        _x.completedDateTime = completedDateTime;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.customData = customData;
        _x.status = status;
        return _x;
    }

    @Action(name = "stop")
    @JsonIgnore
    public ActionRequestNoReturn stop() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stop"), _parameters);
    }

    @Action(name = "recordDecisions")
    @JsonIgnore
    public ActionRequestNoReturn recordDecisions(String reviewResult, String justification) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("reviewResult", "Edm.String", Checks.checkIsAscii(reviewResult))
            .put("justification", "Edm.String", Checks.checkIsAscii(justification))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.recordDecisions"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Request[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("approvalId=");
        b.append(this.approvalId);
        b.append(", ");
        b.append("completedDateTime=");
        b.append(this.completedDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("customData=");
        b.append(this.customData);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
