package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RemoteAssistanceState;


/**
 * <i>“Remote assistance settings for the account”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowSessionsToUnenrolledDevices", 
    "remoteAssistanceState"})
@JsonInclude(Include.NON_NULL)
public class RemoteAssistanceSettings extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.remoteAssistanceSettings";
    }

    @JsonProperty("allowSessionsToUnenrolledDevices")
    protected Boolean allowSessionsToUnenrolledDevices;

    @JsonProperty("remoteAssistanceState")
    protected RemoteAssistanceState remoteAssistanceState;

    protected RemoteAssistanceSettings() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRemoteAssistanceSettings() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean allowSessionsToUnenrolledDevices;
        private RemoteAssistanceState remoteAssistanceState;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Indicates if sessions to unenrolled devices are allowed for the account. This
         * setting is configurable by the admin. Default value is false.”</i>
         * 
         * @param allowSessionsToUnenrolledDevices
         *            value of {@code allowSessionsToUnenrolledDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowSessionsToUnenrolledDevices(Boolean allowSessionsToUnenrolledDevices) {
            this.allowSessionsToUnenrolledDevices = allowSessionsToUnenrolledDevices;
            this.changedFields = changedFields.add("allowSessionsToUnenrolledDevices");
            return this;
        }

        /**
         * <i>“The current state of remote assistance for the account. Possible values are:
         * disabled, enabled. This setting is configurable by the admin. Remote assistance
         * settings that have not yet been configured by the admin have a disabled state.
         * Returned by default.”</i>
         * 
         * @param remoteAssistanceState
         *            value of {@code remoteAssistanceState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remoteAssistanceState(RemoteAssistanceState remoteAssistanceState) {
            this.remoteAssistanceState = remoteAssistanceState;
            this.changedFields = changedFields.add("remoteAssistanceState");
            return this;
        }

        public RemoteAssistanceSettings build() {
            RemoteAssistanceSettings _x = new RemoteAssistanceSettings();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.remoteAssistanceSettings";
            _x.id = id;
            _x.allowSessionsToUnenrolledDevices = allowSessionsToUnenrolledDevices;
            _x.remoteAssistanceState = remoteAssistanceState;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Indicates if sessions to unenrolled devices are allowed for the account. This
     * setting is configurable by the admin. Default value is false.”</i>
     * 
     * @return property allowSessionsToUnenrolledDevices
     */
    @Property(name="allowSessionsToUnenrolledDevices")
    @JsonIgnore
    public Optional<Boolean> getAllowSessionsToUnenrolledDevices() {
        return Optional.ofNullable(allowSessionsToUnenrolledDevices);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowSessionsToUnenrolledDevices} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates if sessions to unenrolled devices are allowed for the account. This
     * setting is configurable by the admin. Default value is false.”</i>
     * 
     * @param allowSessionsToUnenrolledDevices
     *            new value of {@code allowSessionsToUnenrolledDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowSessionsToUnenrolledDevices} field changed
     */
    public RemoteAssistanceSettings withAllowSessionsToUnenrolledDevices(Boolean allowSessionsToUnenrolledDevices) {
        RemoteAssistanceSettings _x = _copy();
        _x.changedFields = changedFields.add("allowSessionsToUnenrolledDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteAssistanceSettings");
        _x.allowSessionsToUnenrolledDevices = allowSessionsToUnenrolledDevices;
        return _x;
    }

    /**
     * <i>“The current state of remote assistance for the account. Possible values are:
     * disabled, enabled. This setting is configurable by the admin. Remote assistance
     * settings that have not yet been configured by the admin have a disabled state.
     * Returned by default.”</i>
     * 
     * @return property remoteAssistanceState
     */
    @Property(name="remoteAssistanceState")
    @JsonIgnore
    public Optional<RemoteAssistanceState> getRemoteAssistanceState() {
        return Optional.ofNullable(remoteAssistanceState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remoteAssistanceState} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The current state of remote assistance for the account. Possible values are:
     * disabled, enabled. This setting is configurable by the admin. Remote assistance
     * settings that have not yet been configured by the admin have a disabled state.
     * Returned by default.”</i>
     * 
     * @param remoteAssistanceState
     *            new value of {@code remoteAssistanceState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remoteAssistanceState} field changed
     */
    public RemoteAssistanceSettings withRemoteAssistanceState(RemoteAssistanceState remoteAssistanceState) {
        RemoteAssistanceSettings _x = _copy();
        _x.changedFields = changedFields.add("remoteAssistanceState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteAssistanceSettings");
        _x.remoteAssistanceState = remoteAssistanceState;
        return _x;
    }

    public RemoteAssistanceSettings withUnmappedField(String name, Object value) {
        RemoteAssistanceSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RemoteAssistanceSettings patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RemoteAssistanceSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RemoteAssistanceSettings put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RemoteAssistanceSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RemoteAssistanceSettings _copy() {
        RemoteAssistanceSettings _x = new RemoteAssistanceSettings();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.allowSessionsToUnenrolledDevices = allowSessionsToUnenrolledDevices;
        _x.remoteAssistanceState = remoteAssistanceState;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RemoteAssistanceSettings[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("allowSessionsToUnenrolledDevices=");
        b.append(this.allowSessionsToUnenrolledDevices);
        b.append(", ");
        b.append("remoteAssistanceState=");
        b.append(this.remoteAssistanceState);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
