package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.enums.MigrationStatus;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "failedSignInCount", 
    "migrationStatus", 
    "migrationValidationDetails", 
    "relyingPartyId", 
    "relyingPartyName", 
    "replyUrls", 
    "serviceId", 
    "signInSuccessRate", 
    "successfulSignInCount", 
    "totalSignInCount", 
    "uniqueUserCount"})
@JsonInclude(Include.NON_NULL)
public class RelyingPartyDetailedSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.relyingPartyDetailedSummary";
    }

    @JsonProperty("failedSignInCount")
    protected Long failedSignInCount;

    @JsonProperty("migrationStatus")
    protected MigrationStatus migrationStatus;

    @JsonProperty("migrationValidationDetails")
    protected List<KeyValuePair> migrationValidationDetails;

    @JsonProperty("migrationValidationDetails@nextLink")
    protected String migrationValidationDetailsNextLink;

    @JsonProperty("relyingPartyId")
    protected String relyingPartyId;

    @JsonProperty("relyingPartyName")
    protected String relyingPartyName;

    @JsonProperty("replyUrls")
    protected List<String> replyUrls;

    @JsonProperty("replyUrls@nextLink")
    protected String replyUrlsNextLink;

    @JsonProperty("serviceId")
    protected String serviceId;

    @JsonProperty("signInSuccessRate")
    protected Double signInSuccessRate;

    @JsonProperty("successfulSignInCount")
    protected Long successfulSignInCount;

    @JsonProperty("totalSignInCount")
    protected Long totalSignInCount;

    @JsonProperty("uniqueUserCount")
    protected Long uniqueUserCount;

    protected RelyingPartyDetailedSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRelyingPartyDetailedSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Long failedSignInCount;
        private MigrationStatus migrationStatus;
        private List<KeyValuePair> migrationValidationDetails;
        private String migrationValidationDetailsNextLink;
        private String relyingPartyId;
        private String relyingPartyName;
        private List<String> replyUrls;
        private String replyUrlsNextLink;
        private String serviceId;
        private Double signInSuccessRate;
        private Long successfulSignInCount;
        private Long totalSignInCount;
        private Long uniqueUserCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder failedSignInCount(Long failedSignInCount) {
            this.failedSignInCount = failedSignInCount;
            this.changedFields = changedFields.add("failedSignInCount");
            return this;
        }

        public Builder migrationStatus(MigrationStatus migrationStatus) {
            this.migrationStatus = migrationStatus;
            this.changedFields = changedFields.add("migrationStatus");
            return this;
        }

        public Builder migrationValidationDetails(List<KeyValuePair> migrationValidationDetails) {
            this.migrationValidationDetails = migrationValidationDetails;
            this.changedFields = changedFields.add("migrationValidationDetails");
            return this;
        }

        public Builder migrationValidationDetails(KeyValuePair... migrationValidationDetails) {
            return migrationValidationDetails(Arrays.asList(migrationValidationDetails));
        }

        public Builder migrationValidationDetailsNextLink(String migrationValidationDetailsNextLink) {
            this.migrationValidationDetailsNextLink = migrationValidationDetailsNextLink;
            this.changedFields = changedFields.add("migrationValidationDetails");
            return this;
        }

        public Builder relyingPartyId(String relyingPartyId) {
            this.relyingPartyId = relyingPartyId;
            this.changedFields = changedFields.add("relyingPartyId");
            return this;
        }

        public Builder relyingPartyName(String relyingPartyName) {
            this.relyingPartyName = relyingPartyName;
            this.changedFields = changedFields.add("relyingPartyName");
            return this;
        }

        public Builder replyUrls(List<String> replyUrls) {
            this.replyUrls = replyUrls;
            this.changedFields = changedFields.add("replyUrls");
            return this;
        }

        public Builder replyUrls(String... replyUrls) {
            return replyUrls(Arrays.asList(replyUrls));
        }

        public Builder replyUrlsNextLink(String replyUrlsNextLink) {
            this.replyUrlsNextLink = replyUrlsNextLink;
            this.changedFields = changedFields.add("replyUrls");
            return this;
        }

        public Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            this.changedFields = changedFields.add("serviceId");
            return this;
        }

        public Builder signInSuccessRate(Double signInSuccessRate) {
            this.signInSuccessRate = signInSuccessRate;
            this.changedFields = changedFields.add("signInSuccessRate");
            return this;
        }

        public Builder successfulSignInCount(Long successfulSignInCount) {
            this.successfulSignInCount = successfulSignInCount;
            this.changedFields = changedFields.add("successfulSignInCount");
            return this;
        }

        public Builder totalSignInCount(Long totalSignInCount) {
            this.totalSignInCount = totalSignInCount;
            this.changedFields = changedFields.add("totalSignInCount");
            return this;
        }

        public Builder uniqueUserCount(Long uniqueUserCount) {
            this.uniqueUserCount = uniqueUserCount;
            this.changedFields = changedFields.add("uniqueUserCount");
            return this;
        }

        public RelyingPartyDetailedSummary build() {
            RelyingPartyDetailedSummary _x = new RelyingPartyDetailedSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.relyingPartyDetailedSummary";
            _x.id = id;
            _x.failedSignInCount = failedSignInCount;
            _x.migrationStatus = migrationStatus;
            _x.migrationValidationDetails = migrationValidationDetails;
            _x.migrationValidationDetailsNextLink = migrationValidationDetailsNextLink;
            _x.relyingPartyId = relyingPartyId;
            _x.relyingPartyName = relyingPartyName;
            _x.replyUrls = replyUrls;
            _x.replyUrlsNextLink = replyUrlsNextLink;
            _x.serviceId = serviceId;
            _x.signInSuccessRate = signInSuccessRate;
            _x.successfulSignInCount = successfulSignInCount;
            _x.totalSignInCount = totalSignInCount;
            _x.uniqueUserCount = uniqueUserCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="failedSignInCount")
    @JsonIgnore
    public Optional<Long> getFailedSignInCount() {
        return Optional.ofNullable(failedSignInCount);
    }

    public RelyingPartyDetailedSummary withFailedSignInCount(Long failedSignInCount) {
        RelyingPartyDetailedSummary _x = _copy();
        _x.changedFields = changedFields.add("failedSignInCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relyingPartyDetailedSummary");
        _x.failedSignInCount = failedSignInCount;
        return _x;
    }

    @Property(name="migrationStatus")
    @JsonIgnore
    public Optional<MigrationStatus> getMigrationStatus() {
        return Optional.ofNullable(migrationStatus);
    }

    public RelyingPartyDetailedSummary withMigrationStatus(MigrationStatus migrationStatus) {
        RelyingPartyDetailedSummary _x = _copy();
        _x.changedFields = changedFields.add("migrationStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relyingPartyDetailedSummary");
        _x.migrationStatus = migrationStatus;
        return _x;
    }

    @Property(name="migrationValidationDetails")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getMigrationValidationDetails() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.migrationValidationDetails, Optional.ofNullable(migrationValidationDetailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public RelyingPartyDetailedSummary withMigrationValidationDetails(List<KeyValuePair> migrationValidationDetails) {
        RelyingPartyDetailedSummary _x = _copy();
        _x.changedFields = changedFields.add("migrationValidationDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relyingPartyDetailedSummary");
        _x.migrationValidationDetails = migrationValidationDetails;
        return _x;
    }

    @Property(name="migrationValidationDetails")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getMigrationValidationDetails(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.migrationValidationDetails, Optional.ofNullable(migrationValidationDetailsNextLink), Collections.emptyList(), options);
    }

    @Property(name="relyingPartyId")
    @JsonIgnore
    public Optional<String> getRelyingPartyId() {
        return Optional.ofNullable(relyingPartyId);
    }

    public RelyingPartyDetailedSummary withRelyingPartyId(String relyingPartyId) {
        RelyingPartyDetailedSummary _x = _copy();
        _x.changedFields = changedFields.add("relyingPartyId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relyingPartyDetailedSummary");
        _x.relyingPartyId = relyingPartyId;
        return _x;
    }

    @Property(name="relyingPartyName")
    @JsonIgnore
    public Optional<String> getRelyingPartyName() {
        return Optional.ofNullable(relyingPartyName);
    }

    public RelyingPartyDetailedSummary withRelyingPartyName(String relyingPartyName) {
        RelyingPartyDetailedSummary _x = _copy();
        _x.changedFields = changedFields.add("relyingPartyName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relyingPartyDetailedSummary");
        _x.relyingPartyName = relyingPartyName;
        return _x;
    }

    @Property(name="replyUrls")
    @JsonIgnore
    public CollectionPage<String> getReplyUrls() {
        return new CollectionPage<String>(contextPath, String.class, this.replyUrls, Optional.ofNullable(replyUrlsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public RelyingPartyDetailedSummary withReplyUrls(List<String> replyUrls) {
        RelyingPartyDetailedSummary _x = _copy();
        _x.changedFields = changedFields.add("replyUrls");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relyingPartyDetailedSummary");
        _x.replyUrls = replyUrls;
        return _x;
    }

    @Property(name="replyUrls")
    @JsonIgnore
    public CollectionPage<String> getReplyUrls(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.replyUrls, Optional.ofNullable(replyUrlsNextLink), Collections.emptyList(), options);
    }

    @Property(name="serviceId")
    @JsonIgnore
    public Optional<String> getServiceId() {
        return Optional.ofNullable(serviceId);
    }

    public RelyingPartyDetailedSummary withServiceId(String serviceId) {
        RelyingPartyDetailedSummary _x = _copy();
        _x.changedFields = changedFields.add("serviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relyingPartyDetailedSummary");
        _x.serviceId = serviceId;
        return _x;
    }

    @Property(name="signInSuccessRate")
    @JsonIgnore
    public Optional<Double> getSignInSuccessRate() {
        return Optional.ofNullable(signInSuccessRate);
    }

    public RelyingPartyDetailedSummary withSignInSuccessRate(Double signInSuccessRate) {
        RelyingPartyDetailedSummary _x = _copy();
        _x.changedFields = changedFields.add("signInSuccessRate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relyingPartyDetailedSummary");
        _x.signInSuccessRate = signInSuccessRate;
        return _x;
    }

    @Property(name="successfulSignInCount")
    @JsonIgnore
    public Optional<Long> getSuccessfulSignInCount() {
        return Optional.ofNullable(successfulSignInCount);
    }

    public RelyingPartyDetailedSummary withSuccessfulSignInCount(Long successfulSignInCount) {
        RelyingPartyDetailedSummary _x = _copy();
        _x.changedFields = changedFields.add("successfulSignInCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relyingPartyDetailedSummary");
        _x.successfulSignInCount = successfulSignInCount;
        return _x;
    }

    @Property(name="totalSignInCount")
    @JsonIgnore
    public Optional<Long> getTotalSignInCount() {
        return Optional.ofNullable(totalSignInCount);
    }

    public RelyingPartyDetailedSummary withTotalSignInCount(Long totalSignInCount) {
        RelyingPartyDetailedSummary _x = _copy();
        _x.changedFields = changedFields.add("totalSignInCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relyingPartyDetailedSummary");
        _x.totalSignInCount = totalSignInCount;
        return _x;
    }

    @Property(name="uniqueUserCount")
    @JsonIgnore
    public Optional<Long> getUniqueUserCount() {
        return Optional.ofNullable(uniqueUserCount);
    }

    public RelyingPartyDetailedSummary withUniqueUserCount(Long uniqueUserCount) {
        RelyingPartyDetailedSummary _x = _copy();
        _x.changedFields = changedFields.add("uniqueUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relyingPartyDetailedSummary");
        _x.uniqueUserCount = uniqueUserCount;
        return _x;
    }

    public RelyingPartyDetailedSummary withUnmappedField(String name, Object value) {
        RelyingPartyDetailedSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RelyingPartyDetailedSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RelyingPartyDetailedSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RelyingPartyDetailedSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RelyingPartyDetailedSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RelyingPartyDetailedSummary _copy() {
        RelyingPartyDetailedSummary _x = new RelyingPartyDetailedSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.failedSignInCount = failedSignInCount;
        _x.migrationStatus = migrationStatus;
        _x.migrationValidationDetails = migrationValidationDetails;
        _x.relyingPartyId = relyingPartyId;
        _x.relyingPartyName = relyingPartyName;
        _x.replyUrls = replyUrls;
        _x.serviceId = serviceId;
        _x.signInSuccessRate = signInSuccessRate;
        _x.successfulSignInCount = successfulSignInCount;
        _x.totalSignInCount = totalSignInCount;
        _x.uniqueUserCount = uniqueUserCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RelyingPartyDetailedSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("failedSignInCount=");
        b.append(this.failedSignInCount);
        b.append(", ");
        b.append("migrationStatus=");
        b.append(this.migrationStatus);
        b.append(", ");
        b.append("migrationValidationDetails=");
        b.append(this.migrationValidationDetails);
        b.append(", ");
        b.append("relyingPartyId=");
        b.append(this.relyingPartyId);
        b.append(", ");
        b.append("relyingPartyName=");
        b.append(this.relyingPartyName);
        b.append(", ");
        b.append("replyUrls=");
        b.append(this.replyUrls);
        b.append(", ");
        b.append("serviceId=");
        b.append(this.serviceId);
        b.append(", ");
        b.append("signInSuccessRate=");
        b.append(this.signInSuccessRate);
        b.append(", ");
        b.append("successfulSignInCount=");
        b.append(this.successfulSignInCount);
        b.append(", ");
        b.append("totalSignInCount=");
        b.append(this.totalSignInCount);
        b.append(", ");
        b.append("uniqueUserCount=");
        b.append(this.uniqueUserCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
