package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ReferenceAttachmentPermission;
import odata.msgraph.client.beta.enums.ReferenceAttachmentProvider;

@JsonPropertyOrder({
    "@odata.type", 
    "isFolder", 
    "permission", 
    "previewUrl", 
    "providerType", 
    "sourceUrl", 
    "thumbnailUrl"})
@JsonInclude(Include.NON_NULL)
public class ReferenceAttachment extends Attachment implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.referenceAttachment";
    }

    @JsonProperty("isFolder")
    protected Boolean isFolder;

    @JsonProperty("permission")
    protected ReferenceAttachmentPermission permission;

    @JsonProperty("previewUrl")
    protected String previewUrl;

    @JsonProperty("providerType")
    protected ReferenceAttachmentProvider providerType;

    @JsonProperty("sourceUrl")
    protected String sourceUrl;

    @JsonProperty("thumbnailUrl")
    protected String thumbnailUrl;

    protected ReferenceAttachment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderReferenceAttachment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String contentType;
        private Boolean isInline;
        private OffsetDateTime lastModifiedDateTime;
        private String name;
        private Integer size;
        private Boolean isFolder;
        private ReferenceAttachmentPermission permission;
        private String previewUrl;
        private ReferenceAttachmentProvider providerType;
        private String sourceUrl;
        private String thumbnailUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            this.changedFields = changedFields.add("contentType");
            return this;
        }

        public Builder isInline(Boolean isInline) {
            this.isInline = isInline;
            this.changedFields = changedFields.add("isInline");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder size(Integer size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public Builder isFolder(Boolean isFolder) {
            this.isFolder = isFolder;
            this.changedFields = changedFields.add("isFolder");
            return this;
        }

        public Builder permission(ReferenceAttachmentPermission permission) {
            this.permission = permission;
            this.changedFields = changedFields.add("permission");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.IsURL</b>
         * <p>
         * true
         * 
         * @param previewUrl
         *            value of {@code previewUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder previewUrl(String previewUrl) {
            this.previewUrl = previewUrl;
            this.changedFields = changedFields.add("previewUrl");
            return this;
        }

        public Builder providerType(ReferenceAttachmentProvider providerType) {
            this.providerType = providerType;
            this.changedFields = changedFields.add("providerType");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.IsURL</b>
         * <p>
         * true
         * 
         * @param sourceUrl
         *            value of {@code sourceUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            this.changedFields = changedFields.add("sourceUrl");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.IsURL</b>
         * <p>
         * true
         * 
         * @param thumbnailUrl
         *            value of {@code thumbnailUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder thumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            this.changedFields = changedFields.add("thumbnailUrl");
            return this;
        }

        public ReferenceAttachment build() {
            ReferenceAttachment _x = new ReferenceAttachment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.referenceAttachment";
            _x.id = id;
            _x.contentType = contentType;
            _x.isInline = isInline;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.name = name;
            _x.size = size;
            _x.isFolder = isFolder;
            _x.permission = permission;
            _x.previewUrl = previewUrl;
            _x.providerType = providerType;
            _x.sourceUrl = sourceUrl;
            _x.thumbnailUrl = thumbnailUrl;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="isFolder")
    @JsonIgnore
    public Optional<Boolean> getIsFolder() {
        return Optional.ofNullable(isFolder);
    }

    public ReferenceAttachment withIsFolder(Boolean isFolder) {
        ReferenceAttachment _x = _copy();
        _x.changedFields = changedFields.add("isFolder");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.referenceAttachment");
        _x.isFolder = isFolder;
        return _x;
    }

    @Property(name="permission")
    @JsonIgnore
    public Optional<ReferenceAttachmentPermission> getPermission() {
        return Optional.ofNullable(permission);
    }

    public ReferenceAttachment withPermission(ReferenceAttachmentPermission permission) {
        ReferenceAttachment _x = _copy();
        _x.changedFields = changedFields.add("permission");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.referenceAttachment");
        _x.permission = permission;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.IsURL</b>
     * <p>
     * true
     * 
     * @return property previewUrl
     */
    @Property(name="previewUrl")
    @JsonIgnore
    public Optional<String> getPreviewUrl() {
        return Optional.ofNullable(previewUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code previewUrl} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.IsURL</b>
     * <p>
     * true
     * 
     * @param previewUrl
     *            new value of {@code previewUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code previewUrl} field changed
     */
    public ReferenceAttachment withPreviewUrl(String previewUrl) {
        ReferenceAttachment _x = _copy();
        _x.changedFields = changedFields.add("previewUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.referenceAttachment");
        _x.previewUrl = previewUrl;
        return _x;
    }

    @Property(name="providerType")
    @JsonIgnore
    public Optional<ReferenceAttachmentProvider> getProviderType() {
        return Optional.ofNullable(providerType);
    }

    public ReferenceAttachment withProviderType(ReferenceAttachmentProvider providerType) {
        ReferenceAttachment _x = _copy();
        _x.changedFields = changedFields.add("providerType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.referenceAttachment");
        _x.providerType = providerType;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.IsURL</b>
     * <p>
     * true
     * 
     * @return property sourceUrl
     */
    @Property(name="sourceUrl")
    @JsonIgnore
    public Optional<String> getSourceUrl() {
        return Optional.ofNullable(sourceUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code sourceUrl} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.IsURL</b>
     * <p>
     * true
     * 
     * @param sourceUrl
     *            new value of {@code sourceUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sourceUrl} field changed
     */
    public ReferenceAttachment withSourceUrl(String sourceUrl) {
        ReferenceAttachment _x = _copy();
        _x.changedFields = changedFields.add("sourceUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.referenceAttachment");
        _x.sourceUrl = sourceUrl;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.IsURL</b>
     * <p>
     * true
     * 
     * @return property thumbnailUrl
     */
    @Property(name="thumbnailUrl")
    @JsonIgnore
    public Optional<String> getThumbnailUrl() {
        return Optional.ofNullable(thumbnailUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code thumbnailUrl}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.IsURL</b>
     * <p>
     * true
     * 
     * @param thumbnailUrl
     *            new value of {@code thumbnailUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code thumbnailUrl} field changed
     */
    public ReferenceAttachment withThumbnailUrl(String thumbnailUrl) {
        ReferenceAttachment _x = _copy();
        _x.changedFields = changedFields.add("thumbnailUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.referenceAttachment");
        _x.thumbnailUrl = thumbnailUrl;
        return _x;
    }

    public ReferenceAttachment withUnmappedField(String name, Object value) {
        ReferenceAttachment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ReferenceAttachment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ReferenceAttachment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ReferenceAttachment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ReferenceAttachment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ReferenceAttachment _copy() {
        ReferenceAttachment _x = new ReferenceAttachment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.contentType = contentType;
        _x.isInline = isInline;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.name = name;
        _x.size = size;
        _x.isFolder = isFolder;
        _x.permission = permission;
        _x.previewUrl = previewUrl;
        _x.providerType = providerType;
        _x.sourceUrl = sourceUrl;
        _x.thumbnailUrl = thumbnailUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ReferenceAttachment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("contentType=");
        b.append(this.contentType);
        b.append(", ");
        b.append("isInline=");
        b.append(this.isInline);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("isFolder=");
        b.append(this.isFolder);
        b.append(", ");
        b.append("permission=");
        b.append(this.permission);
        b.append(", ");
        b.append("previewUrl=");
        b.append(this.previewUrl);
        b.append(", ");
        b.append("providerType=");
        b.append(this.providerType);
        b.append(", ");
        b.append("sourceUrl=");
        b.append(this.sourceUrl);
        b.append(", ");
        b.append("thumbnailUrl=");
        b.append(this.thumbnailUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
