package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ApprovalCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRbacResourceNamespaceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleAssignmentScheduleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleAssignmentScheduleInstanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleAssignmentScheduleRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleEligibilityScheduleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleEligibilityScheduleInstanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleEligibilityScheduleRequestCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "resourceNamespaces", 
    "roleAssignments", 
    "roleDefinitions", 
    "transitiveRoleAssignments", 
    "roleAssignmentApprovals", 
    "roleAssignmentScheduleInstances", 
    "roleAssignmentScheduleRequests", 
    "roleAssignmentSchedules", 
    "roleEligibilityScheduleInstances", 
    "roleEligibilityScheduleRequests", 
    "roleEligibilitySchedules"})
@JsonInclude(Include.NON_NULL)
public class RbacApplication extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.rbacApplication";
    }

    @JsonProperty("resourceNamespaces")
    protected List<UnifiedRbacResourceNamespace> resourceNamespaces;

    @JsonProperty("roleAssignments")
    protected List<UnifiedRoleAssignment> roleAssignments;

    @JsonProperty("roleDefinitions")
    protected List<UnifiedRoleDefinition> roleDefinitions;

    @JsonProperty("transitiveRoleAssignments")
    protected List<UnifiedRoleAssignment> transitiveRoleAssignments;

    @JsonProperty("roleAssignmentApprovals")
    protected List<Approval> roleAssignmentApprovals;

    @JsonProperty("roleAssignmentScheduleInstances")
    protected List<UnifiedRoleAssignmentScheduleInstance> roleAssignmentScheduleInstances;

    @JsonProperty("roleAssignmentScheduleRequests")
    protected List<UnifiedRoleAssignmentScheduleRequest> roleAssignmentScheduleRequests;

    @JsonProperty("roleAssignmentSchedules")
    protected List<UnifiedRoleAssignmentSchedule> roleAssignmentSchedules;

    @JsonProperty("roleEligibilityScheduleInstances")
    protected List<UnifiedRoleEligibilityScheduleInstance> roleEligibilityScheduleInstances;

    @JsonProperty("roleEligibilityScheduleRequests")
    protected List<UnifiedRoleEligibilityScheduleRequest> roleEligibilityScheduleRequests;

    @JsonProperty("roleEligibilitySchedules")
    protected List<UnifiedRoleEligibilitySchedule> roleEligibilitySchedules;

    protected RbacApplication() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRbacApplication() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<UnifiedRbacResourceNamespace> resourceNamespaces;
        private List<UnifiedRoleAssignment> roleAssignments;
        private List<UnifiedRoleDefinition> roleDefinitions;
        private List<UnifiedRoleAssignment> transitiveRoleAssignments;
        private List<Approval> roleAssignmentApprovals;
        private List<UnifiedRoleAssignmentScheduleInstance> roleAssignmentScheduleInstances;
        private List<UnifiedRoleAssignmentScheduleRequest> roleAssignmentScheduleRequests;
        private List<UnifiedRoleAssignmentSchedule> roleAssignmentSchedules;
        private List<UnifiedRoleEligibilityScheduleInstance> roleEligibilityScheduleInstances;
        private List<UnifiedRoleEligibilityScheduleRequest> roleEligibilityScheduleRequests;
        private List<UnifiedRoleEligibilitySchedule> roleEligibilitySchedules;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder resourceNamespaces(List<UnifiedRbacResourceNamespace> resourceNamespaces) {
            this.resourceNamespaces = resourceNamespaces;
            this.changedFields = changedFields.add("resourceNamespaces");
            return this;
        }

        public Builder resourceNamespaces(UnifiedRbacResourceNamespace... resourceNamespaces) {
            return resourceNamespaces(Arrays.asList(resourceNamespaces));
        }

        public Builder roleAssignments(List<UnifiedRoleAssignment> roleAssignments) {
            this.roleAssignments = roleAssignments;
            this.changedFields = changedFields.add("roleAssignments");
            return this;
        }

        public Builder roleAssignments(UnifiedRoleAssignment... roleAssignments) {
            return roleAssignments(Arrays.asList(roleAssignments));
        }

        public Builder roleDefinitions(List<UnifiedRoleDefinition> roleDefinitions) {
            this.roleDefinitions = roleDefinitions;
            this.changedFields = changedFields.add("roleDefinitions");
            return this;
        }

        public Builder roleDefinitions(UnifiedRoleDefinition... roleDefinitions) {
            return roleDefinitions(Arrays.asList(roleDefinitions));
        }

        public Builder transitiveRoleAssignments(List<UnifiedRoleAssignment> transitiveRoleAssignments) {
            this.transitiveRoleAssignments = transitiveRoleAssignments;
            this.changedFields = changedFields.add("transitiveRoleAssignments");
            return this;
        }

        public Builder transitiveRoleAssignments(UnifiedRoleAssignment... transitiveRoleAssignments) {
            return transitiveRoleAssignments(Arrays.asList(transitiveRoleAssignments));
        }

        public Builder roleAssignmentApprovals(List<Approval> roleAssignmentApprovals) {
            this.roleAssignmentApprovals = roleAssignmentApprovals;
            this.changedFields = changedFields.add("roleAssignmentApprovals");
            return this;
        }

        public Builder roleAssignmentApprovals(Approval... roleAssignmentApprovals) {
            return roleAssignmentApprovals(Arrays.asList(roleAssignmentApprovals));
        }

        public Builder roleAssignmentScheduleInstances(List<UnifiedRoleAssignmentScheduleInstance> roleAssignmentScheduleInstances) {
            this.roleAssignmentScheduleInstances = roleAssignmentScheduleInstances;
            this.changedFields = changedFields.add("roleAssignmentScheduleInstances");
            return this;
        }

        public Builder roleAssignmentScheduleInstances(UnifiedRoleAssignmentScheduleInstance... roleAssignmentScheduleInstances) {
            return roleAssignmentScheduleInstances(Arrays.asList(roleAssignmentScheduleInstances));
        }

        public Builder roleAssignmentScheduleRequests(List<UnifiedRoleAssignmentScheduleRequest> roleAssignmentScheduleRequests) {
            this.roleAssignmentScheduleRequests = roleAssignmentScheduleRequests;
            this.changedFields = changedFields.add("roleAssignmentScheduleRequests");
            return this;
        }

        public Builder roleAssignmentScheduleRequests(UnifiedRoleAssignmentScheduleRequest... roleAssignmentScheduleRequests) {
            return roleAssignmentScheduleRequests(Arrays.asList(roleAssignmentScheduleRequests));
        }

        public Builder roleAssignmentSchedules(List<UnifiedRoleAssignmentSchedule> roleAssignmentSchedules) {
            this.roleAssignmentSchedules = roleAssignmentSchedules;
            this.changedFields = changedFields.add("roleAssignmentSchedules");
            return this;
        }

        public Builder roleAssignmentSchedules(UnifiedRoleAssignmentSchedule... roleAssignmentSchedules) {
            return roleAssignmentSchedules(Arrays.asList(roleAssignmentSchedules));
        }

        public Builder roleEligibilityScheduleInstances(List<UnifiedRoleEligibilityScheduleInstance> roleEligibilityScheduleInstances) {
            this.roleEligibilityScheduleInstances = roleEligibilityScheduleInstances;
            this.changedFields = changedFields.add("roleEligibilityScheduleInstances");
            return this;
        }

        public Builder roleEligibilityScheduleInstances(UnifiedRoleEligibilityScheduleInstance... roleEligibilityScheduleInstances) {
            return roleEligibilityScheduleInstances(Arrays.asList(roleEligibilityScheduleInstances));
        }

        public Builder roleEligibilityScheduleRequests(List<UnifiedRoleEligibilityScheduleRequest> roleEligibilityScheduleRequests) {
            this.roleEligibilityScheduleRequests = roleEligibilityScheduleRequests;
            this.changedFields = changedFields.add("roleEligibilityScheduleRequests");
            return this;
        }

        public Builder roleEligibilityScheduleRequests(UnifiedRoleEligibilityScheduleRequest... roleEligibilityScheduleRequests) {
            return roleEligibilityScheduleRequests(Arrays.asList(roleEligibilityScheduleRequests));
        }

        public Builder roleEligibilitySchedules(List<UnifiedRoleEligibilitySchedule> roleEligibilitySchedules) {
            this.roleEligibilitySchedules = roleEligibilitySchedules;
            this.changedFields = changedFields.add("roleEligibilitySchedules");
            return this;
        }

        public Builder roleEligibilitySchedules(UnifiedRoleEligibilitySchedule... roleEligibilitySchedules) {
            return roleEligibilitySchedules(Arrays.asList(roleEligibilitySchedules));
        }

        public RbacApplication build() {
            RbacApplication _x = new RbacApplication();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.rbacApplication";
            _x.id = id;
            _x.resourceNamespaces = resourceNamespaces;
            _x.roleAssignments = roleAssignments;
            _x.roleDefinitions = roleDefinitions;
            _x.transitiveRoleAssignments = transitiveRoleAssignments;
            _x.roleAssignmentApprovals = roleAssignmentApprovals;
            _x.roleAssignmentScheduleInstances = roleAssignmentScheduleInstances;
            _x.roleAssignmentScheduleRequests = roleAssignmentScheduleRequests;
            _x.roleAssignmentSchedules = roleAssignmentSchedules;
            _x.roleEligibilityScheduleInstances = roleEligibilityScheduleInstances;
            _x.roleEligibilityScheduleRequests = roleEligibilityScheduleRequests;
            _x.roleEligibilitySchedules = roleEligibilitySchedules;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public RbacApplication withUnmappedField(String name, Object value) {
        RbacApplication _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="resourceNamespaces")
    @JsonIgnore
    public UnifiedRbacResourceNamespaceCollectionRequest getResourceNamespaces() {
        return new UnifiedRbacResourceNamespaceCollectionRequest(
                        contextPath.addSegment("resourceNamespaces"), Optional.ofNullable(resourceNamespaces));
    }

    @NavigationProperty(name="roleAssignments")
    @JsonIgnore
    public UnifiedRoleAssignmentCollectionRequest getRoleAssignments() {
        return new UnifiedRoleAssignmentCollectionRequest(
                        contextPath.addSegment("roleAssignments"), Optional.ofNullable(roleAssignments));
    }

    @NavigationProperty(name="roleDefinitions")
    @JsonIgnore
    public UnifiedRoleDefinitionCollectionRequest getRoleDefinitions() {
        return new UnifiedRoleDefinitionCollectionRequest(
                        contextPath.addSegment("roleDefinitions"), Optional.ofNullable(roleDefinitions));
    }

    @NavigationProperty(name="transitiveRoleAssignments")
    @JsonIgnore
    public UnifiedRoleAssignmentCollectionRequest getTransitiveRoleAssignments() {
        return new UnifiedRoleAssignmentCollectionRequest(
                        contextPath.addSegment("transitiveRoleAssignments"), Optional.ofNullable(transitiveRoleAssignments));
    }

    @NavigationProperty(name="roleAssignmentApprovals")
    @JsonIgnore
    public ApprovalCollectionRequest getRoleAssignmentApprovals() {
        return new ApprovalCollectionRequest(
                        contextPath.addSegment("roleAssignmentApprovals"), Optional.ofNullable(roleAssignmentApprovals));
    }

    @NavigationProperty(name="roleAssignmentScheduleInstances")
    @JsonIgnore
    public UnifiedRoleAssignmentScheduleInstanceCollectionRequest getRoleAssignmentScheduleInstances() {
        return new UnifiedRoleAssignmentScheduleInstanceCollectionRequest(
                        contextPath.addSegment("roleAssignmentScheduleInstances"), Optional.ofNullable(roleAssignmentScheduleInstances));
    }

    @NavigationProperty(name="roleAssignmentScheduleRequests")
    @JsonIgnore
    public UnifiedRoleAssignmentScheduleRequestCollectionRequest getRoleAssignmentScheduleRequests() {
        return new UnifiedRoleAssignmentScheduleRequestCollectionRequest(
                        contextPath.addSegment("roleAssignmentScheduleRequests"), Optional.ofNullable(roleAssignmentScheduleRequests));
    }

    @NavigationProperty(name="roleAssignmentSchedules")
    @JsonIgnore
    public UnifiedRoleAssignmentScheduleCollectionRequest getRoleAssignmentSchedules() {
        return new UnifiedRoleAssignmentScheduleCollectionRequest(
                        contextPath.addSegment("roleAssignmentSchedules"), Optional.ofNullable(roleAssignmentSchedules));
    }

    @NavigationProperty(name="roleEligibilityScheduleInstances")
    @JsonIgnore
    public UnifiedRoleEligibilityScheduleInstanceCollectionRequest getRoleEligibilityScheduleInstances() {
        return new UnifiedRoleEligibilityScheduleInstanceCollectionRequest(
                        contextPath.addSegment("roleEligibilityScheduleInstances"), Optional.ofNullable(roleEligibilityScheduleInstances));
    }

    @NavigationProperty(name="roleEligibilityScheduleRequests")
    @JsonIgnore
    public UnifiedRoleEligibilityScheduleRequestCollectionRequest getRoleEligibilityScheduleRequests() {
        return new UnifiedRoleEligibilityScheduleRequestCollectionRequest(
                        contextPath.addSegment("roleEligibilityScheduleRequests"), Optional.ofNullable(roleEligibilityScheduleRequests));
    }

    @NavigationProperty(name="roleEligibilitySchedules")
    @JsonIgnore
    public UnifiedRoleEligibilityScheduleCollectionRequest getRoleEligibilitySchedules() {
        return new UnifiedRoleEligibilityScheduleCollectionRequest(
                        contextPath.addSegment("roleEligibilitySchedules"), Optional.ofNullable(roleEligibilitySchedules));
    }

    public RbacApplication withResourceNamespaces(List<UnifiedRbacResourceNamespace> resourceNamespaces) {
        RbacApplication _x = _copy();
        _x.changedFields = changedFields.add("resourceNamespaces");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rbacApplication");
        _x.resourceNamespaces = resourceNamespaces;
        return _x;
    }

    public RbacApplication withRoleAssignments(List<UnifiedRoleAssignment> roleAssignments) {
        RbacApplication _x = _copy();
        _x.changedFields = changedFields.add("roleAssignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rbacApplication");
        _x.roleAssignments = roleAssignments;
        return _x;
    }

    public RbacApplication withRoleDefinitions(List<UnifiedRoleDefinition> roleDefinitions) {
        RbacApplication _x = _copy();
        _x.changedFields = changedFields.add("roleDefinitions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rbacApplication");
        _x.roleDefinitions = roleDefinitions;
        return _x;
    }

    public RbacApplication withTransitiveRoleAssignments(List<UnifiedRoleAssignment> transitiveRoleAssignments) {
        RbacApplication _x = _copy();
        _x.changedFields = changedFields.add("transitiveRoleAssignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rbacApplication");
        _x.transitiveRoleAssignments = transitiveRoleAssignments;
        return _x;
    }

    public RbacApplication withRoleAssignmentApprovals(List<Approval> roleAssignmentApprovals) {
        RbacApplication _x = _copy();
        _x.changedFields = changedFields.add("roleAssignmentApprovals");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rbacApplication");
        _x.roleAssignmentApprovals = roleAssignmentApprovals;
        return _x;
    }

    public RbacApplication withRoleAssignmentScheduleInstances(List<UnifiedRoleAssignmentScheduleInstance> roleAssignmentScheduleInstances) {
        RbacApplication _x = _copy();
        _x.changedFields = changedFields.add("roleAssignmentScheduleInstances");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rbacApplication");
        _x.roleAssignmentScheduleInstances = roleAssignmentScheduleInstances;
        return _x;
    }

    public RbacApplication withRoleAssignmentScheduleRequests(List<UnifiedRoleAssignmentScheduleRequest> roleAssignmentScheduleRequests) {
        RbacApplication _x = _copy();
        _x.changedFields = changedFields.add("roleAssignmentScheduleRequests");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rbacApplication");
        _x.roleAssignmentScheduleRequests = roleAssignmentScheduleRequests;
        return _x;
    }

    public RbacApplication withRoleAssignmentSchedules(List<UnifiedRoleAssignmentSchedule> roleAssignmentSchedules) {
        RbacApplication _x = _copy();
        _x.changedFields = changedFields.add("roleAssignmentSchedules");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rbacApplication");
        _x.roleAssignmentSchedules = roleAssignmentSchedules;
        return _x;
    }

    public RbacApplication withRoleEligibilityScheduleInstances(List<UnifiedRoleEligibilityScheduleInstance> roleEligibilityScheduleInstances) {
        RbacApplication _x = _copy();
        _x.changedFields = changedFields.add("roleEligibilityScheduleInstances");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rbacApplication");
        _x.roleEligibilityScheduleInstances = roleEligibilityScheduleInstances;
        return _x;
    }

    public RbacApplication withRoleEligibilityScheduleRequests(List<UnifiedRoleEligibilityScheduleRequest> roleEligibilityScheduleRequests) {
        RbacApplication _x = _copy();
        _x.changedFields = changedFields.add("roleEligibilityScheduleRequests");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rbacApplication");
        _x.roleEligibilityScheduleRequests = roleEligibilityScheduleRequests;
        return _x;
    }

    public RbacApplication withRoleEligibilitySchedules(List<UnifiedRoleEligibilitySchedule> roleEligibilitySchedules) {
        RbacApplication _x = _copy();
        _x.changedFields = changedFields.add("roleEligibilitySchedules");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rbacApplication");
        _x.roleEligibilitySchedules = roleEligibilitySchedules;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RbacApplication patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RbacApplication _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RbacApplication put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RbacApplication _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RbacApplication _copy() {
        RbacApplication _x = new RbacApplication();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.resourceNamespaces = resourceNamespaces;
        _x.roleAssignments = roleAssignments;
        _x.roleDefinitions = roleDefinitions;
        _x.transitiveRoleAssignments = transitiveRoleAssignments;
        _x.roleAssignmentApprovals = roleAssignmentApprovals;
        _x.roleAssignmentScheduleInstances = roleAssignmentScheduleInstances;
        _x.roleAssignmentScheduleRequests = roleAssignmentScheduleRequests;
        _x.roleAssignmentSchedules = roleAssignmentSchedules;
        _x.roleEligibilityScheduleInstances = roleEligibilityScheduleInstances;
        _x.roleEligibilityScheduleRequests = roleEligibilityScheduleRequests;
        _x.roleEligibilitySchedules = roleEligibilitySchedules;
        return _x;
    }

    @Function(name = "roleScheduleInstances")
    @JsonIgnore
    public CollectionPageNonEntityRequest<UnifiedRoleScheduleInstanceBase> roleScheduleInstances(String directoryScopeId, String appScopeId, String principalId, String roleDefinitionId) {
        Preconditions.checkNotNull(directoryScopeId, "directoryScopeId cannot be null");
        Preconditions.checkNotNull(appScopeId, "appScopeId cannot be null");
        Preconditions.checkNotNull(principalId, "principalId cannot be null");
        Preconditions.checkNotNull(roleDefinitionId, "roleDefinitionId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("directoryScopeId", "Edm.String", Checks.checkIsAscii(directoryScopeId))
            .put("appScopeId", "Edm.String", Checks.checkIsAscii(appScopeId))
            .put("principalId", "Edm.String", Checks.checkIsAscii(principalId))
            .put("roleDefinitionId", "Edm.String", Checks.checkIsAscii(roleDefinitionId))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.roleScheduleInstances"), UnifiedRoleScheduleInstanceBase.class, _parameters);
    }

    @Function(name = "roleSchedules")
    @JsonIgnore
    public CollectionPageNonEntityRequest<UnifiedRoleScheduleBase> roleSchedules(String directoryScopeId, String appScopeId, String principalId, String roleDefinitionId) {
        Preconditions.checkNotNull(directoryScopeId, "directoryScopeId cannot be null");
        Preconditions.checkNotNull(appScopeId, "appScopeId cannot be null");
        Preconditions.checkNotNull(principalId, "principalId cannot be null");
        Preconditions.checkNotNull(roleDefinitionId, "roleDefinitionId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("directoryScopeId", "Edm.String", Checks.checkIsAscii(directoryScopeId))
            .put("appScopeId", "Edm.String", Checks.checkIsAscii(appScopeId))
            .put("principalId", "Edm.String", Checks.checkIsAscii(principalId))
            .put("roleDefinitionId", "Edm.String", Checks.checkIsAscii(roleDefinitionId))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.roleSchedules"), UnifiedRoleScheduleBase.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RbacApplication[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("resourceNamespaces=");
        b.append(this.resourceNamespaces);
        b.append(", ");
        b.append("roleAssignments=");
        b.append(this.roleAssignments);
        b.append(", ");
        b.append("roleDefinitions=");
        b.append(this.roleDefinitions);
        b.append(", ");
        b.append("transitiveRoleAssignments=");
        b.append(this.transitiveRoleAssignments);
        b.append(", ");
        b.append("roleAssignmentApprovals=");
        b.append(this.roleAssignmentApprovals);
        b.append(", ");
        b.append("roleAssignmentScheduleInstances=");
        b.append(this.roleAssignmentScheduleInstances);
        b.append(", ");
        b.append("roleAssignmentScheduleRequests=");
        b.append(this.roleAssignmentScheduleRequests);
        b.append(", ");
        b.append("roleAssignmentSchedules=");
        b.append(this.roleAssignmentSchedules);
        b.append(", ");
        b.append("roleEligibilityScheduleInstances=");
        b.append(this.roleEligibilityScheduleInstances);
        b.append(", ");
        b.append("roleEligibilityScheduleRequests=");
        b.append(this.roleEligibilityScheduleRequests);
        b.append(", ");
        b.append("roleEligibilitySchedules=");
        b.append(this.roleEligibilitySchedules);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
