package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.entity.request.AccountRequest;
import odata.msgraph.client.beta.entity.request.ItemRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "accountId", 
    "amountExcludingTax", 
    "amountIncludingTax", 
    "description", 
    "discountAmount", 
    "discountAppliedBeforeTax", 
    "discountPercent", 
    "documentId", 
    "expectedReceiptDate", 
    "invoiceDiscountAllocation", 
    "itemId", 
    "lineType", 
    "netAmount", 
    "netAmountIncludingTax", 
    "netTaxAmount", 
    "quantity", 
    "sequence", 
    "taxCode", 
    "taxPercent", 
    "totalTaxAmount", 
    "unitCost", 
    "account", 
    "item"})
@JsonInclude(Include.NON_NULL)
public class PurchaseInvoiceLine extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.purchaseInvoiceLine";
    }

    @JsonProperty("accountId")
    protected UUID accountId;

    @JsonProperty("amountExcludingTax")
    protected BigDecimal amountExcludingTax;

    @JsonProperty("amountIncludingTax")
    protected BigDecimal amountIncludingTax;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("discountAmount")
    protected BigDecimal discountAmount;

    @JsonProperty("discountAppliedBeforeTax")
    protected Boolean discountAppliedBeforeTax;

    @JsonProperty("discountPercent")
    protected BigDecimal discountPercent;

    @JsonProperty("documentId")
    protected UUID documentId;

    @JsonProperty("expectedReceiptDate")
    protected LocalDate expectedReceiptDate;

    @JsonProperty("invoiceDiscountAllocation")
    protected BigDecimal invoiceDiscountAllocation;

    @JsonProperty("itemId")
    protected UUID itemId;

    @JsonProperty("lineType")
    protected String lineType;

    @JsonProperty("netAmount")
    protected BigDecimal netAmount;

    @JsonProperty("netAmountIncludingTax")
    protected BigDecimal netAmountIncludingTax;

    @JsonProperty("netTaxAmount")
    protected BigDecimal netTaxAmount;

    @JsonProperty("quantity")
    protected BigDecimal quantity;

    @JsonProperty("sequence")
    protected Integer sequence;

    @JsonProperty("taxCode")
    protected String taxCode;

    @JsonProperty("taxPercent")
    protected BigDecimal taxPercent;

    @JsonProperty("totalTaxAmount")
    protected BigDecimal totalTaxAmount;

    @JsonProperty("unitCost")
    protected BigDecimal unitCost;

    @JsonProperty("account")
    protected Account account;

    @JsonProperty("item")
    protected Item item;

    protected PurchaseInvoiceLine() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPurchaseInvoiceLine() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private UUID accountId;
        private BigDecimal amountExcludingTax;
        private BigDecimal amountIncludingTax;
        private String description;
        private BigDecimal discountAmount;
        private Boolean discountAppliedBeforeTax;
        private BigDecimal discountPercent;
        private UUID documentId;
        private LocalDate expectedReceiptDate;
        private BigDecimal invoiceDiscountAllocation;
        private UUID itemId;
        private String lineType;
        private BigDecimal netAmount;
        private BigDecimal netAmountIncludingTax;
        private BigDecimal netTaxAmount;
        private BigDecimal quantity;
        private Integer sequence;
        private String taxCode;
        private BigDecimal taxPercent;
        private BigDecimal totalTaxAmount;
        private BigDecimal unitCost;
        private Account account;
        private Item item;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder accountId(UUID accountId) {
            this.accountId = accountId;
            this.changedFields = changedFields.add("accountId");
            return this;
        }

        public Builder amountExcludingTax(BigDecimal amountExcludingTax) {
            this.amountExcludingTax = amountExcludingTax;
            this.changedFields = changedFields.add("amountExcludingTax");
            return this;
        }

        public Builder amountIncludingTax(BigDecimal amountIncludingTax) {
            this.amountIncludingTax = amountIncludingTax;
            this.changedFields = changedFields.add("amountIncludingTax");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder discountAmount(BigDecimal discountAmount) {
            this.discountAmount = discountAmount;
            this.changedFields = changedFields.add("discountAmount");
            return this;
        }

        public Builder discountAppliedBeforeTax(Boolean discountAppliedBeforeTax) {
            this.discountAppliedBeforeTax = discountAppliedBeforeTax;
            this.changedFields = changedFields.add("discountAppliedBeforeTax");
            return this;
        }

        public Builder discountPercent(BigDecimal discountPercent) {
            this.discountPercent = discountPercent;
            this.changedFields = changedFields.add("discountPercent");
            return this;
        }

        public Builder documentId(UUID documentId) {
            this.documentId = documentId;
            this.changedFields = changedFields.add("documentId");
            return this;
        }

        public Builder expectedReceiptDate(LocalDate expectedReceiptDate) {
            this.expectedReceiptDate = expectedReceiptDate;
            this.changedFields = changedFields.add("expectedReceiptDate");
            return this;
        }

        public Builder invoiceDiscountAllocation(BigDecimal invoiceDiscountAllocation) {
            this.invoiceDiscountAllocation = invoiceDiscountAllocation;
            this.changedFields = changedFields.add("invoiceDiscountAllocation");
            return this;
        }

        public Builder itemId(UUID itemId) {
            this.itemId = itemId;
            this.changedFields = changedFields.add("itemId");
            return this;
        }

        public Builder lineType(String lineType) {
            this.lineType = lineType;
            this.changedFields = changedFields.add("lineType");
            return this;
        }

        public Builder netAmount(BigDecimal netAmount) {
            this.netAmount = netAmount;
            this.changedFields = changedFields.add("netAmount");
            return this;
        }

        public Builder netAmountIncludingTax(BigDecimal netAmountIncludingTax) {
            this.netAmountIncludingTax = netAmountIncludingTax;
            this.changedFields = changedFields.add("netAmountIncludingTax");
            return this;
        }

        public Builder netTaxAmount(BigDecimal netTaxAmount) {
            this.netTaxAmount = netTaxAmount;
            this.changedFields = changedFields.add("netTaxAmount");
            return this;
        }

        public Builder quantity(BigDecimal quantity) {
            this.quantity = quantity;
            this.changedFields = changedFields.add("quantity");
            return this;
        }

        public Builder sequence(Integer sequence) {
            this.sequence = sequence;
            this.changedFields = changedFields.add("sequence");
            return this;
        }

        public Builder taxCode(String taxCode) {
            this.taxCode = taxCode;
            this.changedFields = changedFields.add("taxCode");
            return this;
        }

        public Builder taxPercent(BigDecimal taxPercent) {
            this.taxPercent = taxPercent;
            this.changedFields = changedFields.add("taxPercent");
            return this;
        }

        public Builder totalTaxAmount(BigDecimal totalTaxAmount) {
            this.totalTaxAmount = totalTaxAmount;
            this.changedFields = changedFields.add("totalTaxAmount");
            return this;
        }

        public Builder unitCost(BigDecimal unitCost) {
            this.unitCost = unitCost;
            this.changedFields = changedFields.add("unitCost");
            return this;
        }

        public Builder account(Account account) {
            this.account = account;
            this.changedFields = changedFields.add("account");
            return this;
        }

        public Builder item(Item item) {
            this.item = item;
            this.changedFields = changedFields.add("item");
            return this;
        }

        public PurchaseInvoiceLine build() {
            PurchaseInvoiceLine _x = new PurchaseInvoiceLine();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.purchaseInvoiceLine";
            _x.id = id;
            _x.accountId = accountId;
            _x.amountExcludingTax = amountExcludingTax;
            _x.amountIncludingTax = amountIncludingTax;
            _x.description = description;
            _x.discountAmount = discountAmount;
            _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
            _x.discountPercent = discountPercent;
            _x.documentId = documentId;
            _x.expectedReceiptDate = expectedReceiptDate;
            _x.invoiceDiscountAllocation = invoiceDiscountAllocation;
            _x.itemId = itemId;
            _x.lineType = lineType;
            _x.netAmount = netAmount;
            _x.netAmountIncludingTax = netAmountIncludingTax;
            _x.netTaxAmount = netTaxAmount;
            _x.quantity = quantity;
            _x.sequence = sequence;
            _x.taxCode = taxCode;
            _x.taxPercent = taxPercent;
            _x.totalTaxAmount = totalTaxAmount;
            _x.unitCost = unitCost;
            _x.account = account;
            _x.item = item;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="accountId")
    @JsonIgnore
    public Optional<UUID> getAccountId() {
        return Optional.ofNullable(accountId);
    }

    public PurchaseInvoiceLine withAccountId(UUID accountId) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("accountId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.accountId = accountId;
        return _x;
    }

    @Property(name="amountExcludingTax")
    @JsonIgnore
    public Optional<BigDecimal> getAmountExcludingTax() {
        return Optional.ofNullable(amountExcludingTax);
    }

    public PurchaseInvoiceLine withAmountExcludingTax(BigDecimal amountExcludingTax) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("amountExcludingTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.amountExcludingTax = amountExcludingTax;
        return _x;
    }

    @Property(name="amountIncludingTax")
    @JsonIgnore
    public Optional<BigDecimal> getAmountIncludingTax() {
        return Optional.ofNullable(amountIncludingTax);
    }

    public PurchaseInvoiceLine withAmountIncludingTax(BigDecimal amountIncludingTax) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("amountIncludingTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.amountIncludingTax = amountIncludingTax;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public PurchaseInvoiceLine withDescription(String description) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.description = description;
        return _x;
    }

    @Property(name="discountAmount")
    @JsonIgnore
    public Optional<BigDecimal> getDiscountAmount() {
        return Optional.ofNullable(discountAmount);
    }

    public PurchaseInvoiceLine withDiscountAmount(BigDecimal discountAmount) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("discountAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.discountAmount = discountAmount;
        return _x;
    }

    @Property(name="discountAppliedBeforeTax")
    @JsonIgnore
    public Optional<Boolean> getDiscountAppliedBeforeTax() {
        return Optional.ofNullable(discountAppliedBeforeTax);
    }

    public PurchaseInvoiceLine withDiscountAppliedBeforeTax(Boolean discountAppliedBeforeTax) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("discountAppliedBeforeTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
        return _x;
    }

    @Property(name="discountPercent")
    @JsonIgnore
    public Optional<BigDecimal> getDiscountPercent() {
        return Optional.ofNullable(discountPercent);
    }

    public PurchaseInvoiceLine withDiscountPercent(BigDecimal discountPercent) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("discountPercent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.discountPercent = discountPercent;
        return _x;
    }

    @Property(name="documentId")
    @JsonIgnore
    public Optional<UUID> getDocumentId() {
        return Optional.ofNullable(documentId);
    }

    public PurchaseInvoiceLine withDocumentId(UUID documentId) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("documentId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.documentId = documentId;
        return _x;
    }

    @Property(name="expectedReceiptDate")
    @JsonIgnore
    public Optional<LocalDate> getExpectedReceiptDate() {
        return Optional.ofNullable(expectedReceiptDate);
    }

    public PurchaseInvoiceLine withExpectedReceiptDate(LocalDate expectedReceiptDate) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("expectedReceiptDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.expectedReceiptDate = expectedReceiptDate;
        return _x;
    }

    @Property(name="invoiceDiscountAllocation")
    @JsonIgnore
    public Optional<BigDecimal> getInvoiceDiscountAllocation() {
        return Optional.ofNullable(invoiceDiscountAllocation);
    }

    public PurchaseInvoiceLine withInvoiceDiscountAllocation(BigDecimal invoiceDiscountAllocation) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("invoiceDiscountAllocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.invoiceDiscountAllocation = invoiceDiscountAllocation;
        return _x;
    }

    @Property(name="itemId")
    @JsonIgnore
    public Optional<UUID> getItemId() {
        return Optional.ofNullable(itemId);
    }

    public PurchaseInvoiceLine withItemId(UUID itemId) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("itemId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.itemId = itemId;
        return _x;
    }

    @Property(name="lineType")
    @JsonIgnore
    public Optional<String> getLineType() {
        return Optional.ofNullable(lineType);
    }

    public PurchaseInvoiceLine withLineType(String lineType) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("lineType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.lineType = lineType;
        return _x;
    }

    @Property(name="netAmount")
    @JsonIgnore
    public Optional<BigDecimal> getNetAmount() {
        return Optional.ofNullable(netAmount);
    }

    public PurchaseInvoiceLine withNetAmount(BigDecimal netAmount) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("netAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.netAmount = netAmount;
        return _x;
    }

    @Property(name="netAmountIncludingTax")
    @JsonIgnore
    public Optional<BigDecimal> getNetAmountIncludingTax() {
        return Optional.ofNullable(netAmountIncludingTax);
    }

    public PurchaseInvoiceLine withNetAmountIncludingTax(BigDecimal netAmountIncludingTax) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("netAmountIncludingTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.netAmountIncludingTax = netAmountIncludingTax;
        return _x;
    }

    @Property(name="netTaxAmount")
    @JsonIgnore
    public Optional<BigDecimal> getNetTaxAmount() {
        return Optional.ofNullable(netTaxAmount);
    }

    public PurchaseInvoiceLine withNetTaxAmount(BigDecimal netTaxAmount) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("netTaxAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.netTaxAmount = netTaxAmount;
        return _x;
    }

    @Property(name="quantity")
    @JsonIgnore
    public Optional<BigDecimal> getQuantity() {
        return Optional.ofNullable(quantity);
    }

    public PurchaseInvoiceLine withQuantity(BigDecimal quantity) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("quantity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.quantity = quantity;
        return _x;
    }

    @Property(name="sequence")
    @JsonIgnore
    public Optional<Integer> getSequence() {
        return Optional.ofNullable(sequence);
    }

    public PurchaseInvoiceLine withSequence(Integer sequence) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("sequence");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.sequence = sequence;
        return _x;
    }

    @Property(name="taxCode")
    @JsonIgnore
    public Optional<String> getTaxCode() {
        return Optional.ofNullable(taxCode);
    }

    public PurchaseInvoiceLine withTaxCode(String taxCode) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("taxCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.taxCode = taxCode;
        return _x;
    }

    @Property(name="taxPercent")
    @JsonIgnore
    public Optional<BigDecimal> getTaxPercent() {
        return Optional.ofNullable(taxPercent);
    }

    public PurchaseInvoiceLine withTaxPercent(BigDecimal taxPercent) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("taxPercent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.taxPercent = taxPercent;
        return _x;
    }

    @Property(name="totalTaxAmount")
    @JsonIgnore
    public Optional<BigDecimal> getTotalTaxAmount() {
        return Optional.ofNullable(totalTaxAmount);
    }

    public PurchaseInvoiceLine withTotalTaxAmount(BigDecimal totalTaxAmount) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("totalTaxAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.totalTaxAmount = totalTaxAmount;
        return _x;
    }

    @Property(name="unitCost")
    @JsonIgnore
    public Optional<BigDecimal> getUnitCost() {
        return Optional.ofNullable(unitCost);
    }

    public PurchaseInvoiceLine withUnitCost(BigDecimal unitCost) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("unitCost");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.unitCost = unitCost;
        return _x;
    }

    public PurchaseInvoiceLine withUnmappedField(String name, Object value) {
        PurchaseInvoiceLine _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="account")
    @JsonIgnore
    public AccountRequest getAccount() {
        return new AccountRequest(contextPath.addSegment("account"), Optional.ofNullable(account));
    }

    @NavigationProperty(name="item")
    @JsonIgnore
    public ItemRequest getItem() {
        return new ItemRequest(contextPath.addSegment("item"), Optional.ofNullable(item));
    }

    public PurchaseInvoiceLine withAccount(Account account) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("account");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.account = account;
        return _x;
    }

    public PurchaseInvoiceLine withItem(Item item) {
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = changedFields.add("item");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoiceLine");
        _x.item = item;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PurchaseInvoiceLine patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PurchaseInvoiceLine put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PurchaseInvoiceLine _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PurchaseInvoiceLine _copy() {
        PurchaseInvoiceLine _x = new PurchaseInvoiceLine();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.accountId = accountId;
        _x.amountExcludingTax = amountExcludingTax;
        _x.amountIncludingTax = amountIncludingTax;
        _x.description = description;
        _x.discountAmount = discountAmount;
        _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
        _x.discountPercent = discountPercent;
        _x.documentId = documentId;
        _x.expectedReceiptDate = expectedReceiptDate;
        _x.invoiceDiscountAllocation = invoiceDiscountAllocation;
        _x.itemId = itemId;
        _x.lineType = lineType;
        _x.netAmount = netAmount;
        _x.netAmountIncludingTax = netAmountIncludingTax;
        _x.netTaxAmount = netTaxAmount;
        _x.quantity = quantity;
        _x.sequence = sequence;
        _x.taxCode = taxCode;
        _x.taxPercent = taxPercent;
        _x.totalTaxAmount = totalTaxAmount;
        _x.unitCost = unitCost;
        _x.account = account;
        _x.item = item;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PurchaseInvoiceLine[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accountId=");
        b.append(this.accountId);
        b.append(", ");
        b.append("amountExcludingTax=");
        b.append(this.amountExcludingTax);
        b.append(", ");
        b.append("amountIncludingTax=");
        b.append(this.amountIncludingTax);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("discountAmount=");
        b.append(this.discountAmount);
        b.append(", ");
        b.append("discountAppliedBeforeTax=");
        b.append(this.discountAppliedBeforeTax);
        b.append(", ");
        b.append("discountPercent=");
        b.append(this.discountPercent);
        b.append(", ");
        b.append("documentId=");
        b.append(this.documentId);
        b.append(", ");
        b.append("expectedReceiptDate=");
        b.append(this.expectedReceiptDate);
        b.append(", ");
        b.append("invoiceDiscountAllocation=");
        b.append(this.invoiceDiscountAllocation);
        b.append(", ");
        b.append("itemId=");
        b.append(this.itemId);
        b.append(", ");
        b.append("lineType=");
        b.append(this.lineType);
        b.append(", ");
        b.append("netAmount=");
        b.append(this.netAmount);
        b.append(", ");
        b.append("netAmountIncludingTax=");
        b.append(this.netAmountIncludingTax);
        b.append(", ");
        b.append("netTaxAmount=");
        b.append(this.netTaxAmount);
        b.append(", ");
        b.append("quantity=");
        b.append(this.quantity);
        b.append(", ");
        b.append("sequence=");
        b.append(this.sequence);
        b.append(", ");
        b.append("taxCode=");
        b.append(this.taxCode);
        b.append(", ");
        b.append("taxPercent=");
        b.append(this.taxPercent);
        b.append(", ");
        b.append("totalTaxAmount=");
        b.append(this.totalTaxAmount);
        b.append(", ");
        b.append("unitCost=");
        b.append(this.unitCost);
        b.append(", ");
        b.append("account=");
        b.append(this.account);
        b.append(", ");
        b.append("item=");
        b.append(this.item);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
