package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Initiator;
import odata.msgraph.client.beta.complex.ModifiedProperty;
import odata.msgraph.client.beta.complex.ProvisionedIdentity;
import odata.msgraph.client.beta.complex.ProvisioningServicePrincipal;
import odata.msgraph.client.beta.complex.ProvisioningStatusInfo;
import odata.msgraph.client.beta.complex.ProvisioningStep;
import odata.msgraph.client.beta.complex.ProvisioningSystem;
import odata.msgraph.client.beta.complex.StatusBase;
import odata.msgraph.client.beta.enums.ProvisioningAction;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "action", 
    "activityDateTime", 
    "changeId", 
    "cycleId", 
    "durationInMilliseconds", 
    "initiatedBy", 
    "jobId", 
    "modifiedProperties", 
    "provisioningAction", 
    "provisioningStatusInfo", 
    "provisioningSteps", 
    "servicePrincipal", 
    "sourceIdentity", 
    "sourceSystem", 
    "statusInfo", 
    "targetIdentity", 
    "targetSystem", 
    "tenantId"})
@JsonInclude(Include.NON_NULL)
public class ProvisioningObjectSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.provisioningObjectSummary";
    }

    @JsonProperty("action")
    protected String action;

    @JsonProperty("activityDateTime")
    protected OffsetDateTime activityDateTime;

    @JsonProperty("changeId")
    protected String changeId;

    @JsonProperty("cycleId")
    protected String cycleId;

    @JsonProperty("durationInMilliseconds")
    protected Integer durationInMilliseconds;

    @JsonProperty("initiatedBy")
    protected Initiator initiatedBy;

    @JsonProperty("jobId")
    protected String jobId;

    @JsonProperty("modifiedProperties")
    protected List<ModifiedProperty> modifiedProperties;

    @JsonProperty("modifiedProperties@nextLink")
    protected String modifiedPropertiesNextLink;

    @JsonProperty("provisioningAction")
    protected ProvisioningAction provisioningAction;

    @JsonProperty("provisioningStatusInfo")
    protected ProvisioningStatusInfo provisioningStatusInfo;

    @JsonProperty("provisioningSteps")
    protected List<ProvisioningStep> provisioningSteps;

    @JsonProperty("provisioningSteps@nextLink")
    protected String provisioningStepsNextLink;

    @JsonProperty("servicePrincipal")
    protected ProvisioningServicePrincipal servicePrincipal;

    @JsonProperty("sourceIdentity")
    protected ProvisionedIdentity sourceIdentity;

    @JsonProperty("sourceSystem")
    protected ProvisioningSystem sourceSystem;

    @JsonProperty("statusInfo")
    protected StatusBase statusInfo;

    @JsonProperty("targetIdentity")
    protected ProvisionedIdentity targetIdentity;

    @JsonProperty("targetSystem")
    protected ProvisioningSystem targetSystem;

    @JsonProperty("tenantId")
    protected String tenantId;

    protected ProvisioningObjectSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderProvisioningObjectSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String action;
        private OffsetDateTime activityDateTime;
        private String changeId;
        private String cycleId;
        private Integer durationInMilliseconds;
        private Initiator initiatedBy;
        private String jobId;
        private List<ModifiedProperty> modifiedProperties;
        private String modifiedPropertiesNextLink;
        private ProvisioningAction provisioningAction;
        private ProvisioningStatusInfo provisioningStatusInfo;
        private List<ProvisioningStep> provisioningSteps;
        private String provisioningStepsNextLink;
        private ProvisioningServicePrincipal servicePrincipal;
        private ProvisionedIdentity sourceIdentity;
        private ProvisioningSystem sourceSystem;
        private StatusBase statusInfo;
        private ProvisionedIdentity targetIdentity;
        private ProvisioningSystem targetSystem;
        private String tenantId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param action
         *            value of {@code action} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder action(String action) {
            this.action = action;
            this.changedFields = changedFields.add("action");
            return this;
        }

        public Builder activityDateTime(OffsetDateTime activityDateTime) {
            this.activityDateTime = activityDateTime;
            this.changedFields = changedFields.add("activityDateTime");
            return this;
        }

        public Builder changeId(String changeId) {
            this.changeId = changeId;
            this.changedFields = changedFields.add("changeId");
            return this;
        }

        public Builder cycleId(String cycleId) {
            this.cycleId = cycleId;
            this.changedFields = changedFields.add("cycleId");
            return this;
        }

        public Builder durationInMilliseconds(Integer durationInMilliseconds) {
            this.durationInMilliseconds = durationInMilliseconds;
            this.changedFields = changedFields.add("durationInMilliseconds");
            return this;
        }

        public Builder initiatedBy(Initiator initiatedBy) {
            this.initiatedBy = initiatedBy;
            this.changedFields = changedFields.add("initiatedBy");
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            this.changedFields = changedFields.add("jobId");
            return this;
        }

        public Builder modifiedProperties(List<ModifiedProperty> modifiedProperties) {
            this.modifiedProperties = modifiedProperties;
            this.changedFields = changedFields.add("modifiedProperties");
            return this;
        }

        public Builder modifiedProperties(ModifiedProperty... modifiedProperties) {
            return modifiedProperties(Arrays.asList(modifiedProperties));
        }

        public Builder modifiedPropertiesNextLink(String modifiedPropertiesNextLink) {
            this.modifiedPropertiesNextLink = modifiedPropertiesNextLink;
            this.changedFields = changedFields.add("modifiedProperties");
            return this;
        }

        public Builder provisioningAction(ProvisioningAction provisioningAction) {
            this.provisioningAction = provisioningAction;
            this.changedFields = changedFields.add("provisioningAction");
            return this;
        }

        public Builder provisioningStatusInfo(ProvisioningStatusInfo provisioningStatusInfo) {
            this.provisioningStatusInfo = provisioningStatusInfo;
            this.changedFields = changedFields.add("provisioningStatusInfo");
            return this;
        }

        public Builder provisioningSteps(List<ProvisioningStep> provisioningSteps) {
            this.provisioningSteps = provisioningSteps;
            this.changedFields = changedFields.add("provisioningSteps");
            return this;
        }

        public Builder provisioningSteps(ProvisioningStep... provisioningSteps) {
            return provisioningSteps(Arrays.asList(provisioningSteps));
        }

        public Builder provisioningStepsNextLink(String provisioningStepsNextLink) {
            this.provisioningStepsNextLink = provisioningStepsNextLink;
            this.changedFields = changedFields.add("provisioningSteps");
            return this;
        }

        public Builder servicePrincipal(ProvisioningServicePrincipal servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            this.changedFields = changedFields.add("servicePrincipal");
            return this;
        }

        public Builder sourceIdentity(ProvisionedIdentity sourceIdentity) {
            this.sourceIdentity = sourceIdentity;
            this.changedFields = changedFields.add("sourceIdentity");
            return this;
        }

        public Builder sourceSystem(ProvisioningSystem sourceSystem) {
            this.sourceSystem = sourceSystem;
            this.changedFields = changedFields.add("sourceSystem");
            return this;
        }

        public Builder statusInfo(StatusBase statusInfo) {
            this.statusInfo = statusInfo;
            this.changedFields = changedFields.add("statusInfo");
            return this;
        }

        public Builder targetIdentity(ProvisionedIdentity targetIdentity) {
            this.targetIdentity = targetIdentity;
            this.changedFields = changedFields.add("targetIdentity");
            return this;
        }

        public Builder targetSystem(ProvisioningSystem targetSystem) {
            this.targetSystem = targetSystem;
            this.changedFields = changedFields.add("targetSystem");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public ProvisioningObjectSummary build() {
            ProvisioningObjectSummary _x = new ProvisioningObjectSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.provisioningObjectSummary";
            _x.id = id;
            _x.action = action;
            _x.activityDateTime = activityDateTime;
            _x.changeId = changeId;
            _x.cycleId = cycleId;
            _x.durationInMilliseconds = durationInMilliseconds;
            _x.initiatedBy = initiatedBy;
            _x.jobId = jobId;
            _x.modifiedProperties = modifiedProperties;
            _x.modifiedPropertiesNextLink = modifiedPropertiesNextLink;
            _x.provisioningAction = provisioningAction;
            _x.provisioningStatusInfo = provisioningStatusInfo;
            _x.provisioningSteps = provisioningSteps;
            _x.provisioningStepsNextLink = provisioningStepsNextLink;
            _x.servicePrincipal = servicePrincipal;
            _x.sourceIdentity = sourceIdentity;
            _x.sourceSystem = sourceSystem;
            _x.statusInfo = statusInfo;
            _x.targetIdentity = targetIdentity;
            _x.targetSystem = targetSystem;
            _x.tenantId = tenantId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @return property action
     */
    @Property(name="action")
    @JsonIgnore
    public Optional<String> getAction() {
        return Optional.ofNullable(action);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code action} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @param action
     *            new value of {@code action} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code action} field changed
     */
    public ProvisioningObjectSummary withAction(String action) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("action");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.action = action;
        return _x;
    }

    @Property(name="activityDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getActivityDateTime() {
        return Optional.ofNullable(activityDateTime);
    }

    public ProvisioningObjectSummary withActivityDateTime(OffsetDateTime activityDateTime) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("activityDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.activityDateTime = activityDateTime;
        return _x;
    }

    @Property(name="changeId")
    @JsonIgnore
    public Optional<String> getChangeId() {
        return Optional.ofNullable(changeId);
    }

    public ProvisioningObjectSummary withChangeId(String changeId) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("changeId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.changeId = changeId;
        return _x;
    }

    @Property(name="cycleId")
    @JsonIgnore
    public Optional<String> getCycleId() {
        return Optional.ofNullable(cycleId);
    }

    public ProvisioningObjectSummary withCycleId(String cycleId) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("cycleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.cycleId = cycleId;
        return _x;
    }

    @Property(name="durationInMilliseconds")
    @JsonIgnore
    public Optional<Integer> getDurationInMilliseconds() {
        return Optional.ofNullable(durationInMilliseconds);
    }

    public ProvisioningObjectSummary withDurationInMilliseconds(Integer durationInMilliseconds) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("durationInMilliseconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.durationInMilliseconds = durationInMilliseconds;
        return _x;
    }

    @Property(name="initiatedBy")
    @JsonIgnore
    public Optional<Initiator> getInitiatedBy() {
        return Optional.ofNullable(initiatedBy);
    }

    public ProvisioningObjectSummary withInitiatedBy(Initiator initiatedBy) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("initiatedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.initiatedBy = initiatedBy;
        return _x;
    }

    @Property(name="jobId")
    @JsonIgnore
    public Optional<String> getJobId() {
        return Optional.ofNullable(jobId);
    }

    public ProvisioningObjectSummary withJobId(String jobId) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("jobId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.jobId = jobId;
        return _x;
    }

    @Property(name="modifiedProperties")
    @JsonIgnore
    public CollectionPage<ModifiedProperty> getModifiedProperties() {
        return new CollectionPage<ModifiedProperty>(contextPath, ModifiedProperty.class, this.modifiedProperties, Optional.ofNullable(modifiedPropertiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ProvisioningObjectSummary withModifiedProperties(List<ModifiedProperty> modifiedProperties) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("modifiedProperties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.modifiedProperties = modifiedProperties;
        return _x;
    }

    @Property(name="modifiedProperties")
    @JsonIgnore
    public CollectionPage<ModifiedProperty> getModifiedProperties(HttpRequestOptions options) {
        return new CollectionPage<ModifiedProperty>(contextPath, ModifiedProperty.class, this.modifiedProperties, Optional.ofNullable(modifiedPropertiesNextLink), Collections.emptyList(), options);
    }

    @Property(name="provisioningAction")
    @JsonIgnore
    public Optional<ProvisioningAction> getProvisioningAction() {
        return Optional.ofNullable(provisioningAction);
    }

    public ProvisioningObjectSummary withProvisioningAction(ProvisioningAction provisioningAction) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("provisioningAction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.provisioningAction = provisioningAction;
        return _x;
    }

    @Property(name="provisioningStatusInfo")
    @JsonIgnore
    public Optional<ProvisioningStatusInfo> getProvisioningStatusInfo() {
        return Optional.ofNullable(provisioningStatusInfo);
    }

    public ProvisioningObjectSummary withProvisioningStatusInfo(ProvisioningStatusInfo provisioningStatusInfo) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("provisioningStatusInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.provisioningStatusInfo = provisioningStatusInfo;
        return _x;
    }

    @Property(name="provisioningSteps")
    @JsonIgnore
    public CollectionPage<ProvisioningStep> getProvisioningSteps() {
        return new CollectionPage<ProvisioningStep>(contextPath, ProvisioningStep.class, this.provisioningSteps, Optional.ofNullable(provisioningStepsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ProvisioningObjectSummary withProvisioningSteps(List<ProvisioningStep> provisioningSteps) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("provisioningSteps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.provisioningSteps = provisioningSteps;
        return _x;
    }

    @Property(name="provisioningSteps")
    @JsonIgnore
    public CollectionPage<ProvisioningStep> getProvisioningSteps(HttpRequestOptions options) {
        return new CollectionPage<ProvisioningStep>(contextPath, ProvisioningStep.class, this.provisioningSteps, Optional.ofNullable(provisioningStepsNextLink), Collections.emptyList(), options);
    }

    @Property(name="servicePrincipal")
    @JsonIgnore
    public Optional<ProvisioningServicePrincipal> getServicePrincipal() {
        return Optional.ofNullable(servicePrincipal);
    }

    public ProvisioningObjectSummary withServicePrincipal(ProvisioningServicePrincipal servicePrincipal) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("servicePrincipal");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.servicePrincipal = servicePrincipal;
        return _x;
    }

    @Property(name="sourceIdentity")
    @JsonIgnore
    public Optional<ProvisionedIdentity> getSourceIdentity() {
        return Optional.ofNullable(sourceIdentity);
    }

    public ProvisioningObjectSummary withSourceIdentity(ProvisionedIdentity sourceIdentity) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("sourceIdentity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.sourceIdentity = sourceIdentity;
        return _x;
    }

    @Property(name="sourceSystem")
    @JsonIgnore
    public Optional<ProvisioningSystem> getSourceSystem() {
        return Optional.ofNullable(sourceSystem);
    }

    public ProvisioningObjectSummary withSourceSystem(ProvisioningSystem sourceSystem) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("sourceSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.sourceSystem = sourceSystem;
        return _x;
    }

    @Property(name="statusInfo")
    @JsonIgnore
    public Optional<StatusBase> getStatusInfo() {
        return Optional.ofNullable(statusInfo);
    }

    public ProvisioningObjectSummary withStatusInfo(StatusBase statusInfo) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("statusInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.statusInfo = statusInfo;
        return _x;
    }

    @Property(name="targetIdentity")
    @JsonIgnore
    public Optional<ProvisionedIdentity> getTargetIdentity() {
        return Optional.ofNullable(targetIdentity);
    }

    public ProvisioningObjectSummary withTargetIdentity(ProvisionedIdentity targetIdentity) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("targetIdentity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.targetIdentity = targetIdentity;
        return _x;
    }

    @Property(name="targetSystem")
    @JsonIgnore
    public Optional<ProvisioningSystem> getTargetSystem() {
        return Optional.ofNullable(targetSystem);
    }

    public ProvisioningObjectSummary withTargetSystem(ProvisioningSystem targetSystem) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("targetSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.targetSystem = targetSystem;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public ProvisioningObjectSummary withTenantId(String tenantId) {
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningObjectSummary");
        _x.tenantId = tenantId;
        return _x;
    }

    public ProvisioningObjectSummary withUnmappedField(String name, Object value) {
        ProvisioningObjectSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ProvisioningObjectSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ProvisioningObjectSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ProvisioningObjectSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ProvisioningObjectSummary _copy() {
        ProvisioningObjectSummary _x = new ProvisioningObjectSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.action = action;
        _x.activityDateTime = activityDateTime;
        _x.changeId = changeId;
        _x.cycleId = cycleId;
        _x.durationInMilliseconds = durationInMilliseconds;
        _x.initiatedBy = initiatedBy;
        _x.jobId = jobId;
        _x.modifiedProperties = modifiedProperties;
        _x.provisioningAction = provisioningAction;
        _x.provisioningStatusInfo = provisioningStatusInfo;
        _x.provisioningSteps = provisioningSteps;
        _x.servicePrincipal = servicePrincipal;
        _x.sourceIdentity = sourceIdentity;
        _x.sourceSystem = sourceSystem;
        _x.statusInfo = statusInfo;
        _x.targetIdentity = targetIdentity;
        _x.targetSystem = targetSystem;
        _x.tenantId = tenantId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProvisioningObjectSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("action=");
        b.append(this.action);
        b.append(", ");
        b.append("activityDateTime=");
        b.append(this.activityDateTime);
        b.append(", ");
        b.append("changeId=");
        b.append(this.changeId);
        b.append(", ");
        b.append("cycleId=");
        b.append(this.cycleId);
        b.append(", ");
        b.append("durationInMilliseconds=");
        b.append(this.durationInMilliseconds);
        b.append(", ");
        b.append("initiatedBy=");
        b.append(this.initiatedBy);
        b.append(", ");
        b.append("jobId=");
        b.append(this.jobId);
        b.append(", ");
        b.append("modifiedProperties=");
        b.append(this.modifiedProperties);
        b.append(", ");
        b.append("provisioningAction=");
        b.append(this.provisioningAction);
        b.append(", ");
        b.append("provisioningStatusInfo=");
        b.append(this.provisioningStatusInfo);
        b.append(", ");
        b.append("provisioningSteps=");
        b.append(this.provisioningSteps);
        b.append(", ");
        b.append("servicePrincipal=");
        b.append(this.servicePrincipal);
        b.append(", ");
        b.append("sourceIdentity=");
        b.append(this.sourceIdentity);
        b.append(", ");
        b.append("sourceSystem=");
        b.append(this.sourceSystem);
        b.append(", ");
        b.append("statusInfo=");
        b.append(this.statusInfo);
        b.append(", ");
        b.append("targetIdentity=");
        b.append(this.targetIdentity);
        b.append(", ");
        b.append("targetSystem=");
        b.append(this.targetSystem);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
