package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CompanyDetail;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.InferenceData;
import odata.msgraph.client.beta.complex.PersonDataSources;
import odata.msgraph.client.beta.complex.PositionDetail;
import odata.msgraph.client.beta.complex.RelatedPerson;
import odata.msgraph.client.beta.enums.AllowedAudiences;

@JsonPropertyOrder({
    "@odata.type", 
    "categories", 
    "client", 
    "collaborationTags", 
    "colleagues", 
    "detail", 
    "displayName", 
    "sponsors", 
    "thumbnailUrl"})
@JsonInclude(Include.NON_NULL)
public class ProjectParticipation extends ItemFacet implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.projectParticipation";
    }

    @JsonProperty("categories")
    protected List<String> categories;

    @JsonProperty("categories@nextLink")
    protected String categoriesNextLink;

    @JsonProperty("client")
    protected CompanyDetail client;

    @JsonProperty("collaborationTags")
    protected List<String> collaborationTags;

    @JsonProperty("collaborationTags@nextLink")
    protected String collaborationTagsNextLink;

    @JsonProperty("colleagues")
    protected List<RelatedPerson> colleagues;

    @JsonProperty("colleagues@nextLink")
    protected String colleaguesNextLink;

    @JsonProperty("detail")
    protected PositionDetail detail;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("sponsors")
    protected List<RelatedPerson> sponsors;

    @JsonProperty("sponsors@nextLink")
    protected String sponsorsNextLink;

    @JsonProperty("thumbnailUrl")
    protected String thumbnailUrl;

    protected ProjectParticipation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderProjectParticipation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AllowedAudiences allowedAudiences;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private InferenceData inference;
        private Boolean isSearchable;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private PersonDataSources source;
        private List<String> categories;
        private String categoriesNextLink;
        private CompanyDetail client;
        private List<String> collaborationTags;
        private String collaborationTagsNextLink;
        private List<RelatedPerson> colleagues;
        private String colleaguesNextLink;
        private PositionDetail detail;
        private String displayName;
        private List<RelatedPerson> sponsors;
        private String sponsorsNextLink;
        private String thumbnailUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder allowedAudiences(AllowedAudiences allowedAudiences) {
            this.allowedAudiences = allowedAudiences;
            this.changedFields = changedFields.add("allowedAudiences");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder inference(InferenceData inference) {
            this.inference = inference;
            this.changedFields = changedFields.add("inference");
            return this;
        }

        public Builder isSearchable(Boolean isSearchable) {
            this.isSearchable = isSearchable;
            this.changedFields = changedFields.add("isSearchable");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder source(PersonDataSources source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder categories(List<String> categories) {
            this.categories = categories;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder categories(String... categories) {
            return categories(Arrays.asList(categories));
        }

        public Builder categoriesNextLink(String categoriesNextLink) {
            this.categoriesNextLink = categoriesNextLink;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder client(CompanyDetail client) {
            this.client = client;
            this.changedFields = changedFields.add("client");
            return this;
        }

        public Builder collaborationTags(List<String> collaborationTags) {
            this.collaborationTags = collaborationTags;
            this.changedFields = changedFields.add("collaborationTags");
            return this;
        }

        public Builder collaborationTags(String... collaborationTags) {
            return collaborationTags(Arrays.asList(collaborationTags));
        }

        public Builder collaborationTagsNextLink(String collaborationTagsNextLink) {
            this.collaborationTagsNextLink = collaborationTagsNextLink;
            this.changedFields = changedFields.add("collaborationTags");
            return this;
        }

        public Builder colleagues(List<RelatedPerson> colleagues) {
            this.colleagues = colleagues;
            this.changedFields = changedFields.add("colleagues");
            return this;
        }

        public Builder colleagues(RelatedPerson... colleagues) {
            return colleagues(Arrays.asList(colleagues));
        }

        public Builder colleaguesNextLink(String colleaguesNextLink) {
            this.colleaguesNextLink = colleaguesNextLink;
            this.changedFields = changedFields.add("colleagues");
            return this;
        }

        public Builder detail(PositionDetail detail) {
            this.detail = detail;
            this.changedFields = changedFields.add("detail");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder sponsors(List<RelatedPerson> sponsors) {
            this.sponsors = sponsors;
            this.changedFields = changedFields.add("sponsors");
            return this;
        }

        public Builder sponsors(RelatedPerson... sponsors) {
            return sponsors(Arrays.asList(sponsors));
        }

        public Builder sponsorsNextLink(String sponsorsNextLink) {
            this.sponsorsNextLink = sponsorsNextLink;
            this.changedFields = changedFields.add("sponsors");
            return this;
        }

        public Builder thumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            this.changedFields = changedFields.add("thumbnailUrl");
            return this;
        }

        public ProjectParticipation build() {
            ProjectParticipation _x = new ProjectParticipation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.projectParticipation";
            _x.id = id;
            _x.allowedAudiences = allowedAudiences;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.inference = inference;
            _x.isSearchable = isSearchable;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.source = source;
            _x.categories = categories;
            _x.categoriesNextLink = categoriesNextLink;
            _x.client = client;
            _x.collaborationTags = collaborationTags;
            _x.collaborationTagsNextLink = collaborationTagsNextLink;
            _x.colleagues = colleagues;
            _x.colleaguesNextLink = colleaguesNextLink;
            _x.detail = detail;
            _x.displayName = displayName;
            _x.sponsors = sponsors;
            _x.sponsorsNextLink = sponsorsNextLink;
            _x.thumbnailUrl = thumbnailUrl;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="categories")
    @JsonIgnore
    public CollectionPage<String> getCategories() {
        return new CollectionPage<String>(contextPath, String.class, this.categories, Optional.ofNullable(categoriesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ProjectParticipation withCategories(List<String> categories) {
        ProjectParticipation _x = _copy();
        _x.changedFields = changedFields.add("categories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.projectParticipation");
        _x.categories = categories;
        return _x;
    }

    @Property(name="categories")
    @JsonIgnore
    public CollectionPage<String> getCategories(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.categories, Optional.ofNullable(categoriesNextLink), Collections.emptyList(), options);
    }

    @Property(name="client")
    @JsonIgnore
    public Optional<CompanyDetail> getClient() {
        return Optional.ofNullable(client);
    }

    public ProjectParticipation withClient(CompanyDetail client) {
        ProjectParticipation _x = _copy();
        _x.changedFields = changedFields.add("client");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.projectParticipation");
        _x.client = client;
        return _x;
    }

    @Property(name="collaborationTags")
    @JsonIgnore
    public CollectionPage<String> getCollaborationTags() {
        return new CollectionPage<String>(contextPath, String.class, this.collaborationTags, Optional.ofNullable(collaborationTagsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ProjectParticipation withCollaborationTags(List<String> collaborationTags) {
        ProjectParticipation _x = _copy();
        _x.changedFields = changedFields.add("collaborationTags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.projectParticipation");
        _x.collaborationTags = collaborationTags;
        return _x;
    }

    @Property(name="collaborationTags")
    @JsonIgnore
    public CollectionPage<String> getCollaborationTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.collaborationTags, Optional.ofNullable(collaborationTagsNextLink), Collections.emptyList(), options);
    }

    @Property(name="colleagues")
    @JsonIgnore
    public CollectionPage<RelatedPerson> getColleagues() {
        return new CollectionPage<RelatedPerson>(contextPath, RelatedPerson.class, this.colleagues, Optional.ofNullable(colleaguesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ProjectParticipation withColleagues(List<RelatedPerson> colleagues) {
        ProjectParticipation _x = _copy();
        _x.changedFields = changedFields.add("colleagues");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.projectParticipation");
        _x.colleagues = colleagues;
        return _x;
    }

    @Property(name="colleagues")
    @JsonIgnore
    public CollectionPage<RelatedPerson> getColleagues(HttpRequestOptions options) {
        return new CollectionPage<RelatedPerson>(contextPath, RelatedPerson.class, this.colleagues, Optional.ofNullable(colleaguesNextLink), Collections.emptyList(), options);
    }

    @Property(name="detail")
    @JsonIgnore
    public Optional<PositionDetail> getDetail() {
        return Optional.ofNullable(detail);
    }

    public ProjectParticipation withDetail(PositionDetail detail) {
        ProjectParticipation _x = _copy();
        _x.changedFields = changedFields.add("detail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.projectParticipation");
        _x.detail = detail;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ProjectParticipation withDisplayName(String displayName) {
        ProjectParticipation _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.projectParticipation");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="sponsors")
    @JsonIgnore
    public CollectionPage<RelatedPerson> getSponsors() {
        return new CollectionPage<RelatedPerson>(contextPath, RelatedPerson.class, this.sponsors, Optional.ofNullable(sponsorsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ProjectParticipation withSponsors(List<RelatedPerson> sponsors) {
        ProjectParticipation _x = _copy();
        _x.changedFields = changedFields.add("sponsors");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.projectParticipation");
        _x.sponsors = sponsors;
        return _x;
    }

    @Property(name="sponsors")
    @JsonIgnore
    public CollectionPage<RelatedPerson> getSponsors(HttpRequestOptions options) {
        return new CollectionPage<RelatedPerson>(contextPath, RelatedPerson.class, this.sponsors, Optional.ofNullable(sponsorsNextLink), Collections.emptyList(), options);
    }

    @Property(name="thumbnailUrl")
    @JsonIgnore
    public Optional<String> getThumbnailUrl() {
        return Optional.ofNullable(thumbnailUrl);
    }

    public ProjectParticipation withThumbnailUrl(String thumbnailUrl) {
        ProjectParticipation _x = _copy();
        _x.changedFields = changedFields.add("thumbnailUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.projectParticipation");
        _x.thumbnailUrl = thumbnailUrl;
        return _x;
    }

    public ProjectParticipation withUnmappedField(String name, Object value) {
        ProjectParticipation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ProjectParticipation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ProjectParticipation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ProjectParticipation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ProjectParticipation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ProjectParticipation _copy() {
        ProjectParticipation _x = new ProjectParticipation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.allowedAudiences = allowedAudiences;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.inference = inference;
        _x.isSearchable = isSearchable;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.source = source;
        _x.categories = categories;
        _x.client = client;
        _x.collaborationTags = collaborationTags;
        _x.colleagues = colleagues;
        _x.detail = detail;
        _x.displayName = displayName;
        _x.sponsors = sponsors;
        _x.thumbnailUrl = thumbnailUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProjectParticipation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("allowedAudiences=");
        b.append(this.allowedAudiences);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("inference=");
        b.append(this.inference);
        b.append(", ");
        b.append("isSearchable=");
        b.append(this.isSearchable);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("categories=");
        b.append(this.categories);
        b.append(", ");
        b.append("client=");
        b.append(this.client);
        b.append(", ");
        b.append("collaborationTags=");
        b.append(this.collaborationTags);
        b.append(", ");
        b.append("colleagues=");
        b.append(this.colleagues);
        b.append(", ");
        b.append("detail=");
        b.append(this.detail);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("sponsors=");
        b.append(this.sponsors);
        b.append(", ");
        b.append("thumbnailUrl=");
        b.append(this.thumbnailUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
