package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "height", 
    "width"})
@JsonInclude(Include.NON_NULL)
public class ProfilePhoto extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.profilePhoto";
    }

    @JsonProperty("height")
    protected Integer height;

    @JsonProperty("width")
    protected Integer width;

    protected ProfilePhoto() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderProfilePhoto() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer height;
        private Integer width;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder height(Integer height) {
            this.height = height;
            this.changedFields = changedFields.add("height");
            return this;
        }

        public Builder width(Integer width) {
            this.width = width;
            this.changedFields = changedFields.add("width");
            return this;
        }

        public ProfilePhoto build() {
            ProfilePhoto _x = new ProfilePhoto();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.profilePhoto";
            _x.id = id;
            _x.height = height;
            _x.width = width;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="height")
    @JsonIgnore
    public Optional<Integer> getHeight() {
        return Optional.ofNullable(height);
    }

    public ProfilePhoto withHeight(Integer height) {
        ProfilePhoto _x = _copy();
        _x.changedFields = changedFields.add("height");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profilePhoto");
        _x.height = height;
        return _x;
    }

    @Property(name="width")
    @JsonIgnore
    public Optional<Integer> getWidth() {
        return Optional.ofNullable(width);
    }

    public ProfilePhoto withWidth(Integer width) {
        ProfilePhoto _x = _copy();
        _x.changedFields = changedFields.add("width");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profilePhoto");
        _x.width = width;
        return _x;
    }

    public ProfilePhoto withUnmappedField(String name, Object value) {
        ProfilePhoto _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * If suitable metadata found a StreamProvider is returned otherwise returns
     * {@code Optional.empty()}. Normally for a stream to be available this entity
     * needs to have been hydrated with full metadata. Consider calling the builder
     * method {@code .metadataFull()} when getting this instance (either directly or
     * as part of a collection).
     *
     * @return StreamProvider if suitable metadata found otherwise returns
     *         {@code Optional.empty()}
     */
    @JsonIgnore
    public Optional<StreamProvider> getStream() {
        return RequestHelper.createStream(contextPath, this);
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ProfilePhoto patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ProfilePhoto _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ProfilePhoto put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ProfilePhoto _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ProfilePhoto _copy() {
        ProfilePhoto _x = new ProfilePhoto();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.height = height;
        _x.width = width;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProfilePhoto[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("height=");
        b.append(this.height);
        b.append(", ");
        b.append("width=");
        b.append(this.width);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
