package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RoleSummaryStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "elevatedCount", 
    "managedCount", 
    "mfaEnabled", 
    "status", 
    "usersCount"})
@JsonInclude(Include.NON_NULL)
public class PrivilegedRoleSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.privilegedRoleSummary";
    }

    @JsonProperty("elevatedCount")
    protected Integer elevatedCount;

    @JsonProperty("managedCount")
    protected Integer managedCount;

    @JsonProperty("mfaEnabled")
    protected Boolean mfaEnabled;

    @JsonProperty("status")
    protected RoleSummaryStatus status;

    @JsonProperty("usersCount")
    protected Integer usersCount;

    protected PrivilegedRoleSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrivilegedRoleSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer elevatedCount;
        private Integer managedCount;
        private Boolean mfaEnabled;
        private RoleSummaryStatus status;
        private Integer usersCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder elevatedCount(Integer elevatedCount) {
            this.elevatedCount = elevatedCount;
            this.changedFields = changedFields.add("elevatedCount");
            return this;
        }

        public Builder managedCount(Integer managedCount) {
            this.managedCount = managedCount;
            this.changedFields = changedFields.add("managedCount");
            return this;
        }

        public Builder mfaEnabled(Boolean mfaEnabled) {
            this.mfaEnabled = mfaEnabled;
            this.changedFields = changedFields.add("mfaEnabled");
            return this;
        }

        public Builder status(RoleSummaryStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder usersCount(Integer usersCount) {
            this.usersCount = usersCount;
            this.changedFields = changedFields.add("usersCount");
            return this;
        }

        public PrivilegedRoleSummary build() {
            PrivilegedRoleSummary _x = new PrivilegedRoleSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.privilegedRoleSummary";
            _x.id = id;
            _x.elevatedCount = elevatedCount;
            _x.managedCount = managedCount;
            _x.mfaEnabled = mfaEnabled;
            _x.status = status;
            _x.usersCount = usersCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="elevatedCount")
    @JsonIgnore
    public Optional<Integer> getElevatedCount() {
        return Optional.ofNullable(elevatedCount);
    }

    public PrivilegedRoleSummary withElevatedCount(Integer elevatedCount) {
        PrivilegedRoleSummary _x = _copy();
        _x.changedFields = changedFields.add("elevatedCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleSummary");
        _x.elevatedCount = elevatedCount;
        return _x;
    }

    @Property(name="managedCount")
    @JsonIgnore
    public Optional<Integer> getManagedCount() {
        return Optional.ofNullable(managedCount);
    }

    public PrivilegedRoleSummary withManagedCount(Integer managedCount) {
        PrivilegedRoleSummary _x = _copy();
        _x.changedFields = changedFields.add("managedCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleSummary");
        _x.managedCount = managedCount;
        return _x;
    }

    @Property(name="mfaEnabled")
    @JsonIgnore
    public Optional<Boolean> getMfaEnabled() {
        return Optional.ofNullable(mfaEnabled);
    }

    public PrivilegedRoleSummary withMfaEnabled(Boolean mfaEnabled) {
        PrivilegedRoleSummary _x = _copy();
        _x.changedFields = changedFields.add("mfaEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleSummary");
        _x.mfaEnabled = mfaEnabled;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<RoleSummaryStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public PrivilegedRoleSummary withStatus(RoleSummaryStatus status) {
        PrivilegedRoleSummary _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleSummary");
        _x.status = status;
        return _x;
    }

    @Property(name="usersCount")
    @JsonIgnore
    public Optional<Integer> getUsersCount() {
        return Optional.ofNullable(usersCount);
    }

    public PrivilegedRoleSummary withUsersCount(Integer usersCount) {
        PrivilegedRoleSummary _x = _copy();
        _x.changedFields = changedFields.add("usersCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleSummary");
        _x.usersCount = usersCount;
        return _x;
    }

    public PrivilegedRoleSummary withUnmappedField(String name, Object value) {
        PrivilegedRoleSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrivilegedRoleSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrivilegedRoleSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrivilegedRoleSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrivilegedRoleSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrivilegedRoleSummary _copy() {
        PrivilegedRoleSummary _x = new PrivilegedRoleSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.elevatedCount = elevatedCount;
        _x.managedCount = managedCount;
        _x.mfaEnabled = mfaEnabled;
        _x.status = status;
        _x.usersCount = usersCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrivilegedRoleSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("elevatedCount=");
        b.append(this.elevatedCount);
        b.append(", ");
        b.append("managedCount=");
        b.append(this.managedCount);
        b.append(", ");
        b.append("mfaEnabled=");
        b.append(this.mfaEnabled);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("usersCount=");
        b.append(this.usersCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
