package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.PrivilegedRoleRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "expirationDateTime", 
    "isElevated", 
    "resultMessage", 
    "roleId", 
    "userId", 
    "roleInfo"})
@JsonInclude(Include.NON_NULL)
public class PrivilegedRoleAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.privilegedRoleAssignment";
    }

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("isElevated")
    protected Boolean isElevated;

    @JsonProperty("resultMessage")
    protected String resultMessage;

    @JsonProperty("roleId")
    protected String roleId;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("roleInfo")
    protected PrivilegedRole roleInfo;

    protected PrivilegedRoleAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrivilegedRoleAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime expirationDateTime;
        private Boolean isElevated;
        private String resultMessage;
        private String roleId;
        private String userId;
        private PrivilegedRole roleInfo;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder isElevated(Boolean isElevated) {
            this.isElevated = isElevated;
            this.changedFields = changedFields.add("isElevated");
            return this;
        }

        public Builder resultMessage(String resultMessage) {
            this.resultMessage = resultMessage;
            this.changedFields = changedFields.add("resultMessage");
            return this;
        }

        public Builder roleId(String roleId) {
            this.roleId = roleId;
            this.changedFields = changedFields.add("roleId");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder roleInfo(PrivilegedRole roleInfo) {
            this.roleInfo = roleInfo;
            this.changedFields = changedFields.add("roleInfo");
            return this;
        }

        public PrivilegedRoleAssignment build() {
            PrivilegedRoleAssignment _x = new PrivilegedRoleAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.privilegedRoleAssignment";
            _x.id = id;
            _x.expirationDateTime = expirationDateTime;
            _x.isElevated = isElevated;
            _x.resultMessage = resultMessage;
            _x.roleId = roleId;
            _x.userId = userId;
            _x.roleInfo = roleInfo;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public PrivilegedRoleAssignment withExpirationDateTime(OffsetDateTime expirationDateTime) {
        PrivilegedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleAssignment");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="isElevated")
    @JsonIgnore
    public Optional<Boolean> getIsElevated() {
        return Optional.ofNullable(isElevated);
    }

    public PrivilegedRoleAssignment withIsElevated(Boolean isElevated) {
        PrivilegedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("isElevated");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleAssignment");
        _x.isElevated = isElevated;
        return _x;
    }

    @Property(name="resultMessage")
    @JsonIgnore
    public Optional<String> getResultMessage() {
        return Optional.ofNullable(resultMessage);
    }

    public PrivilegedRoleAssignment withResultMessage(String resultMessage) {
        PrivilegedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("resultMessage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleAssignment");
        _x.resultMessage = resultMessage;
        return _x;
    }

    @Property(name="roleId")
    @JsonIgnore
    public Optional<String> getRoleId() {
        return Optional.ofNullable(roleId);
    }

    public PrivilegedRoleAssignment withRoleId(String roleId) {
        PrivilegedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("roleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleAssignment");
        _x.roleId = roleId;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public PrivilegedRoleAssignment withUserId(String userId) {
        PrivilegedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleAssignment");
        _x.userId = userId;
        return _x;
    }

    public PrivilegedRoleAssignment withUnmappedField(String name, Object value) {
        PrivilegedRoleAssignment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="roleInfo")
    @JsonIgnore
    public PrivilegedRoleRequest getRoleInfo() {
        return new PrivilegedRoleRequest(contextPath.addSegment("roleInfo"), Optional.ofNullable(roleInfo));
    }

    public PrivilegedRoleAssignment withRoleInfo(PrivilegedRole roleInfo) {
        PrivilegedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("roleInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleAssignment");
        _x.roleInfo = roleInfo;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrivilegedRoleAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrivilegedRoleAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrivilegedRoleAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrivilegedRoleAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrivilegedRoleAssignment _copy() {
        PrivilegedRoleAssignment _x = new PrivilegedRoleAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.expirationDateTime = expirationDateTime;
        _x.isElevated = isElevated;
        _x.resultMessage = resultMessage;
        _x.roleId = roleId;
        _x.userId = userId;
        _x.roleInfo = roleInfo;
        return _x;
    }

    @Action(name = "makeEligible")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignment> makeEligible() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignment>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.makeEligible"), PrivilegedRoleAssignment.class, _parameters);
    }

    @Action(name = "makePermanent")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignment> makePermanent(String reason, String ticketNumber, String ticketSystem) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("reason", "Edm.String", Checks.checkIsAscii(reason))
            .put("ticketNumber", "Edm.String", Checks.checkIsAscii(ticketNumber))
            .put("ticketSystem", "Edm.String", Checks.checkIsAscii(ticketSystem))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignment>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.makePermanent"), PrivilegedRoleAssignment.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrivilegedRoleAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("isElevated=");
        b.append(this.isElevated);
        b.append(", ");
        b.append("resultMessage=");
        b.append(this.resultMessage);
        b.append(", ");
        b.append("roleId=");
        b.append(this.roleId);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("roleInfo=");
        b.append(this.roleInfo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
