package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.GovernanceResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleAssignmentRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleSettingCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "resources", 
    "roleAssignmentRequests", 
    "roleAssignments", 
    "roleDefinitions", 
    "roleSettings"})
@JsonInclude(Include.NON_NULL)
public class PrivilegedAccess extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.privilegedAccess";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("resources")
    protected List<GovernanceResource> resources;

    @JsonProperty("roleAssignmentRequests")
    protected List<GovernanceRoleAssignmentRequest> roleAssignmentRequests;

    @JsonProperty("roleAssignments")
    protected List<GovernanceRoleAssignment> roleAssignments;

    @JsonProperty("roleDefinitions")
    protected List<GovernanceRoleDefinition> roleDefinitions;

    @JsonProperty("roleSettings")
    protected List<GovernanceRoleSetting> roleSettings;

    protected PrivilegedAccess() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrivilegedAccess() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private List<GovernanceResource> resources;
        private List<GovernanceRoleAssignmentRequest> roleAssignmentRequests;
        private List<GovernanceRoleAssignment> roleAssignments;
        private List<GovernanceRoleDefinition> roleDefinitions;
        private List<GovernanceRoleSetting> roleSettings;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder resources(List<GovernanceResource> resources) {
            this.resources = resources;
            this.changedFields = changedFields.add("resources");
            return this;
        }

        public Builder resources(GovernanceResource... resources) {
            return resources(Arrays.asList(resources));
        }

        public Builder roleAssignmentRequests(List<GovernanceRoleAssignmentRequest> roleAssignmentRequests) {
            this.roleAssignmentRequests = roleAssignmentRequests;
            this.changedFields = changedFields.add("roleAssignmentRequests");
            return this;
        }

        public Builder roleAssignmentRequests(GovernanceRoleAssignmentRequest... roleAssignmentRequests) {
            return roleAssignmentRequests(Arrays.asList(roleAssignmentRequests));
        }

        public Builder roleAssignments(List<GovernanceRoleAssignment> roleAssignments) {
            this.roleAssignments = roleAssignments;
            this.changedFields = changedFields.add("roleAssignments");
            return this;
        }

        public Builder roleAssignments(GovernanceRoleAssignment... roleAssignments) {
            return roleAssignments(Arrays.asList(roleAssignments));
        }

        public Builder roleDefinitions(List<GovernanceRoleDefinition> roleDefinitions) {
            this.roleDefinitions = roleDefinitions;
            this.changedFields = changedFields.add("roleDefinitions");
            return this;
        }

        public Builder roleDefinitions(GovernanceRoleDefinition... roleDefinitions) {
            return roleDefinitions(Arrays.asList(roleDefinitions));
        }

        public Builder roleSettings(List<GovernanceRoleSetting> roleSettings) {
            this.roleSettings = roleSettings;
            this.changedFields = changedFields.add("roleSettings");
            return this;
        }

        public Builder roleSettings(GovernanceRoleSetting... roleSettings) {
            return roleSettings(Arrays.asList(roleSettings));
        }

        public PrivilegedAccess build() {
            PrivilegedAccess _x = new PrivilegedAccess();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.privilegedAccess";
            _x.id = id;
            _x.displayName = displayName;
            _x.resources = resources;
            _x.roleAssignmentRequests = roleAssignmentRequests;
            _x.roleAssignments = roleAssignments;
            _x.roleDefinitions = roleDefinitions;
            _x.roleSettings = roleSettings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public PrivilegedAccess withDisplayName(String displayName) {
        PrivilegedAccess _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedAccess");
        _x.displayName = displayName;
        return _x;
    }

    public PrivilegedAccess withUnmappedField(String name, Object value) {
        PrivilegedAccess _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="resources")
    @JsonIgnore
    public GovernanceResourceCollectionRequest getResources() {
        return new GovernanceResourceCollectionRequest(
                        contextPath.addSegment("resources"), Optional.ofNullable(resources));
    }

    @NavigationProperty(name="roleAssignmentRequests")
    @JsonIgnore
    public GovernanceRoleAssignmentRequestCollectionRequest getRoleAssignmentRequests() {
        return new GovernanceRoleAssignmentRequestCollectionRequest(
                        contextPath.addSegment("roleAssignmentRequests"), Optional.ofNullable(roleAssignmentRequests));
    }

    @NavigationProperty(name="roleAssignments")
    @JsonIgnore
    public GovernanceRoleAssignmentCollectionRequest getRoleAssignments() {
        return new GovernanceRoleAssignmentCollectionRequest(
                        contextPath.addSegment("roleAssignments"), Optional.ofNullable(roleAssignments));
    }

    @NavigationProperty(name="roleDefinitions")
    @JsonIgnore
    public GovernanceRoleDefinitionCollectionRequest getRoleDefinitions() {
        return new GovernanceRoleDefinitionCollectionRequest(
                        contextPath.addSegment("roleDefinitions"), Optional.ofNullable(roleDefinitions));
    }

    @NavigationProperty(name="roleSettings")
    @JsonIgnore
    public GovernanceRoleSettingCollectionRequest getRoleSettings() {
        return new GovernanceRoleSettingCollectionRequest(
                        contextPath.addSegment("roleSettings"), Optional.ofNullable(roleSettings));
    }

    public PrivilegedAccess withResources(List<GovernanceResource> resources) {
        PrivilegedAccess _x = _copy();
        _x.changedFields = changedFields.add("resources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedAccess");
        _x.resources = resources;
        return _x;
    }

    public PrivilegedAccess withRoleAssignmentRequests(List<GovernanceRoleAssignmentRequest> roleAssignmentRequests) {
        PrivilegedAccess _x = _copy();
        _x.changedFields = changedFields.add("roleAssignmentRequests");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedAccess");
        _x.roleAssignmentRequests = roleAssignmentRequests;
        return _x;
    }

    public PrivilegedAccess withRoleAssignments(List<GovernanceRoleAssignment> roleAssignments) {
        PrivilegedAccess _x = _copy();
        _x.changedFields = changedFields.add("roleAssignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedAccess");
        _x.roleAssignments = roleAssignments;
        return _x;
    }

    public PrivilegedAccess withRoleDefinitions(List<GovernanceRoleDefinition> roleDefinitions) {
        PrivilegedAccess _x = _copy();
        _x.changedFields = changedFields.add("roleDefinitions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedAccess");
        _x.roleDefinitions = roleDefinitions;
        return _x;
    }

    public PrivilegedAccess withRoleSettings(List<GovernanceRoleSetting> roleSettings) {
        PrivilegedAccess _x = _copy();
        _x.changedFields = changedFields.add("roleSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedAccess");
        _x.roleSettings = roleSettings;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrivilegedAccess patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrivilegedAccess _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrivilegedAccess put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrivilegedAccess _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrivilegedAccess _copy() {
        PrivilegedAccess _x = new PrivilegedAccess();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.resources = resources;
        _x.roleAssignmentRequests = roleAssignmentRequests;
        _x.roleAssignments = roleAssignments;
        _x.roleDefinitions = roleDefinitions;
        _x.roleSettings = roleSettings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrivilegedAccess[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("resources=");
        b.append(this.resources);
        b.append(", ");
        b.append("roleAssignmentRequests=");
        b.append(this.roleAssignmentRequests);
        b.append(", ");
        b.append("roleAssignments=");
        b.append(this.roleAssignments);
        b.append(", ");
        b.append("roleDefinitions=");
        b.append(this.roleDefinitions);
        b.append(", ");
        b.append("roleSettings=");
        b.append(this.roleSettings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
