package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.SubjectRightsRequestCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "subjectRightsRequests"})
@JsonInclude(Include.NON_NULL)
public class Privacy implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "microsoft.graph.privacy";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("subjectRightsRequests")
    protected List<SubjectRightsRequest> subjectRightsRequests;

    protected Privacy() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<SubjectRightsRequest> subjectRightsRequests;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder subjectRightsRequests(List<SubjectRightsRequest> subjectRightsRequests) {
            this.subjectRightsRequests = subjectRightsRequests;
            this.changedFields = changedFields.add("subjectRightsRequests");
            return this;
        }

        public Builder subjectRightsRequests(SubjectRightsRequest... subjectRightsRequests) {
            return subjectRightsRequests(Arrays.asList(subjectRightsRequests));
        }

        public Privacy build() {
            Privacy _x = new Privacy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.privacy";
            _x.subjectRightsRequests = subjectRightsRequests;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath) {
            contextPath = contextPath.clearQueries();
        }
    }

    public Privacy withUnmappedField(String name, Object value) {
        Privacy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="subjectRightsRequests")
    @JsonIgnore
    public SubjectRightsRequestCollectionRequest getSubjectRightsRequests() {
        return new SubjectRightsRequestCollectionRequest(
                        contextPath.addSegment("subjectRightsRequests"), Optional.ofNullable(subjectRightsRequests));
    }

    public Privacy withSubjectRightsRequests(List<SubjectRightsRequest> subjectRightsRequests) {
        Privacy _x = _copy();
        _x.changedFields = changedFields.add("subjectRightsRequests");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privacy");
        _x.subjectRightsRequests = subjectRightsRequests;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Privacy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Privacy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Privacy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Privacy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Privacy _copy() {
        Privacy _x = new Privacy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.subjectRightsRequests = subjectRightsRequests;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Privacy[");
        b.append("subjectRightsRequests=");
        b.append(this.subjectRightsRequests);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
