package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PrinterCapabilities;
import odata.msgraph.client.beta.complex.PrinterDefaults;
import odata.msgraph.client.beta.complex.PrinterLocation;
import odata.msgraph.client.beta.complex.PrinterStatus;
import odata.msgraph.client.beta.entity.collection.request.GroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserCollectionRequest;
import odata.msgraph.client.beta.entity.request.PrinterRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "allowAllUsers", 
    "createdDateTime"})
@JsonInclude(Include.NON_NULL)
public class PrinterShare extends PrinterBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printerShare";
    }

    @JsonProperty("allowAllUsers")
    protected Boolean allowAllUsers;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    protected PrinterShare() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrinterShare() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PrinterCapabilities capabilities;
        private PrinterDefaults defaults;
        private String displayName;
        private Boolean isAcceptingJobs;
        private PrinterLocation location;
        private String manufacturer;
        private String model;
        private String name;
        private PrinterStatus status;
        private List<PrintJob> jobs;
        private Boolean allowAllUsers;
        private OffsetDateTime createdDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder capabilities(PrinterCapabilities capabilities) {
            this.capabilities = capabilities;
            this.changedFields = changedFields.add("capabilities");
            return this;
        }

        public Builder defaults(PrinterDefaults defaults) {
            this.defaults = defaults;
            this.changedFields = changedFields.add("defaults");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isAcceptingJobs(Boolean isAcceptingJobs) {
            this.isAcceptingJobs = isAcceptingJobs;
            this.changedFields = changedFields.add("isAcceptingJobs");
            return this;
        }

        public Builder location(PrinterLocation location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder status(PrinterStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder jobs(List<PrintJob> jobs) {
            this.jobs = jobs;
            this.changedFields = changedFields.add("jobs");
            return this;
        }

        public Builder jobs(PrintJob... jobs) {
            return jobs(Arrays.asList(jobs));
        }

        public Builder allowAllUsers(Boolean allowAllUsers) {
            this.allowAllUsers = allowAllUsers;
            this.changedFields = changedFields.add("allowAllUsers");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public PrinterShare build() {
            PrinterShare _x = new PrinterShare();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printerShare";
            _x.id = id;
            _x.capabilities = capabilities;
            _x.defaults = defaults;
            _x.displayName = displayName;
            _x.isAcceptingJobs = isAcceptingJobs;
            _x.location = location;
            _x.manufacturer = manufacturer;
            _x.model = model;
            _x.name = name;
            _x.status = status;
            _x.jobs = jobs;
            _x.allowAllUsers = allowAllUsers;
            _x.createdDateTime = createdDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="allowAllUsers")
    @JsonIgnore
    public Optional<Boolean> getAllowAllUsers() {
        return Optional.ofNullable(allowAllUsers);
    }

    public PrinterShare withAllowAllUsers(Boolean allowAllUsers) {
        PrinterShare _x = _copy();
        _x.changedFields = changedFields.add("allowAllUsers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerShare");
        _x.allowAllUsers = allowAllUsers;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public PrinterShare withCreatedDateTime(OffsetDateTime createdDateTime) {
        PrinterShare _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerShare");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    public PrinterShare withUnmappedField(String name, Object value) {
        PrinterShare _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="allowedGroups")
    @JsonIgnore
    public GroupCollectionRequest getAllowedGroups() {
        return new GroupCollectionRequest(
                        contextPath.addSegment("allowedGroups"), RequestHelper.getValue(unmappedFields, "allowedGroups"));
    }

    @NavigationProperty(name="allowedUsers")
    @JsonIgnore
    public UserCollectionRequest getAllowedUsers() {
        return new UserCollectionRequest(
                        contextPath.addSegment("allowedUsers"), RequestHelper.getValue(unmappedFields, "allowedUsers"));
    }

    @NavigationProperty(name="printer")
    @JsonIgnore
    public PrinterRequest getPrinter() {
        return new PrinterRequest(contextPath.addSegment("printer"), RequestHelper.getValue(unmappedFields, "printer"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrinterShare patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrinterShare _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrinterShare put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrinterShare _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrinterShare _copy() {
        PrinterShare _x = new PrinterShare();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.capabilities = capabilities;
        _x.defaults = defaults;
        _x.displayName = displayName;
        _x.isAcceptingJobs = isAcceptingJobs;
        _x.location = location;
        _x.manufacturer = manufacturer;
        _x.model = model;
        _x.name = name;
        _x.status = status;
        _x.jobs = jobs;
        _x.allowAllUsers = allowAllUsers;
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrinterShare[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("capabilities=");
        b.append(this.capabilities);
        b.append(", ");
        b.append("defaults=");
        b.append(this.defaults);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isAcceptingJobs=");
        b.append(this.isAcceptingJobs);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("jobs=");
        b.append(this.jobs);
        b.append(", ");
        b.append("allowAllUsers=");
        b.append(this.allowAllUsers);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
