package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class PrintUsageByUser extends PrintUsage implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printUsageByUser";
    }

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected PrintUsageByUser() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrintUsageByUser() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Long completedBlackAndWhiteJobCount;
        private Long completedColorJobCount;
        private Long incompleteJobCount;
        private LocalDate usageDate;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder completedBlackAndWhiteJobCount(Long completedBlackAndWhiteJobCount) {
            this.completedBlackAndWhiteJobCount = completedBlackAndWhiteJobCount;
            this.changedFields = changedFields.add("completedBlackAndWhiteJobCount");
            return this;
        }

        public Builder completedColorJobCount(Long completedColorJobCount) {
            this.completedColorJobCount = completedColorJobCount;
            this.changedFields = changedFields.add("completedColorJobCount");
            return this;
        }

        public Builder incompleteJobCount(Long incompleteJobCount) {
            this.incompleteJobCount = incompleteJobCount;
            this.changedFields = changedFields.add("incompleteJobCount");
            return this;
        }

        public Builder usageDate(LocalDate usageDate) {
            this.usageDate = usageDate;
            this.changedFields = changedFields.add("usageDate");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public PrintUsageByUser build() {
            PrintUsageByUser _x = new PrintUsageByUser();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printUsageByUser";
            _x.id = id;
            _x.completedBlackAndWhiteJobCount = completedBlackAndWhiteJobCount;
            _x.completedColorJobCount = completedColorJobCount;
            _x.incompleteJobCount = incompleteJobCount;
            _x.usageDate = usageDate;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public PrintUsageByUser withUserPrincipalName(String userPrincipalName) {
        PrintUsageByUser _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printUsageByUser");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public PrintUsageByUser withUnmappedField(String name, Object value) {
        PrintUsageByUser _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintUsageByUser patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrintUsageByUser _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintUsageByUser put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrintUsageByUser _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrintUsageByUser _copy() {
        PrintUsageByUser _x = new PrintUsageByUser();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.completedBlackAndWhiteJobCount = completedBlackAndWhiteJobCount;
        _x.completedColorJobCount = completedColorJobCount;
        _x.incompleteJobCount = incompleteJobCount;
        _x.usageDate = usageDate;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintUsageByUser[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("completedBlackAndWhiteJobCount=");
        b.append(this.completedBlackAndWhiteJobCount);
        b.append(", ");
        b.append("completedColorJobCount=");
        b.append(this.completedColorJobCount);
        b.append(", ");
        b.append("incompleteJobCount=");
        b.append(this.incompleteJobCount);
        b.append(", ");
        b.append("usageDate=");
        b.append(this.usageDate);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
