package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "completedBlackAndWhiteJobCount", 
    "completedColorJobCount", 
    "incompleteJobCount", 
    "usageDate"})
@JsonInclude(Include.NON_NULL)
public class PrintUsage extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printUsage";
    }

    @JsonProperty("completedBlackAndWhiteJobCount")
    protected Long completedBlackAndWhiteJobCount;

    @JsonProperty("completedColorJobCount")
    protected Long completedColorJobCount;

    @JsonProperty("incompleteJobCount")
    protected Long incompleteJobCount;

    @JsonProperty("usageDate")
    protected LocalDate usageDate;

    protected PrintUsage() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="completedBlackAndWhiteJobCount")
    @JsonIgnore
    public Optional<Long> getCompletedBlackAndWhiteJobCount() {
        return Optional.ofNullable(completedBlackAndWhiteJobCount);
    }

    public PrintUsage withCompletedBlackAndWhiteJobCount(Long completedBlackAndWhiteJobCount) {
        PrintUsage _x = _copy();
        _x.changedFields = changedFields.add("completedBlackAndWhiteJobCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printUsage");
        _x.completedBlackAndWhiteJobCount = completedBlackAndWhiteJobCount;
        return _x;
    }

    @Property(name="completedColorJobCount")
    @JsonIgnore
    public Optional<Long> getCompletedColorJobCount() {
        return Optional.ofNullable(completedColorJobCount);
    }

    public PrintUsage withCompletedColorJobCount(Long completedColorJobCount) {
        PrintUsage _x = _copy();
        _x.changedFields = changedFields.add("completedColorJobCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printUsage");
        _x.completedColorJobCount = completedColorJobCount;
        return _x;
    }

    @Property(name="incompleteJobCount")
    @JsonIgnore
    public Optional<Long> getIncompleteJobCount() {
        return Optional.ofNullable(incompleteJobCount);
    }

    public PrintUsage withIncompleteJobCount(Long incompleteJobCount) {
        PrintUsage _x = _copy();
        _x.changedFields = changedFields.add("incompleteJobCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printUsage");
        _x.incompleteJobCount = incompleteJobCount;
        return _x;
    }

    @Property(name="usageDate")
    @JsonIgnore
    public Optional<LocalDate> getUsageDate() {
        return Optional.ofNullable(usageDate);
    }

    public PrintUsage withUsageDate(LocalDate usageDate) {
        PrintUsage _x = _copy();
        _x.changedFields = changedFields.add("usageDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printUsage");
        _x.usageDate = usageDate;
        return _x;
    }

    public PrintUsage withUnmappedField(String name, Object value) {
        PrintUsage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintUsage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrintUsage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintUsage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrintUsage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrintUsage _copy() {
        PrintUsage _x = new PrintUsage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.completedBlackAndWhiteJobCount = completedBlackAndWhiteJobCount;
        _x.completedColorJobCount = completedColorJobCount;
        _x.incompleteJobCount = incompleteJobCount;
        _x.usageDate = usageDate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintUsage[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("completedBlackAndWhiteJobCount=");
        b.append(this.completedBlackAndWhiteJobCount);
        b.append(", ");
        b.append("completedColorJobCount=");
        b.append(this.completedColorJobCount);
        b.append(", ");
        b.append("incompleteJobCount=");
        b.append(this.incompleteJobCount);
        b.append(", ");
        b.append("usageDate=");
        b.append(this.usageDate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
