package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PrintTaskStatus;
import odata.msgraph.client.beta.entity.request.PrintTaskDefinitionRequest;
import odata.msgraph.client.beta.entity.request.PrintTaskTriggerRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "parentUrl", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class PrintTask extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printTask";
    }

    @JsonProperty("parentUrl")
    protected String parentUrl;

    @JsonProperty("status")
    protected PrintTaskStatus status;

    protected PrintTask() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrintTask() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String parentUrl;
        private PrintTaskStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder parentUrl(String parentUrl) {
            this.parentUrl = parentUrl;
            this.changedFields = changedFields.add("parentUrl");
            return this;
        }

        public Builder status(PrintTaskStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public PrintTask build() {
            PrintTask _x = new PrintTask();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printTask";
            _x.id = id;
            _x.parentUrl = parentUrl;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="parentUrl")
    @JsonIgnore
    public Optional<String> getParentUrl() {
        return Optional.ofNullable(parentUrl);
    }

    public PrintTask withParentUrl(String parentUrl) {
        PrintTask _x = _copy();
        _x.changedFields = changedFields.add("parentUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printTask");
        _x.parentUrl = parentUrl;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<PrintTaskStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public PrintTask withStatus(PrintTaskStatus status) {
        PrintTask _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printTask");
        _x.status = status;
        return _x;
    }

    public PrintTask withUnmappedField(String name, Object value) {
        PrintTask _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="definition")
    @JsonIgnore
    public PrintTaskDefinitionRequest getDefinition() {
        return new PrintTaskDefinitionRequest(contextPath.addSegment("definition"), RequestHelper.getValue(unmappedFields, "definition"));
    }

    @NavigationProperty(name="trigger")
    @JsonIgnore
    public PrintTaskTriggerRequest getTrigger() {
        return new PrintTaskTriggerRequest(contextPath.addSegment("trigger"), RequestHelper.getValue(unmappedFields, "trigger"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintTask patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrintTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintTask put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrintTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrintTask _copy() {
        PrintTask _x = new PrintTask();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.parentUrl = parentUrl;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintTask[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("parentUrl=");
        b.append(this.parentUrl);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
