package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.PrintServiceEndpointCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "endpoints"})
@JsonInclude(Include.NON_NULL)
public class PrintService extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printService";
    }

    @JsonProperty("endpoints")
    protected List<PrintServiceEndpoint> endpoints;

    protected PrintService() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrintService() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<PrintServiceEndpoint> endpoints;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder endpoints(List<PrintServiceEndpoint> endpoints) {
            this.endpoints = endpoints;
            this.changedFields = changedFields.add("endpoints");
            return this;
        }

        public Builder endpoints(PrintServiceEndpoint... endpoints) {
            return endpoints(Arrays.asList(endpoints));
        }

        public PrintService build() {
            PrintService _x = new PrintService();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printService";
            _x.id = id;
            _x.endpoints = endpoints;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public PrintService withUnmappedField(String name, Object value) {
        PrintService _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="endpoints")
    @JsonIgnore
    public PrintServiceEndpointCollectionRequest getEndpoints() {
        return new PrintServiceEndpointCollectionRequest(
                        contextPath.addSegment("endpoints"), Optional.ofNullable(endpoints));
    }

    public PrintService withEndpoints(List<PrintServiceEndpoint> endpoints) {
        PrintService _x = _copy();
        _x.changedFields = changedFields.add("endpoints");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printService");
        _x.endpoints = endpoints;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintService patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrintService _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintService put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrintService _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrintService _copy() {
        PrintService _x = new PrintService();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.endpoints = endpoints;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintService[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("endpoints=");
        b.append(this.endpoints);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
