package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PrintJobConfiguration;
import odata.msgraph.client.beta.complex.PrintJobStatus;
import odata.msgraph.client.beta.complex.UserIdentity;
import odata.msgraph.client.beta.entity.collection.request.PrintDocumentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintTaskCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "configuration", 
    "createdBy", 
    "createdDateTime", 
    "isFetchable", 
    "redirectedFrom", 
    "redirectedTo", 
    "status", 
    "documents"})
@JsonInclude(Include.NON_NULL)
public class PrintJob extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printJob";
    }

    @JsonProperty("configuration")
    protected PrintJobConfiguration configuration;

    @JsonProperty("createdBy")
    protected UserIdentity createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("isFetchable")
    protected Boolean isFetchable;

    @JsonProperty("redirectedFrom")
    protected String redirectedFrom;

    @JsonProperty("redirectedTo")
    protected String redirectedTo;

    @JsonProperty("status")
    protected PrintJobStatus status;

    @JsonProperty("documents")
    protected List<PrintDocument> documents;

    protected PrintJob() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrintJob() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PrintJobConfiguration configuration;
        private UserIdentity createdBy;
        private OffsetDateTime createdDateTime;
        private Boolean isFetchable;
        private String redirectedFrom;
        private String redirectedTo;
        private PrintJobStatus status;
        private List<PrintDocument> documents;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder configuration(PrintJobConfiguration configuration) {
            this.configuration = configuration;
            this.changedFields = changedFields.add("configuration");
            return this;
        }

        public Builder createdBy(UserIdentity createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder isFetchable(Boolean isFetchable) {
            this.isFetchable = isFetchable;
            this.changedFields = changedFields.add("isFetchable");
            return this;
        }

        public Builder redirectedFrom(String redirectedFrom) {
            this.redirectedFrom = redirectedFrom;
            this.changedFields = changedFields.add("redirectedFrom");
            return this;
        }

        public Builder redirectedTo(String redirectedTo) {
            this.redirectedTo = redirectedTo;
            this.changedFields = changedFields.add("redirectedTo");
            return this;
        }

        public Builder status(PrintJobStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder documents(List<PrintDocument> documents) {
            this.documents = documents;
            this.changedFields = changedFields.add("documents");
            return this;
        }

        public Builder documents(PrintDocument... documents) {
            return documents(Arrays.asList(documents));
        }

        public PrintJob build() {
            PrintJob _x = new PrintJob();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printJob";
            _x.id = id;
            _x.configuration = configuration;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.isFetchable = isFetchable;
            _x.redirectedFrom = redirectedFrom;
            _x.redirectedTo = redirectedTo;
            _x.status = status;
            _x.documents = documents;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="configuration")
    @JsonIgnore
    public Optional<PrintJobConfiguration> getConfiguration() {
        return Optional.ofNullable(configuration);
    }

    public PrintJob withConfiguration(PrintJobConfiguration configuration) {
        PrintJob _x = _copy();
        _x.changedFields = changedFields.add("configuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJob");
        _x.configuration = configuration;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<UserIdentity> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public PrintJob withCreatedBy(UserIdentity createdBy) {
        PrintJob _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJob");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public PrintJob withCreatedDateTime(OffsetDateTime createdDateTime) {
        PrintJob _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJob");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="isFetchable")
    @JsonIgnore
    public Optional<Boolean> getIsFetchable() {
        return Optional.ofNullable(isFetchable);
    }

    public PrintJob withIsFetchable(Boolean isFetchable) {
        PrintJob _x = _copy();
        _x.changedFields = changedFields.add("isFetchable");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJob");
        _x.isFetchable = isFetchable;
        return _x;
    }

    @Property(name="redirectedFrom")
    @JsonIgnore
    public Optional<String> getRedirectedFrom() {
        return Optional.ofNullable(redirectedFrom);
    }

    public PrintJob withRedirectedFrom(String redirectedFrom) {
        PrintJob _x = _copy();
        _x.changedFields = changedFields.add("redirectedFrom");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJob");
        _x.redirectedFrom = redirectedFrom;
        return _x;
    }

    @Property(name="redirectedTo")
    @JsonIgnore
    public Optional<String> getRedirectedTo() {
        return Optional.ofNullable(redirectedTo);
    }

    public PrintJob withRedirectedTo(String redirectedTo) {
        PrintJob _x = _copy();
        _x.changedFields = changedFields.add("redirectedTo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJob");
        _x.redirectedTo = redirectedTo;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<PrintJobStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public PrintJob withStatus(PrintJobStatus status) {
        PrintJob _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJob");
        _x.status = status;
        return _x;
    }

    public PrintJob withUnmappedField(String name, Object value) {
        PrintJob _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="documents")
    @JsonIgnore
    public PrintDocumentCollectionRequest getDocuments() {
        return new PrintDocumentCollectionRequest(
                        contextPath.addSegment("documents"), Optional.ofNullable(documents));
    }

    @NavigationProperty(name="tasks")
    @JsonIgnore
    public PrintTaskCollectionRequest getTasks() {
        return new PrintTaskCollectionRequest(
                        contextPath.addSegment("tasks"), RequestHelper.getValue(unmappedFields, "tasks"));
    }

    public PrintJob withDocuments(List<PrintDocument> documents) {
        PrintJob _x = _copy();
        _x.changedFields = changedFields.add("documents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJob");
        _x.documents = documents;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintJob patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrintJob _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintJob put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrintJob _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrintJob _copy() {
        PrintJob _x = new PrintJob();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.configuration = configuration;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.isFetchable = isFetchable;
        _x.redirectedFrom = redirectedFrom;
        _x.redirectedTo = redirectedTo;
        _x.status = status;
        _x.documents = documents;
        return _x;
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

    @Action(name = "start")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrintJobStatus> start() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<PrintJobStatus>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.start"), PrintJobStatus.class, _parameters);
    }

    @Action(name = "abort")
    @JsonIgnore
    public ActionRequestNoReturn abort(String reason) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("reason", "Edm.String", Checks.checkIsAscii(reason))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.abort"), _parameters);
    }

    @Action(name = "cancelPrintJob")
    @JsonIgnore
    public ActionRequestNoReturn cancelPrintJob() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancelPrintJob"), _parameters);
    }

    @Action(name = "redirect")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrintJob> redirect(String destinationPrinterId, PrintJobConfiguration configuration) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("destinationPrinterId", "Edm.String", Checks.checkIsAscii(destinationPrinterId))
            .put("configuration", "microsoft.graph.printJobConfiguration", configuration)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PrintJob>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.redirect"), PrintJob.class, _parameters);
    }

    @Action(name = "startPrintJob")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrintJobStatus> startPrintJob() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<PrintJobStatus>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.startPrintJob"), PrintJobStatus.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintJob[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("configuration=");
        b.append(this.configuration);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("isFetchable=");
        b.append(this.isFetchable);
        b.append(", ");
        b.append("redirectedFrom=");
        b.append(this.redirectedFrom);
        b.append(", ");
        b.append("redirectedTo=");
        b.append(this.redirectedTo);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("documents=");
        b.append(this.documents);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
