package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ErrorCode;
import odata.msgraph.client.beta.enums.PolicySetStatus;


/**
 * <i>“A class containing the properties used for PolicySet Item.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "displayName", 
    "errorCode", 
    "guidedDeploymentTags", 
    "itemType", 
    "lastModifiedDateTime", 
    "payloadId", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class PolicySetItem extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.policySetItem";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("errorCode")
    protected ErrorCode errorCode;

    @JsonProperty("guidedDeploymentTags")
    protected List<String> guidedDeploymentTags;

    @JsonProperty("guidedDeploymentTags@nextLink")
    protected String guidedDeploymentTagsNextLink;

    @JsonProperty("itemType")
    protected String itemType;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("payloadId")
    protected String payloadId;

    @JsonProperty("status")
    protected PolicySetStatus status;

    protected PolicySetItem() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Creation time of the PolicySetItem.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Creation time of the PolicySetItem.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public PolicySetItem withCreatedDateTime(OffsetDateTime createdDateTime) {
        PolicySetItem _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySetItem");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“DisplayName of the PolicySetItem.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“DisplayName of the PolicySetItem.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public PolicySetItem withDisplayName(String displayName) {
        PolicySetItem _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySetItem");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Error code if any occured.”</i>
     * 
     * @return property errorCode
     */
    @Property(name="errorCode")
    @JsonIgnore
    public Optional<ErrorCode> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Error code if any occured.”</i>
     * 
     * @param errorCode
     *            new value of {@code errorCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCode} field changed
     */
    public PolicySetItem withErrorCode(ErrorCode errorCode) {
        PolicySetItem _x = _copy();
        _x.changedFields = changedFields.add("errorCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySetItem");
        _x.errorCode = errorCode;
        return _x;
    }

    /**
     * <i>“Tags of the guided deployment”</i>
     * 
     * @return property guidedDeploymentTags
     */
    @Property(name="guidedDeploymentTags")
    @JsonIgnore
    public CollectionPage<String> getGuidedDeploymentTags() {
        return new CollectionPage<String>(contextPath, String.class, this.guidedDeploymentTags, Optional.ofNullable(guidedDeploymentTagsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * guidedDeploymentTags} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Tags of the guided deployment”</i>
     * 
     * @param guidedDeploymentTags
     *            new value of {@code guidedDeploymentTags} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code guidedDeploymentTags} field changed
     */
    public PolicySetItem withGuidedDeploymentTags(List<String> guidedDeploymentTags) {
        PolicySetItem _x = _copy();
        _x.changedFields = changedFields.add("guidedDeploymentTags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySetItem");
        _x.guidedDeploymentTags = guidedDeploymentTags;
        return _x;
    }

    /**
     * <i>“Tags of the guided deployment”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property guidedDeploymentTags
     */
    @Property(name="guidedDeploymentTags")
    @JsonIgnore
    public CollectionPage<String> getGuidedDeploymentTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.guidedDeploymentTags, Optional.ofNullable(guidedDeploymentTagsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“policySetType of the PolicySetItem.”</i>
     * 
     * @return property itemType
     */
    @Property(name="itemType")
    @JsonIgnore
    public Optional<String> getItemType() {
        return Optional.ofNullable(itemType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code itemType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“policySetType of the PolicySetItem.”</i>
     * 
     * @param itemType
     *            new value of {@code itemType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code itemType} field changed
     */
    public PolicySetItem withItemType(String itemType) {
        PolicySetItem _x = _copy();
        _x.changedFields = changedFields.add("itemType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySetItem");
        _x.itemType = itemType;
        return _x;
    }

    /**
     * <i>“Last modified time of the PolicySetItem.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last modified time of the PolicySetItem.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public PolicySetItem withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        PolicySetItem _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySetItem");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“PayloadId of the PolicySetItem.”</i>
     * 
     * @return property payloadId
     */
    @Property(name="payloadId")
    @JsonIgnore
    public Optional<String> getPayloadId() {
        return Optional.ofNullable(payloadId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code payloadId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“PayloadId of the PolicySetItem.”</i>
     * 
     * @param payloadId
     *            new value of {@code payloadId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code payloadId} field changed
     */
    public PolicySetItem withPayloadId(String payloadId) {
        PolicySetItem _x = _copy();
        _x.changedFields = changedFields.add("payloadId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySetItem");
        _x.payloadId = payloadId;
        return _x;
    }

    /**
     * <i>“Status of the PolicySetItem.”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<PolicySetStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Status of the PolicySetItem.”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public PolicySetItem withStatus(PolicySetStatus status) {
        PolicySetItem _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySetItem");
        _x.status = status;
        return _x;
    }

    public PolicySetItem withUnmappedField(String name, Object value) {
        PolicySetItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PolicySetItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PolicySetItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PolicySetItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PolicySetItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PolicySetItem _copy() {
        PolicySetItem _x = new PolicySetItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.errorCode = errorCode;
        _x.guidedDeploymentTags = guidedDeploymentTags;
        _x.itemType = itemType;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.payloadId = payloadId;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PolicySetItem[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("guidedDeploymentTags=");
        b.append(this.guidedDeploymentTags);
        b.append(", ");
        b.append("itemType=");
        b.append(this.itemType);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("payloadId=");
        b.append(this.payloadId);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
