package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AuthenticationMethodSignInState;
import odata.msgraph.client.beta.enums.AuthenticationPhoneType;

@JsonPropertyOrder({
    "@odata.type", 
    "phoneNumber", 
    "phoneType", 
    "smsSignInState"})
@JsonInclude(Include.NON_NULL)
public class PhoneAuthenticationMethod extends AuthenticationMethod implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.phoneAuthenticationMethod";
    }

    @JsonProperty("phoneNumber")
    protected String phoneNumber;

    @JsonProperty("phoneType")
    protected AuthenticationPhoneType phoneType;

    @JsonProperty("smsSignInState")
    protected AuthenticationMethodSignInState smsSignInState;

    protected PhoneAuthenticationMethod() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPhoneAuthenticationMethod() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String phoneNumber;
        private AuthenticationPhoneType phoneType;
        private AuthenticationMethodSignInState smsSignInState;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            this.changedFields = changedFields.add("phoneNumber");
            return this;
        }

        public Builder phoneType(AuthenticationPhoneType phoneType) {
            this.phoneType = phoneType;
            this.changedFields = changedFields.add("phoneType");
            return this;
        }

        public Builder smsSignInState(AuthenticationMethodSignInState smsSignInState) {
            this.smsSignInState = smsSignInState;
            this.changedFields = changedFields.add("smsSignInState");
            return this;
        }

        public PhoneAuthenticationMethod build() {
            PhoneAuthenticationMethod _x = new PhoneAuthenticationMethod();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.phoneAuthenticationMethod";
            _x.id = id;
            _x.phoneNumber = phoneNumber;
            _x.phoneType = phoneType;
            _x.smsSignInState = smsSignInState;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="phoneNumber")
    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        return Optional.ofNullable(phoneNumber);
    }

    public PhoneAuthenticationMethod withPhoneNumber(String phoneNumber) {
        PhoneAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("phoneNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.phoneAuthenticationMethod");
        _x.phoneNumber = phoneNumber;
        return _x;
    }

    @Property(name="phoneType")
    @JsonIgnore
    public Optional<AuthenticationPhoneType> getPhoneType() {
        return Optional.ofNullable(phoneType);
    }

    public PhoneAuthenticationMethod withPhoneType(AuthenticationPhoneType phoneType) {
        PhoneAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("phoneType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.phoneAuthenticationMethod");
        _x.phoneType = phoneType;
        return _x;
    }

    @Property(name="smsSignInState")
    @JsonIgnore
    public Optional<AuthenticationMethodSignInState> getSmsSignInState() {
        return Optional.ofNullable(smsSignInState);
    }

    public PhoneAuthenticationMethod withSmsSignInState(AuthenticationMethodSignInState smsSignInState) {
        PhoneAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("smsSignInState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.phoneAuthenticationMethod");
        _x.smsSignInState = smsSignInState;
        return _x;
    }

    public PhoneAuthenticationMethod withUnmappedField(String name, Object value) {
        PhoneAuthenticationMethod _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PhoneAuthenticationMethod patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PhoneAuthenticationMethod _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PhoneAuthenticationMethod put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PhoneAuthenticationMethod _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PhoneAuthenticationMethod _copy() {
        PhoneAuthenticationMethod _x = new PhoneAuthenticationMethod();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.phoneNumber = phoneNumber;
        _x.phoneType = phoneType;
        _x.smsSignInState = smsSignInState;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PhoneAuthenticationMethod[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("phoneNumber=");
        b.append(this.phoneNumber);
        b.append(", ");
        b.append("phoneType=");
        b.append(this.phoneType);
        b.append(", ");
        b.append("smsSignInState=");
        b.append(this.smsSignInState);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
