package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.InferenceData;
import odata.msgraph.client.beta.complex.PersonDataSources;
import odata.msgraph.client.beta.enums.AllowedAudiences;

@JsonPropertyOrder({
    "@odata.type", 
    "certificationId", 
    "description", 
    "displayName", 
    "endDate", 
    "issuedDate", 
    "issuingAuthority", 
    "issuingCompany", 
    "startDate", 
    "thumbnailUrl", 
    "webUrl"})
@JsonInclude(Include.NON_NULL)
public class PersonCertification extends ItemFacet implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.personCertification";
    }

    @JsonProperty("certificationId")
    protected String certificationId;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("endDate")
    protected LocalDate endDate;

    @JsonProperty("issuedDate")
    protected LocalDate issuedDate;

    @JsonProperty("issuingAuthority")
    protected String issuingAuthority;

    @JsonProperty("issuingCompany")
    protected String issuingCompany;

    @JsonProperty("startDate")
    protected LocalDate startDate;

    @JsonProperty("thumbnailUrl")
    protected String thumbnailUrl;

    @JsonProperty("webUrl")
    protected String webUrl;

    protected PersonCertification() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPersonCertification() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AllowedAudiences allowedAudiences;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private InferenceData inference;
        private Boolean isSearchable;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private PersonDataSources source;
        private String certificationId;
        private String description;
        private String displayName;
        private LocalDate endDate;
        private LocalDate issuedDate;
        private String issuingAuthority;
        private String issuingCompany;
        private LocalDate startDate;
        private String thumbnailUrl;
        private String webUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder allowedAudiences(AllowedAudiences allowedAudiences) {
            this.allowedAudiences = allowedAudiences;
            this.changedFields = changedFields.add("allowedAudiences");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder inference(InferenceData inference) {
            this.inference = inference;
            this.changedFields = changedFields.add("inference");
            return this;
        }

        public Builder isSearchable(Boolean isSearchable) {
            this.isSearchable = isSearchable;
            this.changedFields = changedFields.add("isSearchable");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder source(PersonDataSources source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder certificationId(String certificationId) {
            this.certificationId = certificationId;
            this.changedFields = changedFields.add("certificationId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            this.endDate = endDate;
            this.changedFields = changedFields.add("endDate");
            return this;
        }

        public Builder issuedDate(LocalDate issuedDate) {
            this.issuedDate = issuedDate;
            this.changedFields = changedFields.add("issuedDate");
            return this;
        }

        public Builder issuingAuthority(String issuingAuthority) {
            this.issuingAuthority = issuingAuthority;
            this.changedFields = changedFields.add("issuingAuthority");
            return this;
        }

        public Builder issuingCompany(String issuingCompany) {
            this.issuingCompany = issuingCompany;
            this.changedFields = changedFields.add("issuingCompany");
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            this.startDate = startDate;
            this.changedFields = changedFields.add("startDate");
            return this;
        }

        public Builder thumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            this.changedFields = changedFields.add("thumbnailUrl");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public PersonCertification build() {
            PersonCertification _x = new PersonCertification();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.personCertification";
            _x.id = id;
            _x.allowedAudiences = allowedAudiences;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.inference = inference;
            _x.isSearchable = isSearchable;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.source = source;
            _x.certificationId = certificationId;
            _x.description = description;
            _x.displayName = displayName;
            _x.endDate = endDate;
            _x.issuedDate = issuedDate;
            _x.issuingAuthority = issuingAuthority;
            _x.issuingCompany = issuingCompany;
            _x.startDate = startDate;
            _x.thumbnailUrl = thumbnailUrl;
            _x.webUrl = webUrl;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="certificationId")
    @JsonIgnore
    public Optional<String> getCertificationId() {
        return Optional.ofNullable(certificationId);
    }

    public PersonCertification withCertificationId(String certificationId) {
        PersonCertification _x = _copy();
        _x.changedFields = changedFields.add("certificationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personCertification");
        _x.certificationId = certificationId;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public PersonCertification withDescription(String description) {
        PersonCertification _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personCertification");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public PersonCertification withDisplayName(String displayName) {
        PersonCertification _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personCertification");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="endDate")
    @JsonIgnore
    public Optional<LocalDate> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    public PersonCertification withEndDate(LocalDate endDate) {
        PersonCertification _x = _copy();
        _x.changedFields = changedFields.add("endDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personCertification");
        _x.endDate = endDate;
        return _x;
    }

    @Property(name="issuedDate")
    @JsonIgnore
    public Optional<LocalDate> getIssuedDate() {
        return Optional.ofNullable(issuedDate);
    }

    public PersonCertification withIssuedDate(LocalDate issuedDate) {
        PersonCertification _x = _copy();
        _x.changedFields = changedFields.add("issuedDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personCertification");
        _x.issuedDate = issuedDate;
        return _x;
    }

    @Property(name="issuingAuthority")
    @JsonIgnore
    public Optional<String> getIssuingAuthority() {
        return Optional.ofNullable(issuingAuthority);
    }

    public PersonCertification withIssuingAuthority(String issuingAuthority) {
        PersonCertification _x = _copy();
        _x.changedFields = changedFields.add("issuingAuthority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personCertification");
        _x.issuingAuthority = issuingAuthority;
        return _x;
    }

    @Property(name="issuingCompany")
    @JsonIgnore
    public Optional<String> getIssuingCompany() {
        return Optional.ofNullable(issuingCompany);
    }

    public PersonCertification withIssuingCompany(String issuingCompany) {
        PersonCertification _x = _copy();
        _x.changedFields = changedFields.add("issuingCompany");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personCertification");
        _x.issuingCompany = issuingCompany;
        return _x;
    }

    @Property(name="startDate")
    @JsonIgnore
    public Optional<LocalDate> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    public PersonCertification withStartDate(LocalDate startDate) {
        PersonCertification _x = _copy();
        _x.changedFields = changedFields.add("startDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personCertification");
        _x.startDate = startDate;
        return _x;
    }

    @Property(name="thumbnailUrl")
    @JsonIgnore
    public Optional<String> getThumbnailUrl() {
        return Optional.ofNullable(thumbnailUrl);
    }

    public PersonCertification withThumbnailUrl(String thumbnailUrl) {
        PersonCertification _x = _copy();
        _x.changedFields = changedFields.add("thumbnailUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personCertification");
        _x.thumbnailUrl = thumbnailUrl;
        return _x;
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public PersonCertification withWebUrl(String webUrl) {
        PersonCertification _x = _copy();
        _x.changedFields = changedFields.add("webUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personCertification");
        _x.webUrl = webUrl;
        return _x;
    }

    public PersonCertification withUnmappedField(String name, Object value) {
        PersonCertification _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PersonCertification patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PersonCertification _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PersonCertification put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PersonCertification _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PersonCertification _copy() {
        PersonCertification _x = new PersonCertification();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.allowedAudiences = allowedAudiences;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.inference = inference;
        _x.isSearchable = isSearchable;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.source = source;
        _x.certificationId = certificationId;
        _x.description = description;
        _x.displayName = displayName;
        _x.endDate = endDate;
        _x.issuedDate = issuedDate;
        _x.issuingAuthority = issuingAuthority;
        _x.issuingCompany = issuingCompany;
        _x.startDate = startDate;
        _x.thumbnailUrl = thumbnailUrl;
        _x.webUrl = webUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PersonCertification[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("allowedAudiences=");
        b.append(this.allowedAudiences);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("inference=");
        b.append(this.inference);
        b.append(", ");
        b.append("isSearchable=");
        b.append(this.isSearchable);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("certificationId=");
        b.append(this.certificationId);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("endDate=");
        b.append(this.endDate);
        b.append(", ");
        b.append("issuedDate=");
        b.append(this.issuedDate);
        b.append(", ");
        b.append("issuingAuthority=");
        b.append(this.issuingAuthority);
        b.append(", ");
        b.append("issuingCompany=");
        b.append(this.issuingCompany);
        b.append(", ");
        b.append("startDate=");
        b.append(this.startDate);
        b.append(", ");
        b.append("thumbnailUrl=");
        b.append(this.thumbnailUrl);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
