package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.InferenceData;
import odata.msgraph.client.beta.complex.PersonDataSources;
import odata.msgraph.client.beta.enums.AllowedAudiences;
import odata.msgraph.client.beta.enums.PersonAnnualEventType;

@JsonPropertyOrder({
    "@odata.type", 
    "date", 
    "displayName", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class PersonAnnualEvent extends ItemFacet implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.personAnnualEvent";
    }

    @JsonProperty("date")
    protected LocalDate date;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("type")
    protected PersonAnnualEventType type;

    protected PersonAnnualEvent() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPersonAnnualEvent() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AllowedAudiences allowedAudiences;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private InferenceData inference;
        private Boolean isSearchable;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private PersonDataSources source;
        private LocalDate date;
        private String displayName;
        private PersonAnnualEventType type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder allowedAudiences(AllowedAudiences allowedAudiences) {
            this.allowedAudiences = allowedAudiences;
            this.changedFields = changedFields.add("allowedAudiences");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder inference(InferenceData inference) {
            this.inference = inference;
            this.changedFields = changedFields.add("inference");
            return this;
        }

        public Builder isSearchable(Boolean isSearchable) {
            this.isSearchable = isSearchable;
            this.changedFields = changedFields.add("isSearchable");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder source(PersonDataSources source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder date(LocalDate date) {
            this.date = date;
            this.changedFields = changedFields.add("date");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder type(PersonAnnualEventType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public PersonAnnualEvent build() {
            PersonAnnualEvent _x = new PersonAnnualEvent();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.personAnnualEvent";
            _x.id = id;
            _x.allowedAudiences = allowedAudiences;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.inference = inference;
            _x.isSearchable = isSearchable;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.source = source;
            _x.date = date;
            _x.displayName = displayName;
            _x.type = type;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="date")
    @JsonIgnore
    public Optional<LocalDate> getDate() {
        return Optional.ofNullable(date);
    }

    public PersonAnnualEvent withDate(LocalDate date) {
        PersonAnnualEvent _x = _copy();
        _x.changedFields = changedFields.add("date");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personAnnualEvent");
        _x.date = date;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public PersonAnnualEvent withDisplayName(String displayName) {
        PersonAnnualEvent _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personAnnualEvent");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<PersonAnnualEventType> getType() {
        return Optional.ofNullable(type);
    }

    public PersonAnnualEvent withType(PersonAnnualEventType type) {
        PersonAnnualEvent _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personAnnualEvent");
        _x.type = type;
        return _x;
    }

    public PersonAnnualEvent withUnmappedField(String name, Object value) {
        PersonAnnualEvent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PersonAnnualEvent patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PersonAnnualEvent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PersonAnnualEvent put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PersonAnnualEvent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PersonAnnualEvent _copy() {
        PersonAnnualEvent _x = new PersonAnnualEvent();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.allowedAudiences = allowedAudiences;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.inference = inference;
        _x.isSearchable = isSearchable;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.source = source;
        _x.date = date;
        _x.displayName = displayName;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PersonAnnualEvent[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("allowedAudiences=");
        b.append(this.allowedAudiences);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("inference=");
        b.append(this.inference);
        b.append(", ");
        b.append("isSearchable=");
        b.append(this.isSearchable);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("date=");
        b.append(this.date);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
