package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.PermissionGrantConditionSetCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "excludes", 
    "includes"})
@JsonInclude(Include.NON_NULL)
public class PermissionGrantPolicy extends PolicyBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.permissionGrantPolicy";
    }

    @JsonProperty("excludes")
    protected List<PermissionGrantConditionSet> excludes;

    @JsonProperty("includes")
    protected List<PermissionGrantConditionSet> includes;

    protected PermissionGrantPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPermissionGrantPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private String description;
        private String displayName;
        private List<PermissionGrantConditionSet> excludes;
        private List<PermissionGrantConditionSet> includes;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder excludes(List<PermissionGrantConditionSet> excludes) {
            this.excludes = excludes;
            this.changedFields = changedFields.add("excludes");
            return this;
        }

        public Builder excludes(PermissionGrantConditionSet... excludes) {
            return excludes(Arrays.asList(excludes));
        }

        public Builder includes(List<PermissionGrantConditionSet> includes) {
            this.includes = includes;
            this.changedFields = changedFields.add("includes");
            return this;
        }

        public Builder includes(PermissionGrantConditionSet... includes) {
            return includes(Arrays.asList(includes));
        }

        public PermissionGrantPolicy build() {
            PermissionGrantPolicy _x = new PermissionGrantPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.permissionGrantPolicy";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.excludes = excludes;
            _x.includes = includes;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public PermissionGrantPolicy withUnmappedField(String name, Object value) {
        PermissionGrantPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="excludes")
    @JsonIgnore
    public PermissionGrantConditionSetCollectionRequest getExcludes() {
        return new PermissionGrantConditionSetCollectionRequest(
                        contextPath.addSegment("excludes"), Optional.ofNullable(excludes));
    }

    @NavigationProperty(name="includes")
    @JsonIgnore
    public PermissionGrantConditionSetCollectionRequest getIncludes() {
        return new PermissionGrantConditionSetCollectionRequest(
                        contextPath.addSegment("includes"), Optional.ofNullable(includes));
    }

    public PermissionGrantPolicy withExcludes(List<PermissionGrantConditionSet> excludes) {
        PermissionGrantPolicy _x = _copy();
        _x.changedFields = changedFields.add("excludes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permissionGrantPolicy");
        _x.excludes = excludes;
        return _x;
    }

    public PermissionGrantPolicy withIncludes(List<PermissionGrantConditionSet> includes) {
        PermissionGrantPolicy _x = _copy();
        _x.changedFields = changedFields.add("includes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permissionGrantPolicy");
        _x.includes = includes;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PermissionGrantPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PermissionGrantPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PermissionGrantPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PermissionGrantPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PermissionGrantPolicy _copy() {
        PermissionGrantPolicy _x = new PermissionGrantPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.excludes = excludes;
        _x.includes = includes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PermissionGrantPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("excludes=");
        b.append(this.excludes);
        b.append(", ");
        b.append("includes=");
        b.append(this.includes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
