package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.DeviceRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "creationDateTime", 
    "displayName", 
    "device"})
@JsonInclude(Include.NON_NULL)
public class PasswordlessMicrosoftAuthenticatorAuthenticationMethod extends AuthenticationMethod implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.passwordlessMicrosoftAuthenticatorAuthenticationMethod";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("creationDateTime")
    protected OffsetDateTime creationDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("device")
    protected Device device;

    protected PasswordlessMicrosoftAuthenticatorAuthenticationMethod() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPasswordlessMicrosoftAuthenticatorAuthenticationMethod() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime creationDateTime;
        private String displayName;
        private Device device;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param creationDateTime
         *            value of {@code creationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder creationDateTime(OffsetDateTime creationDateTime) {
            this.creationDateTime = creationDateTime;
            this.changedFields = changedFields.add("creationDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder device(Device device) {
            this.device = device;
            this.changedFields = changedFields.add("device");
            return this;
        }

        public PasswordlessMicrosoftAuthenticatorAuthenticationMethod build() {
            PasswordlessMicrosoftAuthenticatorAuthenticationMethod _x = new PasswordlessMicrosoftAuthenticatorAuthenticationMethod();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.passwordlessMicrosoftAuthenticatorAuthenticationMethod";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.creationDateTime = creationDateTime;
            _x.displayName = displayName;
            _x.device = device;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public PasswordlessMicrosoftAuthenticatorAuthenticationMethod withCreatedDateTime(OffsetDateTime createdDateTime) {
        PasswordlessMicrosoftAuthenticatorAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordlessMicrosoftAuthenticatorAuthenticationMethod");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @return property creationDateTime
     */
    @Property(name="creationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreationDateTime() {
        return Optional.ofNullable(creationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code creationDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @param creationDateTime
     *            new value of {@code creationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code creationDateTime} field changed
     */
    public PasswordlessMicrosoftAuthenticatorAuthenticationMethod withCreationDateTime(OffsetDateTime creationDateTime) {
        PasswordlessMicrosoftAuthenticatorAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("creationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordlessMicrosoftAuthenticatorAuthenticationMethod");
        _x.creationDateTime = creationDateTime;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public PasswordlessMicrosoftAuthenticatorAuthenticationMethod withDisplayName(String displayName) {
        PasswordlessMicrosoftAuthenticatorAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordlessMicrosoftAuthenticatorAuthenticationMethod");
        _x.displayName = displayName;
        return _x;
    }

    public PasswordlessMicrosoftAuthenticatorAuthenticationMethod withUnmappedField(String name, Object value) {
        PasswordlessMicrosoftAuthenticatorAuthenticationMethod _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="device")
    @JsonIgnore
    public DeviceRequest getDevice() {
        return new DeviceRequest(contextPath.addSegment("device"), Optional.ofNullable(device));
    }

    public PasswordlessMicrosoftAuthenticatorAuthenticationMethod withDevice(Device device) {
        PasswordlessMicrosoftAuthenticatorAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("device");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordlessMicrosoftAuthenticatorAuthenticationMethod");
        _x.device = device;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PasswordlessMicrosoftAuthenticatorAuthenticationMethod patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PasswordlessMicrosoftAuthenticatorAuthenticationMethod _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PasswordlessMicrosoftAuthenticatorAuthenticationMethod put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PasswordlessMicrosoftAuthenticatorAuthenticationMethod _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PasswordlessMicrosoftAuthenticatorAuthenticationMethod _copy() {
        PasswordlessMicrosoftAuthenticatorAuthenticationMethod _x = new PasswordlessMicrosoftAuthenticatorAuthenticationMethod();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.creationDateTime = creationDateTime;
        _x.displayName = displayName;
        _x.device = device;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PasswordlessMicrosoftAuthenticatorAuthenticationMethod[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("creationDateTime=");
        b.append(this.creationDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("device=");
        b.append(this.device);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
