package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.CallRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "call"})
@JsonInclude(Include.NON_NULL)
public class ParticipantJoiningNotification extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.participantJoiningNotification";
    }

    @JsonProperty("call")
    protected Call call;

    protected ParticipantJoiningNotification() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderParticipantJoiningNotification() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Call call;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder call(Call call) {
            this.call = call;
            this.changedFields = changedFields.add("call");
            return this;
        }

        public ParticipantJoiningNotification build() {
            ParticipantJoiningNotification _x = new ParticipantJoiningNotification();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.participantJoiningNotification";
            _x.id = id;
            _x.call = call;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public ParticipantJoiningNotification withUnmappedField(String name, Object value) {
        ParticipantJoiningNotification _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="call")
    @JsonIgnore
    public CallRequest getCall() {
        return new CallRequest(contextPath.addSegment("call"), Optional.ofNullable(call));
    }

    public ParticipantJoiningNotification withCall(Call call) {
        ParticipantJoiningNotification _x = _copy();
        _x.changedFields = changedFields.add("call");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.participantJoiningNotification");
        _x.call = call;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ParticipantJoiningNotification patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ParticipantJoiningNotification _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ParticipantJoiningNotification put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ParticipantJoiningNotification _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ParticipantJoiningNotification _copy() {
        ParticipantJoiningNotification _x = new ParticipantJoiningNotification();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.call = call;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ParticipantJoiningNotification[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("call=");
        b.append(this.call);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
