package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.entity.collection.request.OutlookTaskFolderCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "changeKey", 
    "groupKey", 
    "isDefaultGroup", 
    "name", 
    "taskFolders"})
@JsonInclude(Include.NON_NULL)
public class OutlookTaskGroup extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.outlookTaskGroup";
    }

    @JsonProperty("changeKey")
    protected String changeKey;

    @JsonProperty("groupKey")
    protected UUID groupKey;

    @JsonProperty("isDefaultGroup")
    protected Boolean isDefaultGroup;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("taskFolders")
    protected List<OutlookTaskFolder> taskFolders;

    protected OutlookTaskGroup() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOutlookTaskGroup() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String changeKey;
        private UUID groupKey;
        private Boolean isDefaultGroup;
        private String name;
        private List<OutlookTaskFolder> taskFolders;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder changeKey(String changeKey) {
            this.changeKey = changeKey;
            this.changedFields = changedFields.add("changeKey");
            return this;
        }

        public Builder groupKey(UUID groupKey) {
            this.groupKey = groupKey;
            this.changedFields = changedFields.add("groupKey");
            return this;
        }

        public Builder isDefaultGroup(Boolean isDefaultGroup) {
            this.isDefaultGroup = isDefaultGroup;
            this.changedFields = changedFields.add("isDefaultGroup");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param taskFolders
         *            value of {@code taskFolders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder taskFolders(List<OutlookTaskFolder> taskFolders) {
            this.taskFolders = taskFolders;
            this.changedFields = changedFields.add("taskFolders");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param taskFolders
         *            value of {@code taskFolders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder taskFolders(OutlookTaskFolder... taskFolders) {
            return taskFolders(Arrays.asList(taskFolders));
        }

        public OutlookTaskGroup build() {
            OutlookTaskGroup _x = new OutlookTaskGroup();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.outlookTaskGroup";
            _x.id = id;
            _x.changeKey = changeKey;
            _x.groupKey = groupKey;
            _x.isDefaultGroup = isDefaultGroup;
            _x.name = name;
            _x.taskFolders = taskFolders;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="changeKey")
    @JsonIgnore
    public Optional<String> getChangeKey() {
        return Optional.ofNullable(changeKey);
    }

    public OutlookTaskGroup withChangeKey(String changeKey) {
        OutlookTaskGroup _x = _copy();
        _x.changedFields = changedFields.add("changeKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTaskGroup");
        _x.changeKey = changeKey;
        return _x;
    }

    @Property(name="groupKey")
    @JsonIgnore
    public Optional<UUID> getGroupKey() {
        return Optional.ofNullable(groupKey);
    }

    public OutlookTaskGroup withGroupKey(UUID groupKey) {
        OutlookTaskGroup _x = _copy();
        _x.changedFields = changedFields.add("groupKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTaskGroup");
        _x.groupKey = groupKey;
        return _x;
    }

    @Property(name="isDefaultGroup")
    @JsonIgnore
    public Optional<Boolean> getIsDefaultGroup() {
        return Optional.ofNullable(isDefaultGroup);
    }

    public OutlookTaskGroup withIsDefaultGroup(Boolean isDefaultGroup) {
        OutlookTaskGroup _x = _copy();
        _x.changedFields = changedFields.add("isDefaultGroup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTaskGroup");
        _x.isDefaultGroup = isDefaultGroup;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public OutlookTaskGroup withName(String name) {
        OutlookTaskGroup _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTaskGroup");
        _x.name = name;
        return _x;
    }

    public OutlookTaskGroup withUnmappedField(String name, Object value) {
        OutlookTaskGroup _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property taskFolders
     */
    @NavigationProperty(name="taskFolders")
    @JsonIgnore
    public OutlookTaskFolderCollectionRequest getTaskFolders() {
        return new OutlookTaskFolderCollectionRequest(
                        contextPath.addSegment("taskFolders"), Optional.ofNullable(taskFolders));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code taskFolders}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param taskFolders
     *            new value of {@code taskFolders} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code taskFolders} field changed
     */
    public OutlookTaskGroup withTaskFolders(List<OutlookTaskFolder> taskFolders) {
        OutlookTaskGroup _x = _copy();
        _x.changedFields = changedFields.add("taskFolders");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTaskGroup");
        _x.taskFolders = taskFolders;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OutlookTaskGroup patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OutlookTaskGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OutlookTaskGroup put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OutlookTaskGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OutlookTaskGroup _copy() {
        OutlookTaskGroup _x = new OutlookTaskGroup();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.changeKey = changeKey;
        _x.groupKey = groupKey;
        _x.isDefaultGroup = isDefaultGroup;
        _x.name = name;
        _x.taskFolders = taskFolders;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OutlookTaskGroup[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("changeKey=");
        b.append(this.changeKey);
        b.append(", ");
        b.append("groupKey=");
        b.append(this.groupKey);
        b.append(", ");
        b.append("isDefaultGroup=");
        b.append(this.isDefaultGroup);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("taskFolders=");
        b.append(this.taskFolders);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
