package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DateTimeTimeZone;
import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.complex.PatternedRecurrence;
import odata.msgraph.client.beta.entity.collection.request.AttachmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.enums.Importance;
import odata.msgraph.client.beta.enums.Sensitivity;
import odata.msgraph.client.beta.enums.TaskStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "assignedTo", 
    "body", 
    "completedDateTime", 
    "dueDateTime", 
    "hasAttachments", 
    "importance", 
    "isReminderOn", 
    "owner", 
    "parentFolderId", 
    "recurrence", 
    "reminderDateTime", 
    "sensitivity", 
    "startDateTime", 
    "status", 
    "subject", 
    "attachments", 
    "multiValueExtendedProperties", 
    "singleValueExtendedProperties"})
@JsonInclude(Include.NON_NULL)
public class OutlookTask extends OutlookItem implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.outlookTask";
    }

    @JsonProperty("assignedTo")
    protected String assignedTo;

    @JsonProperty("body")
    protected ItemBody body;

    @JsonProperty("completedDateTime")
    protected DateTimeTimeZone completedDateTime;

    @JsonProperty("dueDateTime")
    protected DateTimeTimeZone dueDateTime;

    @JsonProperty("hasAttachments")
    protected Boolean hasAttachments;

    @JsonProperty("importance")
    protected Importance importance;

    @JsonProperty("isReminderOn")
    protected Boolean isReminderOn;

    @JsonProperty("owner")
    protected String owner;

    @JsonProperty("parentFolderId")
    protected String parentFolderId;

    @JsonProperty("recurrence")
    protected PatternedRecurrence recurrence;

    @JsonProperty("reminderDateTime")
    protected DateTimeTimeZone reminderDateTime;

    @JsonProperty("sensitivity")
    protected Sensitivity sensitivity;

    @JsonProperty("startDateTime")
    protected DateTimeTimeZone startDateTime;

    @JsonProperty("status")
    protected TaskStatus status;

    @JsonProperty("subject")
    protected String subject;

    @JsonProperty("attachments")
    protected List<Attachment> attachments;

    @JsonProperty("multiValueExtendedProperties")
    protected List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties;

    @JsonProperty("singleValueExtendedProperties")
    protected List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties;

    protected OutlookTask() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOutlookTask() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> categories;
        private String categoriesNextLink;
        private String changeKey;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private String assignedTo;
        private ItemBody body;
        private DateTimeTimeZone completedDateTime;
        private DateTimeTimeZone dueDateTime;
        private Boolean hasAttachments;
        private Importance importance;
        private Boolean isReminderOn;
        private String owner;
        private String parentFolderId;
        private PatternedRecurrence recurrence;
        private DateTimeTimeZone reminderDateTime;
        private Sensitivity sensitivity;
        private DateTimeTimeZone startDateTime;
        private TaskStatus status;
        private String subject;
        private List<Attachment> attachments;
        private List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties;
        private List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder categories(List<String> categories) {
            this.categories = categories;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder categories(String... categories) {
            return categories(Arrays.asList(categories));
        }

        public Builder categoriesNextLink(String categoriesNextLink) {
            this.categoriesNextLink = categoriesNextLink;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder changeKey(String changeKey) {
            this.changeKey = changeKey;
            this.changedFields = changedFields.add("changeKey");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder assignedTo(String assignedTo) {
            this.assignedTo = assignedTo;
            this.changedFields = changedFields.add("assignedTo");
            return this;
        }

        public Builder body(ItemBody body) {
            this.body = body;
            this.changedFields = changedFields.add("body");
            return this;
        }

        public Builder completedDateTime(DateTimeTimeZone completedDateTime) {
            this.completedDateTime = completedDateTime;
            this.changedFields = changedFields.add("completedDateTime");
            return this;
        }

        public Builder dueDateTime(DateTimeTimeZone dueDateTime) {
            this.dueDateTime = dueDateTime;
            this.changedFields = changedFields.add("dueDateTime");
            return this;
        }

        public Builder hasAttachments(Boolean hasAttachments) {
            this.hasAttachments = hasAttachments;
            this.changedFields = changedFields.add("hasAttachments");
            return this;
        }

        public Builder importance(Importance importance) {
            this.importance = importance;
            this.changedFields = changedFields.add("importance");
            return this;
        }

        public Builder isReminderOn(Boolean isReminderOn) {
            this.isReminderOn = isReminderOn;
            this.changedFields = changedFields.add("isReminderOn");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            this.changedFields = changedFields.add("parentFolderId");
            return this;
        }

        public Builder recurrence(PatternedRecurrence recurrence) {
            this.recurrence = recurrence;
            this.changedFields = changedFields.add("recurrence");
            return this;
        }

        public Builder reminderDateTime(DateTimeTimeZone reminderDateTime) {
            this.reminderDateTime = reminderDateTime;
            this.changedFields = changedFields.add("reminderDateTime");
            return this;
        }

        public Builder sensitivity(Sensitivity sensitivity) {
            this.sensitivity = sensitivity;
            this.changedFields = changedFields.add("sensitivity");
            return this;
        }

        public Builder startDateTime(DateTimeTimeZone startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder status(TaskStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param attachments
         *            value of {@code attachments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder attachments(List<Attachment> attachments) {
            this.attachments = attachments;
            this.changedFields = changedFields.add("attachments");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param attachments
         *            value of {@code attachments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder attachments(Attachment... attachments) {
            return attachments(Arrays.asList(attachments));
        }

        public Builder multiValueExtendedProperties(List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
            this.multiValueExtendedProperties = multiValueExtendedProperties;
            this.changedFields = changedFields.add("multiValueExtendedProperties");
            return this;
        }

        public Builder multiValueExtendedProperties(MultiValueLegacyExtendedProperty... multiValueExtendedProperties) {
            return multiValueExtendedProperties(Arrays.asList(multiValueExtendedProperties));
        }

        public Builder singleValueExtendedProperties(List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
            this.singleValueExtendedProperties = singleValueExtendedProperties;
            this.changedFields = changedFields.add("singleValueExtendedProperties");
            return this;
        }

        public Builder singleValueExtendedProperties(SingleValueLegacyExtendedProperty... singleValueExtendedProperties) {
            return singleValueExtendedProperties(Arrays.asList(singleValueExtendedProperties));
        }

        public OutlookTask build() {
            OutlookTask _x = new OutlookTask();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.outlookTask";
            _x.id = id;
            _x.categories = categories;
            _x.categoriesNextLink = categoriesNextLink;
            _x.changeKey = changeKey;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.assignedTo = assignedTo;
            _x.body = body;
            _x.completedDateTime = completedDateTime;
            _x.dueDateTime = dueDateTime;
            _x.hasAttachments = hasAttachments;
            _x.importance = importance;
            _x.isReminderOn = isReminderOn;
            _x.owner = owner;
            _x.parentFolderId = parentFolderId;
            _x.recurrence = recurrence;
            _x.reminderDateTime = reminderDateTime;
            _x.sensitivity = sensitivity;
            _x.startDateTime = startDateTime;
            _x.status = status;
            _x.subject = subject;
            _x.attachments = attachments;
            _x.multiValueExtendedProperties = multiValueExtendedProperties;
            _x.singleValueExtendedProperties = singleValueExtendedProperties;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="assignedTo")
    @JsonIgnore
    public Optional<String> getAssignedTo() {
        return Optional.ofNullable(assignedTo);
    }

    public OutlookTask withAssignedTo(String assignedTo) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("assignedTo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.assignedTo = assignedTo;
        return _x;
    }

    @Property(name="body")
    @JsonIgnore
    public Optional<ItemBody> getBody() {
        return Optional.ofNullable(body);
    }

    public OutlookTask withBody(ItemBody body) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("body");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.body = body;
        return _x;
    }

    @Property(name="completedDateTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getCompletedDateTime() {
        return Optional.ofNullable(completedDateTime);
    }

    public OutlookTask withCompletedDateTime(DateTimeTimeZone completedDateTime) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("completedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.completedDateTime = completedDateTime;
        return _x;
    }

    @Property(name="dueDateTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getDueDateTime() {
        return Optional.ofNullable(dueDateTime);
    }

    public OutlookTask withDueDateTime(DateTimeTimeZone dueDateTime) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("dueDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.dueDateTime = dueDateTime;
        return _x;
    }

    @Property(name="hasAttachments")
    @JsonIgnore
    public Optional<Boolean> getHasAttachments() {
        return Optional.ofNullable(hasAttachments);
    }

    public OutlookTask withHasAttachments(Boolean hasAttachments) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("hasAttachments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.hasAttachments = hasAttachments;
        return _x;
    }

    @Property(name="importance")
    @JsonIgnore
    public Optional<Importance> getImportance() {
        return Optional.ofNullable(importance);
    }

    public OutlookTask withImportance(Importance importance) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("importance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.importance = importance;
        return _x;
    }

    @Property(name="isReminderOn")
    @JsonIgnore
    public Optional<Boolean> getIsReminderOn() {
        return Optional.ofNullable(isReminderOn);
    }

    public OutlookTask withIsReminderOn(Boolean isReminderOn) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("isReminderOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.isReminderOn = isReminderOn;
        return _x;
    }

    @Property(name="owner")
    @JsonIgnore
    public Optional<String> getOwner() {
        return Optional.ofNullable(owner);
    }

    public OutlookTask withOwner(String owner) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("owner");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.owner = owner;
        return _x;
    }

    @Property(name="parentFolderId")
    @JsonIgnore
    public Optional<String> getParentFolderId() {
        return Optional.ofNullable(parentFolderId);
    }

    public OutlookTask withParentFolderId(String parentFolderId) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("parentFolderId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.parentFolderId = parentFolderId;
        return _x;
    }

    @Property(name="recurrence")
    @JsonIgnore
    public Optional<PatternedRecurrence> getRecurrence() {
        return Optional.ofNullable(recurrence);
    }

    public OutlookTask withRecurrence(PatternedRecurrence recurrence) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("recurrence");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.recurrence = recurrence;
        return _x;
    }

    @Property(name="reminderDateTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getReminderDateTime() {
        return Optional.ofNullable(reminderDateTime);
    }

    public OutlookTask withReminderDateTime(DateTimeTimeZone reminderDateTime) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("reminderDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.reminderDateTime = reminderDateTime;
        return _x;
    }

    @Property(name="sensitivity")
    @JsonIgnore
    public Optional<Sensitivity> getSensitivity() {
        return Optional.ofNullable(sensitivity);
    }

    public OutlookTask withSensitivity(Sensitivity sensitivity) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("sensitivity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.sensitivity = sensitivity;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public OutlookTask withStartDateTime(DateTimeTimeZone startDateTime) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<TaskStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public OutlookTask withStatus(TaskStatus status) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.status = status;
        return _x;
    }

    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    public OutlookTask withSubject(String subject) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.subject = subject;
        return _x;
    }

    public OutlookTask withUnmappedField(String name, Object value) {
        OutlookTask _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property attachments
     */
    @NavigationProperty(name="attachments")
    @JsonIgnore
    public AttachmentCollectionRequest getAttachments() {
        return new AttachmentCollectionRequest(
                        contextPath.addSegment("attachments"), Optional.ofNullable(attachments));
    }

    @NavigationProperty(name="multiValueExtendedProperties")
    @JsonIgnore
    public MultiValueLegacyExtendedPropertyCollectionRequest getMultiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"), Optional.ofNullable(multiValueExtendedProperties));
    }

    @NavigationProperty(name="singleValueExtendedProperties")
    @JsonIgnore
    public SingleValueLegacyExtendedPropertyCollectionRequest getSingleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"), Optional.ofNullable(singleValueExtendedProperties));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code attachments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @param attachments
     *            new value of {@code attachments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code attachments} field changed
     */
    public OutlookTask withAttachments(List<Attachment> attachments) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("attachments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.attachments = attachments;
        return _x;
    }

    public OutlookTask withMultiValueExtendedProperties(List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("multiValueExtendedProperties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.multiValueExtendedProperties = multiValueExtendedProperties;
        return _x;
    }

    public OutlookTask withSingleValueExtendedProperties(List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        OutlookTask _x = _copy();
        _x.changedFields = changedFields.add("singleValueExtendedProperties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTask");
        _x.singleValueExtendedProperties = singleValueExtendedProperties;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OutlookTask patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OutlookTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OutlookTask put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OutlookTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OutlookTask _copy() {
        OutlookTask _x = new OutlookTask();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.categories = categories;
        _x.changeKey = changeKey;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.assignedTo = assignedTo;
        _x.body = body;
        _x.completedDateTime = completedDateTime;
        _x.dueDateTime = dueDateTime;
        _x.hasAttachments = hasAttachments;
        _x.importance = importance;
        _x.isReminderOn = isReminderOn;
        _x.owner = owner;
        _x.parentFolderId = parentFolderId;
        _x.recurrence = recurrence;
        _x.reminderDateTime = reminderDateTime;
        _x.sensitivity = sensitivity;
        _x.startDateTime = startDateTime;
        _x.status = status;
        _x.subject = subject;
        _x.attachments = attachments;
        _x.multiValueExtendedProperties = multiValueExtendedProperties;
        _x.singleValueExtendedProperties = singleValueExtendedProperties;
        return _x;
    }

    @Action(name = "complete")
    @JsonIgnore
    public CollectionPageNonEntityRequest<OutlookTask> complete() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.complete"), OutlookTask.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OutlookTask[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("categories=");
        b.append(this.categories);
        b.append(", ");
        b.append("changeKey=");
        b.append(this.changeKey);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("assignedTo=");
        b.append(this.assignedTo);
        b.append(", ");
        b.append("body=");
        b.append(this.body);
        b.append(", ");
        b.append("completedDateTime=");
        b.append(this.completedDateTime);
        b.append(", ");
        b.append("dueDateTime=");
        b.append(this.dueDateTime);
        b.append(", ");
        b.append("hasAttachments=");
        b.append(this.hasAttachments);
        b.append(", ");
        b.append("importance=");
        b.append(this.importance);
        b.append(", ");
        b.append("isReminderOn=");
        b.append(this.isReminderOn);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("parentFolderId=");
        b.append(this.parentFolderId);
        b.append(", ");
        b.append("recurrence=");
        b.append(this.recurrence);
        b.append(", ");
        b.append("reminderDateTime=");
        b.append(this.reminderDateTime);
        b.append(", ");
        b.append("sensitivity=");
        b.append(this.sensitivity);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("attachments=");
        b.append(this.attachments);
        b.append(", ");
        b.append("multiValueExtendedProperties=");
        b.append(this.multiValueExtendedProperties);
        b.append(", ");
        b.append("singleValueExtendedProperties=");
        b.append(this.singleValueExtendedProperties);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
