package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpMethod;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.StreamUploader;
import com.github.davidmoten.odata.client.StreamUploaderChunked;
import com.github.davidmoten.odata.client.StreamUploaderSingleCall;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.UploadStrategy;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.LoginPageTextVisibilitySettings;

@JsonPropertyOrder({
    "@odata.type", 
    "backgroundColor", 
    "backgroundImage", 
    "backgroundImageRelativeUrl", 
    "bannerLogo", 
    "bannerLogoRelativeUrl", 
    "cdnList", 
    "customAccountResetCredentialsUrl", 
    "customCannotAccessYourAccountText", 
    "customCannotAccessYourAccountUrl", 
    "customForgotMyPasswordText", 
    "customPrivacyAndCookiesText", 
    "customPrivacyAndCookiesUrl", 
    "customResetItNowText", 
    "customTermsOfUseText", 
    "customTermsOfUseUrl", 
    "favicon", 
    "faviconRelativeUrl", 
    "headerBackgroundColor", 
    "loginPageTextVisibilitySettings", 
    "signInPageText", 
    "squareLogo", 
    "squareLogoRelativeUrl", 
    "usernameHintText"})
@JsonInclude(Include.NON_NULL)
public class OrganizationalBrandingProperties extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.organizationalBrandingProperties";
    }

    @JsonProperty("backgroundColor")
    protected String backgroundColor;

    @JsonProperty("backgroundImage")
    protected String backgroundImage;

    @JsonProperty("backgroundImageRelativeUrl")
    protected String backgroundImageRelativeUrl;

    @JsonProperty("bannerLogo")
    protected String bannerLogo;

    @JsonProperty("bannerLogoRelativeUrl")
    protected String bannerLogoRelativeUrl;

    @JsonProperty("cdnList")
    protected List<String> cdnList;

    @JsonProperty("cdnList@nextLink")
    protected String cdnListNextLink;

    @JsonProperty("customAccountResetCredentialsUrl")
    protected String customAccountResetCredentialsUrl;

    @JsonProperty("customCannotAccessYourAccountText")
    protected String customCannotAccessYourAccountText;

    @JsonProperty("customCannotAccessYourAccountUrl")
    protected String customCannotAccessYourAccountUrl;

    @JsonProperty("customForgotMyPasswordText")
    protected String customForgotMyPasswordText;

    @JsonProperty("customPrivacyAndCookiesText")
    protected String customPrivacyAndCookiesText;

    @JsonProperty("customPrivacyAndCookiesUrl")
    protected String customPrivacyAndCookiesUrl;

    @JsonProperty("customResetItNowText")
    protected String customResetItNowText;

    @JsonProperty("customTermsOfUseText")
    protected String customTermsOfUseText;

    @JsonProperty("customTermsOfUseUrl")
    protected String customTermsOfUseUrl;

    @JsonProperty("favicon")
    protected String favicon;

    @JsonProperty("faviconRelativeUrl")
    protected String faviconRelativeUrl;

    @JsonProperty("headerBackgroundColor")
    protected String headerBackgroundColor;

    @JsonProperty("loginPageTextVisibilitySettings")
    protected LoginPageTextVisibilitySettings loginPageTextVisibilitySettings;

    @JsonProperty("signInPageText")
    protected String signInPageText;

    @JsonProperty("squareLogo")
    protected String squareLogo;

    @JsonProperty("squareLogoRelativeUrl")
    protected String squareLogoRelativeUrl;

    @JsonProperty("usernameHintText")
    protected String usernameHintText;

    protected OrganizationalBrandingProperties() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="backgroundColor")
    @JsonIgnore
    public Optional<String> getBackgroundColor() {
        return Optional.ofNullable(backgroundColor);
    }

    public OrganizationalBrandingProperties withBackgroundColor(String backgroundColor) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("backgroundColor");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.backgroundColor = backgroundColor;
        return _x;
    }

    @Property(name="backgroundImage")
    @JsonIgnore
    public Optional<StreamProvider> getBackgroundImage() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "backgroundImage", backgroundImage);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code backgroundImage} property, using HTTP POST.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="backgroundImage")
    public Optional<StreamUploaderSingleCall> postBackgroundImage() {
        return postBackgroundImage(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code backgroundImage} property, using HTTP POST.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="backgroundImage")
    public Optional<StreamUploaderChunked> postChunkedBackgroundImage() {
        return postBackgroundImage(UploadStrategy.chunked());
    }

    @Property(name="backgroundImage")
    public <T extends StreamUploader<T>> Optional<T> postBackgroundImage(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("backgroundImage"), this, "backgroundImage", HttpMethod.POST);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code backgroundImage} property, using HTTP PATCH.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="backgroundImage")
    public Optional<StreamUploaderSingleCall> patchBackgroundImage() {
        return patchBackgroundImage(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code backgroundImage} property, using HTTP PATCH.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="backgroundImage")
    public Optional<StreamUploaderChunked> patchChunkedBackgroundImage() {
        return patchBackgroundImage(UploadStrategy.chunked());
    }

    @Property(name="backgroundImage")
    public <T extends StreamUploader<T>> Optional<T> patchBackgroundImage(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("backgroundImage"), this, "backgroundImage", HttpMethod.PATCH);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code backgroundImage} property, using HTTP PUT.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="backgroundImage")
    public Optional<StreamUploaderSingleCall> putBackgroundImage() {
        return putBackgroundImage(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code backgroundImage} property, using HTTP PUT.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="backgroundImage")
    public Optional<StreamUploaderChunked> putChunkedBackgroundImage() {
        return putBackgroundImage(UploadStrategy.chunked());
    }

    @Property(name="backgroundImage")
    public <T extends StreamUploader<T>> Optional<T> putBackgroundImage(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("backgroundImage"), this, "backgroundImage", HttpMethod.PUT);
    }

    @Property(name="backgroundImageRelativeUrl")
    @JsonIgnore
    public Optional<String> getBackgroundImageRelativeUrl() {
        return Optional.ofNullable(backgroundImageRelativeUrl);
    }

    public OrganizationalBrandingProperties withBackgroundImageRelativeUrl(String backgroundImageRelativeUrl) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("backgroundImageRelativeUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.backgroundImageRelativeUrl = backgroundImageRelativeUrl;
        return _x;
    }

    @Property(name="bannerLogo")
    @JsonIgnore
    public Optional<StreamProvider> getBannerLogo() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "bannerLogo", bannerLogo);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code bannerLogo} property, using HTTP POST.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="bannerLogo")
    public Optional<StreamUploaderSingleCall> postBannerLogo() {
        return postBannerLogo(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code bannerLogo} property, using HTTP POST.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="bannerLogo")
    public Optional<StreamUploaderChunked> postChunkedBannerLogo() {
        return postBannerLogo(UploadStrategy.chunked());
    }

    @Property(name="bannerLogo")
    public <T extends StreamUploader<T>> Optional<T> postBannerLogo(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("bannerLogo"), this, "bannerLogo", HttpMethod.POST);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code bannerLogo} property, using HTTP PATCH.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="bannerLogo")
    public Optional<StreamUploaderSingleCall> patchBannerLogo() {
        return patchBannerLogo(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code bannerLogo} property, using HTTP PATCH.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="bannerLogo")
    public Optional<StreamUploaderChunked> patchChunkedBannerLogo() {
        return patchBannerLogo(UploadStrategy.chunked());
    }

    @Property(name="bannerLogo")
    public <T extends StreamUploader<T>> Optional<T> patchBannerLogo(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("bannerLogo"), this, "bannerLogo", HttpMethod.PATCH);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code bannerLogo} property, using HTTP PUT.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="bannerLogo")
    public Optional<StreamUploaderSingleCall> putBannerLogo() {
        return putBannerLogo(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code bannerLogo} property, using HTTP PUT.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="bannerLogo")
    public Optional<StreamUploaderChunked> putChunkedBannerLogo() {
        return putBannerLogo(UploadStrategy.chunked());
    }

    @Property(name="bannerLogo")
    public <T extends StreamUploader<T>> Optional<T> putBannerLogo(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("bannerLogo"), this, "bannerLogo", HttpMethod.PUT);
    }

    @Property(name="bannerLogoRelativeUrl")
    @JsonIgnore
    public Optional<String> getBannerLogoRelativeUrl() {
        return Optional.ofNullable(bannerLogoRelativeUrl);
    }

    public OrganizationalBrandingProperties withBannerLogoRelativeUrl(String bannerLogoRelativeUrl) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("bannerLogoRelativeUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.bannerLogoRelativeUrl = bannerLogoRelativeUrl;
        return _x;
    }

    @Property(name="cdnList")
    @JsonIgnore
    public CollectionPage<String> getCdnList() {
        return new CollectionPage<String>(contextPath, String.class, this.cdnList, Optional.ofNullable(cdnListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public OrganizationalBrandingProperties withCdnList(List<String> cdnList) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("cdnList");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.cdnList = cdnList;
        return _x;
    }

    @Property(name="cdnList")
    @JsonIgnore
    public CollectionPage<String> getCdnList(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.cdnList, Optional.ofNullable(cdnListNextLink), Collections.emptyList(), options);
    }

    @Property(name="customAccountResetCredentialsUrl")
    @JsonIgnore
    public Optional<String> getCustomAccountResetCredentialsUrl() {
        return Optional.ofNullable(customAccountResetCredentialsUrl);
    }

    public OrganizationalBrandingProperties withCustomAccountResetCredentialsUrl(String customAccountResetCredentialsUrl) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("customAccountResetCredentialsUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.customAccountResetCredentialsUrl = customAccountResetCredentialsUrl;
        return _x;
    }

    @Property(name="customCannotAccessYourAccountText")
    @JsonIgnore
    public Optional<String> getCustomCannotAccessYourAccountText() {
        return Optional.ofNullable(customCannotAccessYourAccountText);
    }

    public OrganizationalBrandingProperties withCustomCannotAccessYourAccountText(String customCannotAccessYourAccountText) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("customCannotAccessYourAccountText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.customCannotAccessYourAccountText = customCannotAccessYourAccountText;
        return _x;
    }

    @Property(name="customCannotAccessYourAccountUrl")
    @JsonIgnore
    public Optional<String> getCustomCannotAccessYourAccountUrl() {
        return Optional.ofNullable(customCannotAccessYourAccountUrl);
    }

    public OrganizationalBrandingProperties withCustomCannotAccessYourAccountUrl(String customCannotAccessYourAccountUrl) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("customCannotAccessYourAccountUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.customCannotAccessYourAccountUrl = customCannotAccessYourAccountUrl;
        return _x;
    }

    @Property(name="customForgotMyPasswordText")
    @JsonIgnore
    public Optional<String> getCustomForgotMyPasswordText() {
        return Optional.ofNullable(customForgotMyPasswordText);
    }

    public OrganizationalBrandingProperties withCustomForgotMyPasswordText(String customForgotMyPasswordText) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("customForgotMyPasswordText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.customForgotMyPasswordText = customForgotMyPasswordText;
        return _x;
    }

    @Property(name="customPrivacyAndCookiesText")
    @JsonIgnore
    public Optional<String> getCustomPrivacyAndCookiesText() {
        return Optional.ofNullable(customPrivacyAndCookiesText);
    }

    public OrganizationalBrandingProperties withCustomPrivacyAndCookiesText(String customPrivacyAndCookiesText) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("customPrivacyAndCookiesText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.customPrivacyAndCookiesText = customPrivacyAndCookiesText;
        return _x;
    }

    @Property(name="customPrivacyAndCookiesUrl")
    @JsonIgnore
    public Optional<String> getCustomPrivacyAndCookiesUrl() {
        return Optional.ofNullable(customPrivacyAndCookiesUrl);
    }

    public OrganizationalBrandingProperties withCustomPrivacyAndCookiesUrl(String customPrivacyAndCookiesUrl) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("customPrivacyAndCookiesUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.customPrivacyAndCookiesUrl = customPrivacyAndCookiesUrl;
        return _x;
    }

    @Property(name="customResetItNowText")
    @JsonIgnore
    public Optional<String> getCustomResetItNowText() {
        return Optional.ofNullable(customResetItNowText);
    }

    public OrganizationalBrandingProperties withCustomResetItNowText(String customResetItNowText) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("customResetItNowText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.customResetItNowText = customResetItNowText;
        return _x;
    }

    @Property(name="customTermsOfUseText")
    @JsonIgnore
    public Optional<String> getCustomTermsOfUseText() {
        return Optional.ofNullable(customTermsOfUseText);
    }

    public OrganizationalBrandingProperties withCustomTermsOfUseText(String customTermsOfUseText) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("customTermsOfUseText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.customTermsOfUseText = customTermsOfUseText;
        return _x;
    }

    @Property(name="customTermsOfUseUrl")
    @JsonIgnore
    public Optional<String> getCustomTermsOfUseUrl() {
        return Optional.ofNullable(customTermsOfUseUrl);
    }

    public OrganizationalBrandingProperties withCustomTermsOfUseUrl(String customTermsOfUseUrl) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("customTermsOfUseUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.customTermsOfUseUrl = customTermsOfUseUrl;
        return _x;
    }

    @Property(name="favicon")
    @JsonIgnore
    public Optional<StreamProvider> getFavicon() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "favicon", favicon);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code favicon} property, using HTTP POST.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="favicon")
    public Optional<StreamUploaderSingleCall> postFavicon() {
        return postFavicon(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code favicon} property, using HTTP POST.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="favicon")
    public Optional<StreamUploaderChunked> postChunkedFavicon() {
        return postFavicon(UploadStrategy.chunked());
    }

    @Property(name="favicon")
    public <T extends StreamUploader<T>> Optional<T> postFavicon(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("favicon"), this, "favicon", HttpMethod.POST);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code favicon} property, using HTTP PATCH.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="favicon")
    public Optional<StreamUploaderSingleCall> patchFavicon() {
        return patchFavicon(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code favicon} property, using HTTP PATCH.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="favicon")
    public Optional<StreamUploaderChunked> patchChunkedFavicon() {
        return patchFavicon(UploadStrategy.chunked());
    }

    @Property(name="favicon")
    public <T extends StreamUploader<T>> Optional<T> patchFavicon(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("favicon"), this, "favicon", HttpMethod.PATCH);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code favicon} property, using HTTP PUT.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="favicon")
    public Optional<StreamUploaderSingleCall> putFavicon() {
        return putFavicon(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code favicon} property, using HTTP PUT.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="favicon")
    public Optional<StreamUploaderChunked> putChunkedFavicon() {
        return putFavicon(UploadStrategy.chunked());
    }

    @Property(name="favicon")
    public <T extends StreamUploader<T>> Optional<T> putFavicon(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("favicon"), this, "favicon", HttpMethod.PUT);
    }

    @Property(name="faviconRelativeUrl")
    @JsonIgnore
    public Optional<String> getFaviconRelativeUrl() {
        return Optional.ofNullable(faviconRelativeUrl);
    }

    public OrganizationalBrandingProperties withFaviconRelativeUrl(String faviconRelativeUrl) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("faviconRelativeUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.faviconRelativeUrl = faviconRelativeUrl;
        return _x;
    }

    @Property(name="headerBackgroundColor")
    @JsonIgnore
    public Optional<String> getHeaderBackgroundColor() {
        return Optional.ofNullable(headerBackgroundColor);
    }

    public OrganizationalBrandingProperties withHeaderBackgroundColor(String headerBackgroundColor) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("headerBackgroundColor");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.headerBackgroundColor = headerBackgroundColor;
        return _x;
    }

    @Property(name="loginPageTextVisibilitySettings")
    @JsonIgnore
    public Optional<LoginPageTextVisibilitySettings> getLoginPageTextVisibilitySettings() {
        return Optional.ofNullable(loginPageTextVisibilitySettings);
    }

    public OrganizationalBrandingProperties withLoginPageTextVisibilitySettings(LoginPageTextVisibilitySettings loginPageTextVisibilitySettings) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("loginPageTextVisibilitySettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.loginPageTextVisibilitySettings = loginPageTextVisibilitySettings;
        return _x;
    }

    @Property(name="signInPageText")
    @JsonIgnore
    public Optional<String> getSignInPageText() {
        return Optional.ofNullable(signInPageText);
    }

    public OrganizationalBrandingProperties withSignInPageText(String signInPageText) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("signInPageText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.signInPageText = signInPageText;
        return _x;
    }

    @Property(name="squareLogo")
    @JsonIgnore
    public Optional<StreamProvider> getSquareLogo() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "squareLogo", squareLogo);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code squareLogo} property, using HTTP POST.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="squareLogo")
    public Optional<StreamUploaderSingleCall> postSquareLogo() {
        return postSquareLogo(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code squareLogo} property, using HTTP POST.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="squareLogo")
    public Optional<StreamUploaderChunked> postChunkedSquareLogo() {
        return postSquareLogo(UploadStrategy.chunked());
    }

    @Property(name="squareLogo")
    public <T extends StreamUploader<T>> Optional<T> postSquareLogo(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("squareLogo"), this, "squareLogo", HttpMethod.POST);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code squareLogo} property, using HTTP PATCH.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="squareLogo")
    public Optional<StreamUploaderSingleCall> patchSquareLogo() {
        return patchSquareLogo(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code squareLogo} property, using HTTP PATCH.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="squareLogo")
    public Optional<StreamUploaderChunked> patchChunkedSquareLogo() {
        return patchSquareLogo(UploadStrategy.chunked());
    }

    @Property(name="squareLogo")
    public <T extends StreamUploader<T>> Optional<T> patchSquareLogo(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("squareLogo"), this, "squareLogo", HttpMethod.PATCH);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code squareLogo} property, using HTTP PUT.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="squareLogo")
    public Optional<StreamUploaderSingleCall> putSquareLogo() {
        return putSquareLogo(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code squareLogo} property, using HTTP PUT.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="squareLogo")
    public Optional<StreamUploaderChunked> putChunkedSquareLogo() {
        return putSquareLogo(UploadStrategy.chunked());
    }

    @Property(name="squareLogo")
    public <T extends StreamUploader<T>> Optional<T> putSquareLogo(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("squareLogo"), this, "squareLogo", HttpMethod.PUT);
    }

    @Property(name="squareLogoRelativeUrl")
    @JsonIgnore
    public Optional<String> getSquareLogoRelativeUrl() {
        return Optional.ofNullable(squareLogoRelativeUrl);
    }

    public OrganizationalBrandingProperties withSquareLogoRelativeUrl(String squareLogoRelativeUrl) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("squareLogoRelativeUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.squareLogoRelativeUrl = squareLogoRelativeUrl;
        return _x;
    }

    @Property(name="usernameHintText")
    @JsonIgnore
    public Optional<String> getUsernameHintText() {
        return Optional.ofNullable(usernameHintText);
    }

    public OrganizationalBrandingProperties withUsernameHintText(String usernameHintText) {
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = changedFields.add("usernameHintText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBrandingProperties");
        _x.usernameHintText = usernameHintText;
        return _x;
    }

    public OrganizationalBrandingProperties withUnmappedField(String name, Object value) {
        OrganizationalBrandingProperties _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OrganizationalBrandingProperties patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OrganizationalBrandingProperties put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OrganizationalBrandingProperties _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OrganizationalBrandingProperties _copy() {
        OrganizationalBrandingProperties _x = new OrganizationalBrandingProperties();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.backgroundColor = backgroundColor;
        _x.backgroundImage = backgroundImage;
        _x.backgroundImageRelativeUrl = backgroundImageRelativeUrl;
        _x.bannerLogo = bannerLogo;
        _x.bannerLogoRelativeUrl = bannerLogoRelativeUrl;
        _x.cdnList = cdnList;
        _x.customAccountResetCredentialsUrl = customAccountResetCredentialsUrl;
        _x.customCannotAccessYourAccountText = customCannotAccessYourAccountText;
        _x.customCannotAccessYourAccountUrl = customCannotAccessYourAccountUrl;
        _x.customForgotMyPasswordText = customForgotMyPasswordText;
        _x.customPrivacyAndCookiesText = customPrivacyAndCookiesText;
        _x.customPrivacyAndCookiesUrl = customPrivacyAndCookiesUrl;
        _x.customResetItNowText = customResetItNowText;
        _x.customTermsOfUseText = customTermsOfUseText;
        _x.customTermsOfUseUrl = customTermsOfUseUrl;
        _x.favicon = favicon;
        _x.faviconRelativeUrl = faviconRelativeUrl;
        _x.headerBackgroundColor = headerBackgroundColor;
        _x.loginPageTextVisibilitySettings = loginPageTextVisibilitySettings;
        _x.signInPageText = signInPageText;
        _x.squareLogo = squareLogo;
        _x.squareLogoRelativeUrl = squareLogoRelativeUrl;
        _x.usernameHintText = usernameHintText;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OrganizationalBrandingProperties[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("backgroundColor=");
        b.append(this.backgroundColor);
        b.append(", ");
        b.append("backgroundImage=");
        b.append(this.backgroundImage);
        b.append(", ");
        b.append("backgroundImageRelativeUrl=");
        b.append(this.backgroundImageRelativeUrl);
        b.append(", ");
        b.append("bannerLogo=");
        b.append(this.bannerLogo);
        b.append(", ");
        b.append("bannerLogoRelativeUrl=");
        b.append(this.bannerLogoRelativeUrl);
        b.append(", ");
        b.append("cdnList=");
        b.append(this.cdnList);
        b.append(", ");
        b.append("customAccountResetCredentialsUrl=");
        b.append(this.customAccountResetCredentialsUrl);
        b.append(", ");
        b.append("customCannotAccessYourAccountText=");
        b.append(this.customCannotAccessYourAccountText);
        b.append(", ");
        b.append("customCannotAccessYourAccountUrl=");
        b.append(this.customCannotAccessYourAccountUrl);
        b.append(", ");
        b.append("customForgotMyPasswordText=");
        b.append(this.customForgotMyPasswordText);
        b.append(", ");
        b.append("customPrivacyAndCookiesText=");
        b.append(this.customPrivacyAndCookiesText);
        b.append(", ");
        b.append("customPrivacyAndCookiesUrl=");
        b.append(this.customPrivacyAndCookiesUrl);
        b.append(", ");
        b.append("customResetItNowText=");
        b.append(this.customResetItNowText);
        b.append(", ");
        b.append("customTermsOfUseText=");
        b.append(this.customTermsOfUseText);
        b.append(", ");
        b.append("customTermsOfUseUrl=");
        b.append(this.customTermsOfUseUrl);
        b.append(", ");
        b.append("favicon=");
        b.append(this.favicon);
        b.append(", ");
        b.append("faviconRelativeUrl=");
        b.append(this.faviconRelativeUrl);
        b.append(", ");
        b.append("headerBackgroundColor=");
        b.append(this.headerBackgroundColor);
        b.append(", ");
        b.append("loginPageTextVisibilitySettings=");
        b.append(this.loginPageTextVisibilitySettings);
        b.append(", ");
        b.append("signInPageText=");
        b.append(this.signInPageText);
        b.append(", ");
        b.append("squareLogo=");
        b.append(this.squareLogo);
        b.append(", ");
        b.append("squareLogoRelativeUrl=");
        b.append(this.squareLogoRelativeUrl);
        b.append(", ");
        b.append("usernameHintText=");
        b.append(this.usernameHintText);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
