package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.SectionLinks;
import odata.msgraph.client.beta.entity.collection.request.OnenotePageCollectionRequest;
import odata.msgraph.client.beta.entity.request.NotebookRequest;
import odata.msgraph.client.beta.entity.request.SectionGroupRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "isDefault", 
    "links", 
    "pagesUrl", 
    "pages", 
    "parentNotebook", 
    "parentSectionGroup"})
@JsonInclude(Include.NON_NULL)
public class OnenoteSection extends OnenoteEntityHierarchyModel implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onenoteSection";
    }

    @JsonProperty("isDefault")
    protected Boolean isDefault;

    @JsonProperty("links")
    protected SectionLinks links;

    @JsonProperty("pagesUrl")
    protected String pagesUrl;

    @JsonProperty("pages")
    protected List<OnenotePage> pages;

    @JsonProperty("parentNotebook")
    protected Notebook parentNotebook;

    @JsonProperty("parentSectionGroup")
    protected SectionGroup parentSectionGroup;

    protected OnenoteSection() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOnenoteSection() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String self;
        private OffsetDateTime createdDateTime;
        private IdentitySet createdBy;
        private String displayName;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private Boolean isDefault;
        private SectionLinks links;
        private String pagesUrl;
        private List<OnenotePage> pages;
        private Notebook parentNotebook;
        private SectionGroup parentSectionGroup;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder self(String self) {
            this.self = self;
            this.changedFields = changedFields.add("self");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = changedFields.add("isDefault");
            return this;
        }

        public Builder links(SectionLinks links) {
            this.links = links;
            this.changedFields = changedFields.add("links");
            return this;
        }

        public Builder pagesUrl(String pagesUrl) {
            this.pagesUrl = pagesUrl;
            this.changedFields = changedFields.add("pagesUrl");
            return this;
        }

        public Builder pages(List<OnenotePage> pages) {
            this.pages = pages;
            this.changedFields = changedFields.add("pages");
            return this;
        }

        public Builder pages(OnenotePage... pages) {
            return pages(Arrays.asList(pages));
        }

        public Builder parentNotebook(Notebook parentNotebook) {
            this.parentNotebook = parentNotebook;
            this.changedFields = changedFields.add("parentNotebook");
            return this;
        }

        public Builder parentSectionGroup(SectionGroup parentSectionGroup) {
            this.parentSectionGroup = parentSectionGroup;
            this.changedFields = changedFields.add("parentSectionGroup");
            return this;
        }

        public OnenoteSection build() {
            OnenoteSection _x = new OnenoteSection();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.onenoteSection";
            _x.id = id;
            _x.self = self;
            _x.createdDateTime = createdDateTime;
            _x.createdBy = createdBy;
            _x.displayName = displayName;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.isDefault = isDefault;
            _x.links = links;
            _x.pagesUrl = pagesUrl;
            _x.pages = pages;
            _x.parentNotebook = parentNotebook;
            _x.parentSectionGroup = parentSectionGroup;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="isDefault")
    @JsonIgnore
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(isDefault);
    }

    public OnenoteSection withIsDefault(Boolean isDefault) {
        OnenoteSection _x = _copy();
        _x.changedFields = changedFields.add("isDefault");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenoteSection");
        _x.isDefault = isDefault;
        return _x;
    }

    @Property(name="links")
    @JsonIgnore
    public Optional<SectionLinks> getLinks() {
        return Optional.ofNullable(links);
    }

    public OnenoteSection withLinks(SectionLinks links) {
        OnenoteSection _x = _copy();
        _x.changedFields = changedFields.add("links");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenoteSection");
        _x.links = links;
        return _x;
    }

    @Property(name="pagesUrl")
    @JsonIgnore
    public Optional<String> getPagesUrl() {
        return Optional.ofNullable(pagesUrl);
    }

    public OnenoteSection withPagesUrl(String pagesUrl) {
        OnenoteSection _x = _copy();
        _x.changedFields = changedFields.add("pagesUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenoteSection");
        _x.pagesUrl = pagesUrl;
        return _x;
    }

    public OnenoteSection withUnmappedField(String name, Object value) {
        OnenoteSection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="pages")
    @JsonIgnore
    public OnenotePageCollectionRequest getPages() {
        return new OnenotePageCollectionRequest(
                        contextPath.addSegment("pages"), Optional.ofNullable(pages));
    }

    @NavigationProperty(name="parentNotebook")
    @JsonIgnore
    public NotebookRequest getParentNotebook() {
        return new NotebookRequest(contextPath.addSegment("parentNotebook"), Optional.ofNullable(parentNotebook));
    }

    @NavigationProperty(name="parentSectionGroup")
    @JsonIgnore
    public SectionGroupRequest getParentSectionGroup() {
        return new SectionGroupRequest(contextPath.addSegment("parentSectionGroup"), Optional.ofNullable(parentSectionGroup));
    }

    public OnenoteSection withPages(List<OnenotePage> pages) {
        OnenoteSection _x = _copy();
        _x.changedFields = changedFields.add("pages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenoteSection");
        _x.pages = pages;
        return _x;
    }

    public OnenoteSection withParentNotebook(Notebook parentNotebook) {
        OnenoteSection _x = _copy();
        _x.changedFields = changedFields.add("parentNotebook");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenoteSection");
        _x.parentNotebook = parentNotebook;
        return _x;
    }

    public OnenoteSection withParentSectionGroup(SectionGroup parentSectionGroup) {
        OnenoteSection _x = _copy();
        _x.changedFields = changedFields.add("parentSectionGroup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenoteSection");
        _x.parentSectionGroup = parentSectionGroup;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnenoteSection patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OnenoteSection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnenoteSection put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OnenoteSection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OnenoteSection _copy() {
        OnenoteSection _x = new OnenoteSection();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.self = self;
        _x.createdDateTime = createdDateTime;
        _x.createdBy = createdBy;
        _x.displayName = displayName;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.isDefault = isDefault;
        _x.links = links;
        _x.pagesUrl = pagesUrl;
        _x.pages = pages;
        _x.parentNotebook = parentNotebook;
        _x.parentSectionGroup = parentSectionGroup;
        return _x;
    }

    @Action(name = "copyToNotebook")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation> copyToNotebook(String id, String groupId, String renameAs, String siteCollectionId, String siteId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .put("renameAs", "Edm.String", Checks.checkIsAscii(renameAs))
            .put("siteCollectionId", "Edm.String", Checks.checkIsAscii(siteCollectionId))
            .put("siteId", "Edm.String", Checks.checkIsAscii(siteId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copyToNotebook"), OnenoteOperation.class, _parameters);
    }

    @Action(name = "copyToSectionGroup")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation> copyToSectionGroup(String id, String groupId, String renameAs, String siteCollectionId, String siteId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .put("renameAs", "Edm.String", Checks.checkIsAscii(renameAs))
            .put("siteCollectionId", "Edm.String", Checks.checkIsAscii(siteCollectionId))
            .put("siteId", "Edm.String", Checks.checkIsAscii(siteId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copyToSectionGroup"), OnenoteOperation.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnenoteSection[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("self=");
        b.append(this.self);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("isDefault=");
        b.append(this.isDefault);
        b.append(", ");
        b.append("links=");
        b.append(this.links);
        b.append(", ");
        b.append("pagesUrl=");
        b.append(this.pagesUrl);
        b.append(", ");
        b.append("pages=");
        b.append(this.pages);
        b.append(", ");
        b.append("parentNotebook=");
        b.append(this.parentNotebook);
        b.append(", ");
        b.append("parentSectionGroup=");
        b.append(this.parentSectionGroup);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
