package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.HttpMethod;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.StreamUploader;
import com.github.davidmoten.odata.client.StreamUploaderChunked;
import com.github.davidmoten.odata.client.StreamUploaderSingleCall;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.UploadStrategy;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.OnenotePagePreview;
import odata.msgraph.client.beta.complex.OnenotePatchContentCommand;
import odata.msgraph.client.beta.complex.PageLinks;
import odata.msgraph.client.beta.entity.request.NotebookRequest;
import odata.msgraph.client.beta.entity.request.OnenoteSectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "content", 
    "contentUrl", 
    "createdByAppId", 
    "lastModifiedDateTime", 
    "level", 
    "links", 
    "order", 
    "title", 
    "userTags", 
    "parentNotebook", 
    "parentSection"})
@JsonInclude(Include.NON_NULL)
public class OnenotePage extends OnenoteEntitySchemaObjectModel implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onenotePage";
    }

    @JsonProperty("content")
    protected String content;

    @JsonProperty("contentUrl")
    protected String contentUrl;

    @JsonProperty("createdByAppId")
    protected String createdByAppId;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("level")
    protected Integer level;

    @JsonProperty("links")
    protected PageLinks links;

    @JsonProperty("order")
    protected Integer order;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("userTags")
    protected List<String> userTags;

    @JsonProperty("userTags@nextLink")
    protected String userTagsNextLink;

    @JsonProperty("parentNotebook")
    protected Notebook parentNotebook;

    @JsonProperty("parentSection")
    protected OnenoteSection parentSection;

    protected OnenotePage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOnenotePage() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String self;
        private OffsetDateTime createdDateTime;
        private String content;
        private String contentUrl;
        private String createdByAppId;
        private OffsetDateTime lastModifiedDateTime;
        private Integer level;
        private PageLinks links;
        private Integer order;
        private String title;
        private List<String> userTags;
        private String userTagsNextLink;
        private Notebook parentNotebook;
        private OnenoteSection parentSection;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder self(String self) {
            this.self = self;
            this.changedFields = changedFields.add("self");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder contentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
            this.changedFields = changedFields.add("contentUrl");
            return this;
        }

        public Builder createdByAppId(String createdByAppId) {
            this.createdByAppId = createdByAppId;
            this.changedFields = changedFields.add("createdByAppId");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder level(Integer level) {
            this.level = level;
            this.changedFields = changedFields.add("level");
            return this;
        }

        public Builder links(PageLinks links) {
            this.links = links;
            this.changedFields = changedFields.add("links");
            return this;
        }

        public Builder order(Integer order) {
            this.order = order;
            this.changedFields = changedFields.add("order");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder userTags(List<String> userTags) {
            this.userTags = userTags;
            this.changedFields = changedFields.add("userTags");
            return this;
        }

        public Builder userTags(String... userTags) {
            return userTags(Arrays.asList(userTags));
        }

        public Builder userTagsNextLink(String userTagsNextLink) {
            this.userTagsNextLink = userTagsNextLink;
            this.changedFields = changedFields.add("userTags");
            return this;
        }

        public Builder parentNotebook(Notebook parentNotebook) {
            this.parentNotebook = parentNotebook;
            this.changedFields = changedFields.add("parentNotebook");
            return this;
        }

        public Builder parentSection(OnenoteSection parentSection) {
            this.parentSection = parentSection;
            this.changedFields = changedFields.add("parentSection");
            return this;
        }

        public OnenotePage build() {
            OnenotePage _x = new OnenotePage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.onenotePage";
            _x.id = id;
            _x.self = self;
            _x.createdDateTime = createdDateTime;
            _x.content = content;
            _x.contentUrl = contentUrl;
            _x.createdByAppId = createdByAppId;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.level = level;
            _x.links = links;
            _x.order = order;
            _x.title = title;
            _x.userTags = userTags;
            _x.userTagsNextLink = userTagsNextLink;
            _x.parentNotebook = parentNotebook;
            _x.parentSection = parentSection;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<StreamProvider> getContent() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "content", content);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code content} property, using HTTP POST.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderSingleCall> postContent() {
        return postContent(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code content} property, using HTTP POST.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderChunked> postChunkedContent() {
        return postContent(UploadStrategy.chunked());
    }

    @Property(name="content")
    public <T extends StreamUploader<T>> Optional<T> postContent(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("content"), this, "content", HttpMethod.POST);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code content} property, using HTTP PATCH.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderSingleCall> patchContent() {
        return patchContent(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code content} property, using HTTP PATCH.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderChunked> patchChunkedContent() {
        return patchContent(UploadStrategy.chunked());
    }

    @Property(name="content")
    public <T extends StreamUploader<T>> Optional<T> patchContent(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("content"), this, "content", HttpMethod.PATCH);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code content} property, using HTTP PUT.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderSingleCall> putContent() {
        return putContent(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code content} property, using HTTP PUT.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderChunked> putChunkedContent() {
        return putContent(UploadStrategy.chunked());
    }

    @Property(name="content")
    public <T extends StreamUploader<T>> Optional<T> putContent(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("content"), this, "content", HttpMethod.PUT);
    }

    @Property(name="contentUrl")
    @JsonIgnore
    public Optional<String> getContentUrl() {
        return Optional.ofNullable(contentUrl);
    }

    public OnenotePage withContentUrl(String contentUrl) {
        OnenotePage _x = _copy();
        _x.changedFields = changedFields.add("contentUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenotePage");
        _x.contentUrl = contentUrl;
        return _x;
    }

    @Property(name="createdByAppId")
    @JsonIgnore
    public Optional<String> getCreatedByAppId() {
        return Optional.ofNullable(createdByAppId);
    }

    public OnenotePage withCreatedByAppId(String createdByAppId) {
        OnenotePage _x = _copy();
        _x.changedFields = changedFields.add("createdByAppId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenotePage");
        _x.createdByAppId = createdByAppId;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public OnenotePage withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        OnenotePage _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenotePage");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="level")
    @JsonIgnore
    public Optional<Integer> getLevel() {
        return Optional.ofNullable(level);
    }

    public OnenotePage withLevel(Integer level) {
        OnenotePage _x = _copy();
        _x.changedFields = changedFields.add("level");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenotePage");
        _x.level = level;
        return _x;
    }

    @Property(name="links")
    @JsonIgnore
    public Optional<PageLinks> getLinks() {
        return Optional.ofNullable(links);
    }

    public OnenotePage withLinks(PageLinks links) {
        OnenotePage _x = _copy();
        _x.changedFields = changedFields.add("links");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenotePage");
        _x.links = links;
        return _x;
    }

    @Property(name="order")
    @JsonIgnore
    public Optional<Integer> getOrder() {
        return Optional.ofNullable(order);
    }

    public OnenotePage withOrder(Integer order) {
        OnenotePage _x = _copy();
        _x.changedFields = changedFields.add("order");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenotePage");
        _x.order = order;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public OnenotePage withTitle(String title) {
        OnenotePage _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenotePage");
        _x.title = title;
        return _x;
    }

    @Property(name="userTags")
    @JsonIgnore
    public CollectionPage<String> getUserTags() {
        return new CollectionPage<String>(contextPath, String.class, this.userTags, Optional.ofNullable(userTagsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public OnenotePage withUserTags(List<String> userTags) {
        OnenotePage _x = _copy();
        _x.changedFields = changedFields.add("userTags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenotePage");
        _x.userTags = userTags;
        return _x;
    }

    @Property(name="userTags")
    @JsonIgnore
    public CollectionPage<String> getUserTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.userTags, Optional.ofNullable(userTagsNextLink), Collections.emptyList(), options);
    }

    public OnenotePage withUnmappedField(String name, Object value) {
        OnenotePage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="parentNotebook")
    @JsonIgnore
    public NotebookRequest getParentNotebook() {
        return new NotebookRequest(contextPath.addSegment("parentNotebook"), Optional.ofNullable(parentNotebook));
    }

    @NavigationProperty(name="parentSection")
    @JsonIgnore
    public OnenoteSectionRequest getParentSection() {
        return new OnenoteSectionRequest(contextPath.addSegment("parentSection"), Optional.ofNullable(parentSection));
    }

    public OnenotePage withParentNotebook(Notebook parentNotebook) {
        OnenotePage _x = _copy();
        _x.changedFields = changedFields.add("parentNotebook");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenotePage");
        _x.parentNotebook = parentNotebook;
        return _x;
    }

    public OnenotePage withParentSection(OnenoteSection parentSection) {
        OnenotePage _x = _copy();
        _x.changedFields = changedFields.add("parentSection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenotePage");
        _x.parentSection = parentSection;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * If suitable metadata found a StreamProvider is returned otherwise returns
     * {@code Optional.empty()}. Normally for a stream to be available this entity
     * needs to have been hydrated with full metadata. Consider calling the builder
     * method {@code .metadataFull()} when getting this instance (either directly or
     * as part of a collection).
     *
     * @return StreamProvider if suitable metadata found otherwise returns
     *         {@code Optional.empty()}
     */
    @JsonIgnore
    public Optional<StreamProvider> getStream() {
        return RequestHelper.createStream(contextPath, this);
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnenotePage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OnenotePage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnenotePage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OnenotePage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OnenotePage _copy() {
        OnenotePage _x = new OnenotePage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.self = self;
        _x.createdDateTime = createdDateTime;
        _x.content = content;
        _x.contentUrl = contentUrl;
        _x.createdByAppId = createdByAppId;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.level = level;
        _x.links = links;
        _x.order = order;
        _x.title = title;
        _x.userTags = userTags;
        _x.parentNotebook = parentNotebook;
        _x.parentSection = parentSection;
        return _x;
    }

    @Action(name = "copyToSection")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation> copyToSection(String id, String groupId, String siteCollectionId, String siteId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .put("siteCollectionId", "Edm.String", Checks.checkIsAscii(siteCollectionId))
            .put("siteId", "Edm.String", Checks.checkIsAscii(siteId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copyToSection"), OnenoteOperation.class, _parameters);
    }

    @Action(name = "onenotePatchContent")
    @JsonIgnore
    public ActionRequestNoReturn onenotePatchContent(List<OnenotePatchContentCommand> commands) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("commands", "Collection(microsoft.graph.onenotePatchContentCommand)", commands)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.onenotePatchContent"), _parameters);
    }

    @Function(name = "preview")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<OnenotePagePreview> preview() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<OnenotePagePreview>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.preview"), OnenotePagePreview.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnenotePage[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("self=");
        b.append(this.self);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("contentUrl=");
        b.append(this.contentUrl);
        b.append(", ");
        b.append("createdByAppId=");
        b.append(this.createdByAppId);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("level=");
        b.append(this.level);
        b.append(", ");
        b.append("links=");
        b.append(this.links);
        b.append(", ");
        b.append("order=");
        b.append(this.order);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("userTags=");
        b.append(this.userTags);
        b.append(", ");
        b.append("parentNotebook=");
        b.append(this.parentNotebook);
        b.append(", ");
        b.append("parentSection=");
        b.append(this.parentSection);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
