package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.OnPremisesAgentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PublishedResourceCollectionRequest;
import odata.msgraph.client.beta.enums.OnPremisesPublishingType;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "isDefault", 
    "publishingType"})
@JsonInclude(Include.NON_NULL)
public class OnPremisesAgentGroup extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onPremisesAgentGroup";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isDefault")
    protected Boolean isDefault;

    @JsonProperty("publishingType")
    protected OnPremisesPublishingType publishingType;

    protected OnPremisesAgentGroup() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOnPremisesAgentGroup() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private Boolean isDefault;
        private OnPremisesPublishingType publishingType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = changedFields.add("isDefault");
            return this;
        }

        public Builder publishingType(OnPremisesPublishingType publishingType) {
            this.publishingType = publishingType;
            this.changedFields = changedFields.add("publishingType");
            return this;
        }

        public OnPremisesAgentGroup build() {
            OnPremisesAgentGroup _x = new OnPremisesAgentGroup();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.onPremisesAgentGroup";
            _x.id = id;
            _x.displayName = displayName;
            _x.isDefault = isDefault;
            _x.publishingType = publishingType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public OnPremisesAgentGroup withDisplayName(String displayName) {
        OnPremisesAgentGroup _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesAgentGroup");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isDefault")
    @JsonIgnore
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(isDefault);
    }

    public OnPremisesAgentGroup withIsDefault(Boolean isDefault) {
        OnPremisesAgentGroup _x = _copy();
        _x.changedFields = changedFields.add("isDefault");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesAgentGroup");
        _x.isDefault = isDefault;
        return _x;
    }

    @Property(name="publishingType")
    @JsonIgnore
    public Optional<OnPremisesPublishingType> getPublishingType() {
        return Optional.ofNullable(publishingType);
    }

    public OnPremisesAgentGroup withPublishingType(OnPremisesPublishingType publishingType) {
        OnPremisesAgentGroup _x = _copy();
        _x.changedFields = changedFields.add("publishingType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesAgentGroup");
        _x.publishingType = publishingType;
        return _x;
    }

    public OnPremisesAgentGroup withUnmappedField(String name, Object value) {
        OnPremisesAgentGroup _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="agents")
    @JsonIgnore
    public OnPremisesAgentCollectionRequest getAgents() {
        return new OnPremisesAgentCollectionRequest(
                        contextPath.addSegment("agents"), RequestHelper.getValue(unmappedFields, "agents"));
    }

    @NavigationProperty(name="publishedResources")
    @JsonIgnore
    public PublishedResourceCollectionRequest getPublishedResources() {
        return new PublishedResourceCollectionRequest(
                        contextPath.addSegment("publishedResources"), RequestHelper.getValue(unmappedFields, "publishedResources"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnPremisesAgentGroup patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OnPremisesAgentGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnPremisesAgentGroup put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OnPremisesAgentGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OnPremisesAgentGroup _copy() {
        OnPremisesAgentGroup _x = new OnPremisesAgentGroup();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.isDefault = isDefault;
        _x.publishingType = publishingType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnPremisesAgentGroup[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isDefault=");
        b.append(this.isDefault);
        b.append(", ");
        b.append("publishingType=");
        b.append(this.publishingType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
